/**************************************************************************************
* @file         : MediaDataPoolConfig.cpp
* @author       : ECV2-AGN7KOR
* @addtogroup   : AppHmi_Tuner
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "hall_std_if.h"

#define DATAPOOL_WRITE_DISABLED 1

#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_hmi_04_if.h"
#endif

#include "MediaDataPoolConfig.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::MediaHall::
#include "trcGenProj/Header/MediaDataPoolConfig.cpp.trc.h"
#endif

// Instantiate the static class object
MediaDataPoolConfig* MediaDataPoolConfig::_dpMedia = NULL;


/**
 * Description     : Constructor of MediaDataPoolConfig
 *
 *
 * @param[in]      : none
 * @param[in]      : None
 * @return         : void
 */
MediaDataPoolConfig::MediaDataPoolConfig()
{
}


void MediaDataPoolConfig::setLastActiveCamportUSBSource(const tU32 camportUSBSourceId)
{
   dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource dpMediaCamportUSBSourceObj;
   tS32 s32Status = dpMediaCamportUSBSourceObj.s32SetData(camportUSBSourceId);
   ETG_TRACE_USR3(("MediaDataPoolConfig::setLastActiveCamportUSBSource camportUSBSourceId , s32Status :%d :%d", camportUSBSourceId, s32Status));
}


tU32 MediaDataPoolConfig::getLastActiveCamportUSBSource()
{
   dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource dpMediaCamportUSBSourceObj;
   ETG_TRACE_USR4(("MediaDataPoolConfig::getLastActiveCamportUSBSource statusdata : %d", dpMediaCamportUSBSourceObj.tGetData()));
   return dpMediaCamportUSBSourceObj.tGetData();
}


void MediaDataPoolConfig::setLastActiveRouterUSBSource(const tU32 routerUSBSourceId)
{
   dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource dpMediaRouterUSBSourceObj;
   tS32 s32Status = dpMediaRouterUSBSourceObj.s32SetData(routerUSBSourceId);
   ETG_TRACE_USR3(("MediaDataPoolConfig::setLastActiveRouterUSBSource routerUSBSourceId, s32Status :%d :%d", routerUSBSourceId, s32Status));
}


tU32 MediaDataPoolConfig::getLastActiveRouterUSBSource()
{
   dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource dpMediaRouterUSBSourceObj;
   ETG_TRACE_USR4(("MediaDataPoolConfig::getRouterUSBSourceStatus statusdata : %d", dpMediaRouterUSBSourceObj.tGetData()));
   return dpMediaRouterUSBSourceObj.tGetData();
}


/**
 * Description     : getInstance, returns the instance of the class
 *                   MediaDataPoolConfig
 * @param[in]      : none
 * @param[in]      : none
 * @return         : MediaDataPoolConfig*
 */
MediaDataPoolConfig* MediaDataPoolConfig::getInstance()
{
   if (_dpMedia == NULL)
   {
      _dpMedia = new MediaDataPoolConfig();
   }
   return _dpMedia;
}


/**
 * Description     : Destructor of MediaDataPoolConfig
 *
 * @param[in]      : none
 * @param[in]      : None
 * @return         : void
 */
MediaDataPoolConfig::~MediaDataPoolConfig()
{
   if (_dpMedia != NULL)
   {
      delete _dpMedia;
   }
   _dpMedia = NULL;
}
