/* ***************************************************************************************
* FILE:          HMIModelTabImplementation.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HMIModelTabImplementation.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*21.09.17 Rev. 0.1 Ruchi (RBEI/ECG5)
* 		  		   Initial Revision.
*************************************************************************************** */

#if !defined(_HMI_MODEL_TABIMPLEMENTATION_H)
#define _HMI_MODEL_TABIMPLEMENTATION_H
#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_MediaStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Core/MediaDefines.h"
#include "HMIModelListImplementation.h"
#ifndef WINDOWS_SIMULATION
#include "mplay_MediaPlayer_FI.h"
#endif
#include "../../../Common/DataModel/ListRegistry.h"

using namespace Courier;

namespace App {
namespace Core {

/***********************************************************************
	Structure and Typedef Declaration
***********************************************************************/


class HMIModelTabImplementation : public ListImplementation
{
   private:
#ifdef WINDOWS_SIMULATION
   public: // the constructor, copy constructor and assignment opearator will be public only for DemoApp
#endif
      HMIModelTabImplementation();
      HMIModelTabImplementation(const HMIModelTabImplementation&);
      HMIModelTabImplementation& operator =(const HMIModelTabImplementation&);
      virtual tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);

      DataBindingItem<MediaTabActiveStateDataBindingSource> _dbSetTabActive;
      DataBindingItem<MediaTabDisabledStateDataBindingSource> _dbSetTabDisable;
      DataBindingItem<VideoTabActivationDataBindingSource> _dbSetVideoTabActive;
      DataBindingItem<TabVideoSourceDataBindingSource> _dbTabVideoSource;
      DataBindingItem<TabNextPrevIndexDataBindingSource> _tabNextPrevIndex;

      int32_t m_u32Previouslisttype;
      int8_t  m_u8startindex;
      int8_t  m_u8PageDirection;
      bool isdevicetagchanged;


#ifdef WINDOWS_SIMULATION
   private:
#endif
      static HMIModelTabImplementation* _theTabModelInstance;
      // Incomming events ...
      virtual bool onCourierMessage(const Courier::StartupMsg& oMsg);
      virtual bool onCourierMessage(const ListDateProviderReqMsg& oMsg);
      bool onCourierMessage(const ListChangedUpdMsg& oMsg);
      bool onCourierMessage(const ChangeHorListTabButtonRegMsg& oMsg);
      bool onCourierMessage(const HorTabButtonPageUpReqMsg& oMsg);
      bool onCourierMessage(const HorTabButtonPageDownReqMsg& oMsg);
      bool onCourierMessage(const BTBrowsePressedUpdMsg& oMsg);
      bool onCourierMessage(const VideoBrowsePressedUpdMsg& oMsg);
      bool onCourierMessage(const BrowseBtnPressedUpdMsg& oMsg);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MEDIA_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(ListDateProviderReqMsg)
      ON_COURIER_MESSAGE(ListChangedUpdMsg)
      ON_COURIER_MESSAGE(ChangeHorListTabButtonRegMsg)
      ON_COURIER_MESSAGE(HorTabButtonPageUpReqMsg)
      ON_COURIER_MESSAGE(HorTabButtonPageDownReqMsg)
      ON_COURIER_MESSAGE(BTBrowsePressedUpdMsg)
      ON_COURIER_MESSAGE(VideoBrowsePressedUpdMsg)
      ON_COURIER_MESSAGE(BrowseBtnPressedUpdMsg)

      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)

      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()

      COURIER_MSG_MAP_ENDS()

   public:

      virtual ~HMIModelTabImplementation();
      bool Init();
      static HMIModelTabImplementation& getInstance();
      void removeInstance();

      void vOnRequestTabList(int32_t u32Listtype);

      void setActiveStateVisibility(uint32_t SelectMediaTab);
      void setTitleTabStateVisibility();
      void setArtistTabStateVisibility();
      void setAlbumTabStateVisibility();
      void setGenreTabStateVisibility();
      void setFolderTabStateVisibility();
      void setPlaylistTabStateVisibility();
      void setAudiobookTabStateVisibility();
      void setPodcastTabStateVisibility();
      void setVideoTabStateVisibility();
      void setTabStatus(bool CurrentStatus);

      void IsDeviceTagChanged(bool devicetagchangestate);
      void resetVerticalStartindex();
};


}
}


#endif // _HMI_MODEL_COMPONENT_H
