/* ***************************************************************************************
* FILE:          HMIModelTabImplementation.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HMIModelTabImplementation.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*21.09.17 Rev. 0.1 Sonia (RBEI/ECG5)
* 		  		   Initial Revision.
*************************************************************************************** */

#if !defined(_HMI_MODEL_LISTIMPLEMENTATION_H)
#define _HMI_MODEL_LISTIMPLEMENTATION_H

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_MediaStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Core/MediaDefines.h"
#include "Core/MediaClientHandler/MediaClientHandler.h"
#include "Core/Utils/ListUtilityDatabase.h"
#ifndef WINDOWS_SIMULATION
#include "mplay_MediaPlayer_FI.h"
#endif
#include "DataModel/ListRegistry.h"

using namespace Courier;
#endif

#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
#include "asf/core/Types.h"
#endif

namespace App {
namespace Core {

/***********************************************************************
	Structure and Typedef Declaration
***********************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
struct VerticalListSize
{
   float ListheightWithoutButtons;
   float ListheightWithBackButton;
   float ListheightWithBackAndAllButton;
   float BackButtonSize;
   float DefaultBackButtonSize;
   float AllAlbumAndTitleButtonSize;
   float DefaultAllAlbumAndTitleButtonSize;
   float ListWidth;
   float ScrollBarWidth;
};


#endif

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
class HMIModelListImplementation : public ListImplementation
{
   private:
#ifdef WINDOWS_SIMULATION
   public: // the constructor, copy constructor and assignment opearator will be public only for DemoApp
#endif
      HMIModelListImplementation();
      HMIModelListImplementation(const HMIModelListImplementation&);
      HMIModelListImplementation& operator =(const HMIModelListImplementation&);
#else
class HMIModelListImplementation
{
   public:
      HMIModelListImplementation();
      HMIModelListImplementation(const HMIModelListImplementation&);
      HMIModelListImplementation& operator =(const HMIModelListImplementation&);
#endif

#ifdef WINDOWS_SIMULATION
   private:
#endif
      static HMIModelListImplementation* _theModelListImplementationInstance;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      DataBindingItem<MediaListIDDataBindingSource> _dbMediaListId;
      DataBindingItem<MediaListIDDataBindingSource> _dbAlbumListVisibility;

      //DataBindingItem<MediaListVisibilityDataBindingSource> _dbListVisibility;
      DataBindingItem<BrowserScreenListSizeDataBindingSource> m_BrowserScreenListSize;

      int32_t _uint32ListID;
      int32_t _uint32WindowSize;
      int32_t _uint32StartIndex;

      std::map<uint32, ListUtilityDatabase* > _listMap;
      std::map <uint32, uint32> m_ListIDtoListTypeMap;
      VerticalListSize _verticalListsize;

      // Incomming events ...
      virtual bool onCourierMessage(const Courier::StartupMsg& oMsg);
      virtual bool onCourierMessage(const ListDateProviderReqMsg& oMsg);

      virtual tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);

      void initVerticalListSize();

      void browseListSetting(uint32_t listId, uint32_t rowVal);
      void vBackButtonListOperation();
      void HandleButtonAllRequest();
      void createInstanceIfNull(uint32 listType);
      void insertNewUtilityDatabaseToListMap(uint32 listType, ListUtilityDatabase* listUtilityDatabase);
      void createListTypeMap();
      //uint32_t calculateWindowSize(uint32_t windowstart, uint32_t windowsize, uint32_t ListSize);
      void vCreateMapListIDtoListType();

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MEDIA_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(ListDateProviderReqMsg)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      ON_COURIER_MESSAGE(ListChangedUpdMsg)

      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()

      COURIER_MSG_MAP_ENDS()
#endif

   public:

      static HMIModelListImplementation& getInstance();
      void removeInstance();

      virtual ~HMIModelListImplementation();

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      virtual bool onCourierMessage(const ButtonReactionMsg& oMsg);
      virtual bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);

      bool onCourierMessage(const ListChangedUpdMsg& oMsg);

      void UpdateFolderList(std::vector<std::string>  _sFolderListItemText);
      void UpdateFolderFileList(std::vector<std::string>  _sFolderFileListItemText);
      void updateCurrentListId(uint32 currentListId);
      void IsHorListTabSelected(bool status);
      void IsAllSelected(bool status);
      void clearListBrowsingHistory();
#endif
      uint32 getNextListId();
      bool IsSongListId(uint32 listId);
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
      void setCurrentListId(uint32 currentListId);
      void setIsAllSelected(bool isAllSelected);
#endif
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      uint32_t  m_u8startindex;
      uint32_t getVerticalStartIndex();
      void setVerticalStartIndex(uint32_t startIndex);
      void IsFolderBrowse(bool status);
      void IsNewList(bool status);
      bool getIsNewList();
      void IsSongPlayedFromFolder();
      void populateEmptyList(bool isPreviousButtonAvailable);
      void updateListSize();
      void updateListHandle(uint32);
      void updateRequestedListHandle(uint32);

      void ClearListType();

      void updateVerticalListSize(float, float, float, float, float);
      void updateBackAndAllButtonVisibility(bool, bool);
      void updateListVisibility(bool);
      void updateAllButtonState(bool, bool, Candera::String);
      void updateIsNewListRequest(bool status);
      void UpdateCurrentListSize(uint32_t u32currentListSize, uint32_t u32currentListType);
      void SetCurrentListType(uint32_t currentListType);

      void OneItemListDataProviderToGui(std::vector<std::string> _ListItemText, uint32_t u32CurrentListType);
      void TwoItemListDataProviderToGui(std::vector<media_TwoTextListInfo> _ListItemText, uint32_t u32CurrentListType);
      void updateSizeAndVisibilityDuringListBuild(uint32_t u32CurrentListType);
      void setWaitAnimationState(enAnimationReqType state);
      void setIsPlaySongFromListRequested(bool);
#endif
      uint32 updateDataIconInList(uint32_t u32CurrentListType);
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      uint32_t m_uint32ListSize;
      uint32_t m_uint32ListType;
      uint32_t m_currentListType;
      std::vector<uint32_t> _currentListSize;
      bool _isHorListTabSelected;
      bool _isNewListEntry;
      std::vector<uint32> _listBrowsingHistory;
      bool _isFolderBrowse;
      bool _isRootFolder;
      bool _isGenreAlbum;
      bool _isSongPlayedFromFolder;
      bool _isNewListRequest;
      uint32 _requestedListHandle;
      uint32 _currentListHandle;

#endif
      uint32 _currentListId;
      uint32 _prevListId;
      uint32 _isAllSelected;
      bool _isPlaySongFromListRequested;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      static enAnimationReqType _waitAnimationState ;
#endif
};


}
}


#endif // _HMI_MODEL_COMPONENT_H
