/************************************************************************
 *FILE			: clMetaData.cpp
 *SW-COMPONENT	: Media
 *DESCRIPTION	: clMetaData class which is storing Current playing songs details,
 *				  Hierarchy Informations and store Browsing level Information
 *COPYRIGHT		: (c) 2017-2019 Robert Bosch Car Multimedia GmbH
 *HISTORY:
 *
 *
 *
 *21.09.17 Rev. 0.1 Ruchi (RBEI/ECG5)
 * 		  			Initial Revision.
 ************************************************************************/
#include "clMetaData.h"
#include "Core/MediaDefines.h"
#include "assert.h"
#include <string.h>
#include<stdio.h>
#include "hall_std_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS         TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL             TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX          "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX               App::Core::clMetaData::

#include "trcGenProj/Header/clMetaData.cpp.trc.h"
#endif

namespace App {
namespace Core {

/***************************************************************************
	 * Handling for Constructor & Destructor & Instance <start>
  ***************************************************************************/
clMetaData* clMetaData::_theInstance = 0;

clMetaData& clMetaData::getInstance()
{
   if (_theInstance == 0)
   {
      _theInstance = new clMetaData();
   }

   assert(_theInstance);
   return *_theInstance;
}


void clMetaData::removeInstance()
{
   if (_theInstance)
   {
      delete _theInstance;
      _theInstance = 0;
   }
}


/************************************************************************
*FUNCTION		: clMetaData
*DESCRIPTION	: Constructor. Initializes the member variables.
*PARAMETER		:
*PARAMETER		:
*RETURNVALUE	: NA
************************************************************************/
clMetaData::clMetaData()
{
   m_szSourceName = "";
   m_szArtistName = "";
   m_szAlbumName = "";
   m_szTitleName = "";
   m_szFilename = "";
   m_u32MediaFileType = MEDIA_C_VALUE_ZERO;
   m_u32ListHandle = MEDIA_C_VALUE_ZERO;
   m_u32Listtype = MEDIA_C_VALUE_ZERO;
   m_u32TotalTime = MEDIA_C_VALUE_ZERO;
   m_u32PlayTime = MEDIA_C_VALUE_ZERO;
   m_u32PrevDevGrp = MEDIA_C_VALUE_ZERO;
   m_u32SrcID = MEDIA_C_VALUE_ZERO;
   m_u32SubSrcID = MEDIA_C_VALUE_ZERO;
   m_iUSBDeviceNum = -1;
   m_bShuffleSupported = true;
   m_bRepeatSupported = true;
   m_bBrowseSupported = true;
   m_bCamportSourceAvailable = false;
   m_bHdmiSourceAvailable = false;
   m_guiStartupInitiated = false;
   m_ApplicationState = hmibase::IN_BACKGROUND;
}


/************************************************************************
*FUNCTION		: clMetaData
*DESCRIPTION	: Destructor.
*PARAMETER		:
*RETURNVALUE	: NA
************************************************************************/
clMetaData::~clMetaData()
{
   vclearTrackInfo();
}


/***************************************************************************
	 * Handling for Constructor & Destructor & Instance <End>
 ***************************************************************************/
/***************************************************************************
	 * setter for Current Playing Song Parameters <Start>
***************************************************************************/
void clMetaData::setSourceName(std::string sSourceName)
{
   ETG_TRACE_USR4(("clMetaData::setSourceName SourceName is %s ", sSourceName.c_str()));

   m_szSourceName = sSourceName;
}


void clMetaData::setArtistName(std::string sArtistName)
{
   m_szArtistName = sArtistName;
}


void clMetaData::setAlbumName(std::string sAlbumName)
{
   m_szAlbumName = sAlbumName;
}


void clMetaData::setTitleName(std::string sTitleName)
{
   m_szTitleName = sTitleName;
}


void clMetaData::setFilename(std::string sFilename)
{
   m_szFilename = sFilename;
}


void clMetaData::setMediaFileType(int32 sMediaFileType)
{
   m_u32MediaFileType = sMediaFileType;
}


void clMetaData::setListHandle(int32 sListHandle)
{
   m_u32ListHandle = sListHandle;
}


void clMetaData::setTotalTime(int32 u32TotalTime)
{
   m_u32TotalTime = u32TotalTime;
}


void clMetaData::setPlayTime(int32 u32PlayTime)
{
   ETG_TRACE_USR4(("clMetaData::setPlayTime u32PlayTime is %d ", u32PlayTime));

   m_u32PlayTime = u32PlayTime;
}


void clMetaData::setPreviousDevGrp(int32 u32PrevDevGrp)
{
   m_u32PrevDevGrp = u32PrevDevGrp;
}


void clMetaData::setSrcID(int32 u32SrcID)
{
   m_u32SrcID = u32SrcID;
}


void clMetaData::setSubSrcID(int32 u32SubSrcID)
{
   m_u32SubSrcID = u32SubSrcID;
}


void clMetaData::setUSBDeviceNumber(int iUSBDeviceNum)
{
   m_iUSBDeviceNum = iUSBDeviceNum;
}


void clMetaData::setShuffleSupported(bool bShuffleSupported)
{
   m_bShuffleSupported = bShuffleSupported;
}


void clMetaData::setRepeatSupported(bool bRepeatSupported)
{
   m_bRepeatSupported = bRepeatSupported;
}


void clMetaData::setBrowseSupported(bool bBrowseSupported)
{
   m_bBrowseSupported = bBrowseSupported;
}


void clMetaData::setUsbCamportAvailable(bool bAvail)
{
   m_bCamportSourceAvailable = bAvail;
}


void clMetaData::setHdmiCamportAvailable(bool bAvail)
{
   m_bHdmiSourceAvailable = bAvail;
}


void clMetaData::setGuiStartupStatus(bool bAvail)
{
   m_guiStartupInitiated = bAvail;
}


void clMetaData::setApplicationState(int32 iState)
{
   m_ApplicationState = iState;
}


std::string clMetaData::getArtistName()
{
   ETG_TRACE_USR4(("clMetaData::getArtistName ArtistName is %s ", m_szArtistName.c_str()));

   return m_szArtistName;
}


std::string clMetaData::getAlbumName()
{
   ETG_TRACE_USR4(("clMetaData::getAlbumName AlbumName is %s ", m_szAlbumName.c_str()));

   return m_szAlbumName;
}


std::string clMetaData::getTitleName()
{
   ETG_TRACE_USR4(("clMetaData::getTitleName TitleName is %s ", m_szTitleName.c_str()));

   return m_szTitleName;
}


std::string clMetaData::getFilename()
{
   ETG_TRACE_USR4(("clMetaData::getFilename filename is %s", m_szFilename.c_str()));

   return m_szFilename;
}


int32 clMetaData::getMediaFileType()
{
   ETG_TRACE_USR4(("clMetaData::getMediaFileType media file type is %d", m_u32MediaFileType));

   return m_u32MediaFileType;
}


int32 clMetaData::getListHandle()
{
   ETG_TRACE_USR4(("clMetaData::getListHandle list handle is %d", m_u32ListHandle));

   return m_u32ListHandle;
}


int32 clMetaData::getTotalTime()
{
   ETG_TRACE_USR4(("clMetaData::getTotalTime total time %d", m_u32TotalTime));

   return m_u32TotalTime;
}


int32 clMetaData::getPreviousDevGrp()
{
   ETG_TRACE_USR4(("clMetaData::getPreviousDevGrp pervious group is %d", m_u32PrevDevGrp));

   return m_u32PrevDevGrp;
}


int32 clMetaData::getSrcID()
{
   ETG_TRACE_USR4(("clMetaData::getSrcID source id is %d", m_u32SrcID));

   return m_u32SrcID;
}


int clMetaData::getUSBDeviceNumber()
{
   ETG_TRACE_USR4(("clMetaData::getUSBDeviceNumber usb device number%d", m_iUSBDeviceNum));

   return m_iUSBDeviceNum;
}


int32 clMetaData::getSubSrcID()
{
   ETG_TRACE_USR4(("clMetaData::getSubSrcID sub source id is %d", m_u32SubSrcID));

   return m_u32SubSrcID;
}


bool clMetaData::getShuffleSupported()
{
   ETG_TRACE_USR4(("clMetaData::getShuffleSupported shuffle support %d", m_bShuffleSupported));

   return m_bShuffleSupported;
}


bool clMetaData::getRepeatSupported()
{
   ETG_TRACE_USR4(("clMetaData::getRepeatSupported repeat support %d", m_bRepeatSupported));

   return m_bRepeatSupported;
}


bool clMetaData::getBrowseSupported()
{
   ETG_TRACE_USR4(("clMetaData::getBrowseSupported browse support %d", m_bBrowseSupported));

   return m_bBrowseSupported;
}


bool clMetaData::getUsbCamportAvailable()
{
   ETG_TRACE_USR4(("clMetaData::getUsbCamportAvailable CamportSourceAvailable %d", m_bCamportSourceAvailable));

   return m_bCamportSourceAvailable;
}


bool clMetaData::getHdmiCamportAvailable()
{
   ETG_TRACE_USR4(("clMetaData::getHdmiCamportAvailable HdmiSourceAvailable %d", m_bHdmiSourceAvailable));

   return m_bHdmiSourceAvailable;
}


bool clMetaData::getGuiStartupStatus()
{
   ETG_TRACE_USR4(("clMetaData::getGuiStartupStatus guiStartupInitiated  %d", m_guiStartupInitiated));

   return m_guiStartupInitiated;
}


int32 clMetaData::getApplicationState()
{
   ETG_TRACE_USR4(("clMetaData::getApplicationState ApplicationState  %d", m_ApplicationState));

   return m_ApplicationState;
}


/*********************************************************************************************
* Function 	    : szOnConvertPlayTime
* Description 	:
* Parameters 	: Candera::String& refTime
* Parameters 	: tU32 u32PlayTime
* Return value	: None
**********************************************************************************************/
tVoid clMetaData::szOnConvertPlayTime(std::string& refTime, tU32 u32PlayTime)
{
   //ETG_TRACE_USR4(("tclMediaAppLogic::szOnConvertPlayTime(%d)", u32PlayTime));
   ETG_TRACE_USR4(("clMetaData::szOnConvertPlayTime PlayTime  %d", u32PlayTime));

   tU32 u32Hours = ZERO;
   tU32 u32Minutes = ZERO;
   tU32 u32Seconds = ZERO;
   tU32 u32RemainingSecs = ZERO;
   char szTime[TIME_BUFFER_SIZE];
   /*Time Conversion based on Universal Time Conversion Formula*/
   u32Hours = u32PlayTime / (60 * 60);
   u32RemainingSecs = u32PlayTime % (60 * 60);
   u32Minutes = u32RemainingSecs / 60;
   u32Seconds = u32RemainingSecs % 60;
   memset(szTime, '\0', TIME_BUFFER_SIZE);
   if (u32Hours > ZERO)
   {
      snprintf(szTime, (TIME_BUFFER_SIZE), "%01d:%02d:%02d", u32Hours, u32Minutes, u32Seconds);
   }
   else
   {
      snprintf(szTime, (TIME_BUFFER_SIZE), "%02d:%02d", u32Minutes, u32Seconds);
   }
   refTime = szTime;
}


}//end of Core
}//end of App
