/**************************************************************************************
* @file         : SystemInfoMap.h
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/


#ifndef SYSTEMINFOMAP_H_
#define SYSTEMINFOMAP_H_

#include "AvdeccPluginConstant.h"
#include "Core/ExternalMediaDefines.h"
#include "ProjectBaseTypes.h"
#include "Core/MediaDefines.h"


namespace App {
namespace Core {
/***********************************************************************
Primary Declarations
***********************************************************************/
using namespace ::std;

class SystemInfoMap
{
   public:
      SystemInfoMap();
      virtual ~SystemInfoMap();

   public:
      std::map <uint8, uint8> _systeminfostatusMap;

      void setSystemStatus(uint8 systemCategory, uint8 systemStatus);
      uint8 getSystemStatus(uint8 systemCategory);
      bool getSystemCategoryAvailability(uint8 systemCategory);
};


} // end of namespace Core
} // end of namespace App


#endif /* SystemInfoMap_H_ */
