/**************************************************************************************
* @file         : SystemInfoMap.cpp
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "hall_std_if.h"
#include "SystemInfoMap.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::SystemInfoMap::
#include "trcGenProj/Header/SystemInfoMap.cpp.trc.h"
#endif

namespace App {
namespace Core {

/************************************************************************
*FUNCTION		: SystemInfoMap
*DESCRIPTION	: Constructor. Initializes the member variables.
*PARAMETER		:
*PARAMETER		:
*RETURNVALUE	: NA
************************************************************************/
SystemInfoMap::SystemInfoMap()
{
   ETG_TRACE_USR4(("SystemInfoMap constructor \n"));
}


/************************************************************************
*FUNCTION		: SystemInfoMap
*DESCRIPTION	: Destructor.
*PARAMETER		:
*RETURNVALUE	: NA
************************************************************************/
SystemInfoMap::~SystemInfoMap()
{
}


void SystemInfoMap::setSystemStatus(uint8 systemCategory, uint8 systemStatus)
{
   ETG_TRACE_USR4(("SystemInfoMap setSystemStatus systemCategory %d systemStatus %d\n",
                   ETG_CENUM(SystemCategory, systemCategory), ETG_CENUM(enSystemStatus, systemStatus)));
   _systeminfostatusMap[systemCategory] = systemStatus;
}


uint8 SystemInfoMap::getSystemStatus(uint8 systemCategory)
{
   uint8 iSystemStatus = SYSTEM_STATUS_NONE;
   if (_systeminfostatusMap.count(systemCategory))
   {
      iSystemStatus =  _systeminfostatusMap[systemCategory];
      ETG_TRACE_USR4(("SystemInfoMap getSystemStatus systemCategory %d systemStatus %d \n",
                      ETG_CENUM(SystemCategory, systemCategory), ETG_CENUM(enSystemStatus, iSystemStatus)));
   }
   return iSystemStatus;
}


bool SystemInfoMap::getSystemCategoryAvailability(uint8 systemCategory)
{
   bool status = false;
   if (_systeminfostatusMap.count(systemCategory))
   {
      status = true;
   }
   ETG_TRACE_USR1(("SystemInfoMap getSystemCategoryAvailability systemCategory = %d. status = %d",
                   ETG_CENUM(SystemCategory, systemCategory), status));
   return status;
}


} // end of namespace Core
} // end of namespace App
