/**************************************************************************************
* @file         : PlayableContentMap.h
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/


#ifndef PLAYABLECONTENTMAP_H_
#define PLAYABLECONTENTMAP_H_

#include "AvdeccPluginConstant.h"
#include "Core/ExternalMediaDefines.h"


namespace App {
namespace Core {
/***********************************************************************
Primary Declarations
***********************************************************************/
using namespace ::std;

class PlayableContentMap
{
   public:
      PlayableContentMap();
      virtual ~PlayableContentMap();

   public:
      std::map <EnumConst::entSourceType, PlayableContentAvailability> m_playableContentAvailibilityMap;

      void initialiseMap();
      void setPlayableAudioContent(EnumConst::entSourceType sourceType, bool playableAudioContent);
      void setPlayableVideoContent(EnumConst::entSourceType sourceType, bool playableVideoContent);
      void setCRCStatus(EnumConst::entSourceType sourceType, int controlValue);
      bool getPlayableAudioContent(EnumConst::entSourceType sourceType);
      bool getPlayableVideoContent(EnumConst::entSourceType sourceType);
      int  getCRCStatus(EnumConst::entSourceType sourceType);
};


} // end of namespace Core
} // end of namespace App


#endif /* PLAYABLECONTENTMAP_H_ */
