/**************************************************************************************
* @file         : MediaUtils.cpp
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "hall_std_if.h"
#include "MediaUtils.h"
#include "AppHmi_MediaTypes.h"

#include <stdio.h>
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::MediaUtils::
#include "trcGenProj/Header/MediaUtils.cpp.trc.h"
#endif

namespace App {
namespace Core {

/***************************************************************************
* Handling for Constructor & Destructor & Instance <start>
***************************************************************************/
MediaUtils* MediaUtils::_theInstance = 0;

MediaUtils& MediaUtils::getInstance()
{
   if (_theInstance == 0)
   {
      _theInstance = new MediaUtils();
   }

   //assert(_theInstance);
   return *_theInstance;
}


void MediaUtils::removeInstance()
{
   if (_theInstance)
   {
      delete _theInstance;
      _theInstance = 0;
   }
}


/************************************************************************
*FUNCTION		: MediaUtils
*DESCRIPTION	: Constructor. Initializes the member variables.
*PARAMETER		:
*PARAMETER		:
*RETURNVALUE	: NA
************************************************************************/
MediaUtils::MediaUtils()
{
   //_metadataMap.clear();
}


/************************************************************************
*FUNCTION		: MediaUtils
*DESCRIPTION	: Destructor.
*PARAMETER		:
*RETURNVALUE	: NA
************************************************************************/
MediaUtils::~MediaUtils()
{
}


/***************************************************************************
* Handling for Constructor & Destructor & Instance <End>
***************************************************************************/

/**
* AppendSelectedFolderInCurrFolderPath - Helper function to append the selected folder name to the current folder path.
*
* @parm[in, out] strPath - Current folder path of media item
* @parm[in] strFolderName - Selected folder name .
* @return void
*/
void MediaUtils::AppendSelectedFolderInCurrFolderPath(std::string& strPath, const std::string& strFolderName)
{
   strPath = strPath + strFolderName;
}


int MediaUtils::getActiveSource(int activeRegion)
{
   int l_activeSource = m_ActiveDeviceDataMap[activeRegion].activeSource;
   ETG_TRACE_USR3(("MMediaUtils::getActiveSource activeRegion ,l_activeSource %d, %d \n", activeRegion, l_activeSource));

   return l_activeSource;
}


int MediaUtils::getDeviceType(EnumConst::entSourceType sourceType)
{
   int deviceType = FI_EN_E8DTY_UNKNOWN ;
   if (sourceType == EnumConst::entSourceType_CMP)
   {
      deviceType = FI_EN_E8DTY_USB_CAMERAPORT;
   }
   else
   {
      deviceType = FI_EN_E8DTY_ROUTER_USB;
   }
   ETG_TRACE_USR3(("MediaUtils::getDeviceType deviceType %d \n", deviceType));

   return deviceType;
}


EnumConst::entSourceType MediaUtils::getSourceType(int srcId)
{
   EnumConst::entSourceType sourceType = EnumConst::entSourceType_CMP ;
   if (srcId == SRC_CAMERAPORT1_USB_VIDEO || srcId == SRC_CAMERAPORT1_USB_AUDIO)
   {
      sourceType = EnumConst::entSourceType_CMP;
   }
   else if (srcId == SRC_CMR1_USB1_VIDEO || srcId == SRC_CMR1_USB1_AUDIO)
   {
      sourceType = EnumConst::entSourceType_CMR;
   }
   ETG_TRACE_USR4(("MediaUtils::getSourceType sourceType ,srcId %d %d \n", ETG_CENUM(entSourceType, sourceType), srcId));

   return sourceType ;
}


} // end of namespace Core
} // end of namespace App
