/**************************************************************************************
* @file         : DbDownloadMap.h
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/


#ifndef DBDOWNLOADMAP_H_
#define DBDOWNLOADMAP_H_

#include "AvdeccPluginConstant.h"
#include "Core/ExternalMediaDefines.h"


namespace App {
namespace Core {
/***********************************************************************
Primary Declarations
***********************************************************************/
using namespace ::std;

class DbDownloadMap
{
   private:
      static DbDownloadMap* _theInstance;

   public:
      DbDownloadMap();
      static DbDownloadMap& getInstance();
      void removeInstance();
      ~DbDownloadMap();

   public:
      std::map <EnumConst::entSourceType, DbDownloadState> m_dbDownloadStatusMap;
      std::map <EnumConst::entSourceType, int> m_dbStatusMap;

      void initialiseMap();
      void initialiseDbStatusMap();
      void setDbDownloadState(EnumConst::entSourceType sourceType, int downloadState);
      void setDbDownloadRequested(EnumConst::entSourceType sourceType, int downloadRequested);
      void setDbState(EnumConst::entSourceType sourceType, int dbState);
      int getDbDownloadState(EnumConst::entSourceType sourceType);
      bool isDbDownloadRequested(EnumConst::entSourceType sourceType);
      int getDbState(EnumConst::entSourceType sourceType);
};


} // end of namespace Core
} // end of namespace App


#endif /* MEDIAPLAYER_UTILS_H_ */
