/**************************************************************************************
* @file         : DbDownloadMap.cpp
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "hall_std_if.h"
#include "DbDownloadMap.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::DbDownloadMap::
#include "trcGenProj/Header/DbDownloadMap.cpp.trc.h"
#endif

namespace App {
namespace Core {

/***************************************************************************
* Handling for Constructor & Destructor & Instance <start>
***************************************************************************/
DbDownloadMap* DbDownloadMap::_theInstance = 0;

DbDownloadMap& DbDownloadMap::getInstance()
{
   if (_theInstance == 0)
   {
      _theInstance = new DbDownloadMap();
   }

   //assert(_theInstance);
   return *_theInstance;
}


void DbDownloadMap::removeInstance()
{
   if (_theInstance)
   {
      delete _theInstance;
      _theInstance = 0;
   }
}


/************************************************************************
*FUNCTION		: DbDownloadMap
*DESCRIPTION	: Constructor. Initializes the member variables.
*PARAMETER		:
*PARAMETER		:
*RETURNVALUE	: NA
************************************************************************/
DbDownloadMap::DbDownloadMap()
{
   ETG_TRACE_USR1(("DbDownloadMap constructor \n"));
   initialiseMap();
   initialiseDbStatusMap();
}


/************************************************************************
*FUNCTION		: DbDownloadMap
*DESCRIPTION	: Destructor.
*PARAMETER		:
*RETURNVALUE	: NA
************************************************************************/
DbDownloadMap::~DbDownloadMap()
{
}


void DbDownloadMap::initialiseMap()
{
   ETG_TRACE_USR1(("DbDownloadMap::initialiseMap is entered \n"));
   m_dbDownloadStatusMap[EnumConst::entSourceType_CMP] = DbDownloadState(EnumConst::entDownloadState_Default, false);
   m_dbDownloadStatusMap[EnumConst::entSourceType_CMR] = DbDownloadState(EnumConst::entDownloadState_Default, false);
}


void DbDownloadMap::initialiseDbStatusMap()
{
   ETG_TRACE_USR1(("MediaSourceListHandler::initialiseAnimationStatusMap is entered \n"));
   m_dbStatusMap.insert(pair<EnumConst::entSourceType, int>(EnumConst::entSourceType_CMP, EnumConst::entDbState_USBDisconnected));
   m_dbStatusMap.insert(pair<EnumConst::entSourceType, int>(EnumConst::entSourceType_CMR, EnumConst::entDbState_USBDisconnected));
}


void DbDownloadMap::setDbDownloadState(EnumConst::entSourceType sourceType, int downloadState)
{
   ETG_TRACE_USR1(("DbDownloadMap setDbDownloadState downloadState %d \n", downloadState));
   m_dbDownloadStatusMap[sourceType].DownloadState = downloadState;
}


void DbDownloadMap::setDbDownloadRequested(EnumConst::entSourceType sourceType, int downloadRequested)
{
   ETG_TRACE_USR1(("DbDownloadMap setDbDownloadRequested downloadRequested %d \n", downloadRequested));
   m_dbDownloadStatusMap[sourceType].DownloadRequested = downloadRequested;
}


void DbDownloadMap::setDbState(EnumConst::entSourceType sourceType, int dbState)
{
   ETG_TRACE_USR1(("DbDownloadMap setDbState dbState %d \n", dbState));
   m_dbStatusMap[sourceType] = dbState;
}


int DbDownloadMap::getDbDownloadState(EnumConst::entSourceType sourceType)
{
   int l_dbDownloadState = EnumConst::entDownloadState_DownloadError;
   if (m_dbDownloadStatusMap.count(sourceType))
   {
      l_dbDownloadState = m_dbDownloadStatusMap[sourceType].DownloadState;
      ETG_TRACE_USR1(("DbDownloadMap getDbDownloadState downloadState %d \n", l_dbDownloadState));
   }
   return l_dbDownloadState;
}


bool DbDownloadMap::isDbDownloadRequested(EnumConst::entSourceType sourceType)
{
   bool l_dbDownloadrequested = false;
   if (m_dbDownloadStatusMap.count(sourceType))
   {
      l_dbDownloadrequested =  m_dbDownloadStatusMap[sourceType].DownloadRequested;
      ETG_TRACE_USR1(("DbDownloadMap isDbDownloadRequested downloadRequested %d \n", l_dbDownloadrequested));
   }
   return l_dbDownloadrequested;
}


int DbDownloadMap::getDbState(EnumConst::entSourceType sourceType)
{
   int l_dbState = EnumConst::entDbState_USBDisconnected;
   if (m_dbStatusMap.count(sourceType))
   {
      l_dbState = m_dbStatusMap[sourceType];
      ETG_TRACE_USR1(("DbDownloadMap getDbState dbState %d \n", l_dbState));
   }
   return l_dbState;
}


} // end of namespace Core
} // end of namespace App
