/**************************************************************************************
* @file         : UnSupportedPopupHandler.h
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
*30.07.20 Rev. 0.1 Naga Suman (RBEI/ECH2)
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _UNSUPPORTED_POPUP_HANDLER_H_
#define _UNSUPPORTED_POPUP_HANDLER_H_

#include "AppBase/ServiceAvailableIF.h"
#include "AppHmi_MediaTypes.h"
#include "AppHmi_MediaStateMachine.h"
#include "AppHmi_MediaDatabinding.h"
#include "AppHmi_MediaMessages.h"
#include "mplay_devicemanager_fiProxy.h"
#include "ProjectBaseTypes.h"

namespace App {
namespace Core {

class UnSupportedPopupHandler:
   public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public ::mplay_devicemanager_fi::DevManagerNotifyConnectionCallbackIF

{
   public:
      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      virtual void onDevManagerNotifyConnectionError(const ::boost::shared_ptr<mplay_devicemanager_fi::Mplay_devicemanager_fiProxy >& /*proxy*/,
            const ::boost::shared_ptr< mplay_devicemanager_fi::DevManagerNotifyConnectionError >& error);
      virtual void onDevManagerNotifyConnectionStatus(const ::boost::shared_ptr< mplay_devicemanager_fi::Mplay_devicemanager_fiProxy >& /*proxy*/,
            const ::boost::shared_ptr<mplay_devicemanager_fi::DevManagerNotifyConnectionStatus >& status);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MEDIA_COURIER_PAYLOAD_MODEL_COMP)

      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      virtual ~UnSupportedPopupHandler();
      static UnSupportedPopupHandler& getInstance();

      void removeInstance();

      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      void readFromUsbSupportedDevicesFile();
      bool isProductIDNotAvailableInMediaDeviceInfoVector(uint16 productid , uint16 connectionStatus);
      bool ignoreSupportedMediaDevices(uint16 vendorId, uint16 productId);
      void triggerUnsupportedUSBToastPopup(uint16 deviceType, uint16 unsupportedReason, bool isUnsupportedReasonOKReceived);
      void performUnSupportedMediaDevicesOperation();
      void removeMediaDeviceInfoOnUserDisconnection();
      struct stMediaDeviceInfo
      {
         uint16 vendorID;
         uint16 productID;
         uint16 devType;
         uint16 connectionStatus;
         uint16 unSupportedReason;
         bool isNewMediaDevice;
      };

      stMediaDeviceInfo m_MediaDeviceDetails;
      void performUnsupportedPopUpOperation(uint16 deviceType, uint16 unsupportedReason);
      void callUnsupportedPopUpOnGuiStartUp();

   private:
      UnSupportedPopupHandler();
      static  UnSupportedPopupHandler* _unSupportedPopupHandler;
      ::boost::shared_ptr< ::mplay_devicemanager_fi::Mplay_devicemanager_fiProxy > _deviceManagerProxy;
      std::multimap<uint16, uint16> _whiteListDeviceInfo;
      std::vector<stMediaDeviceInfo> _deviceInfoVector;
      uint16 m_unSupportedDeviceType;
      uint16 m_unSupportedReason;
};


}//end of Core
}//end of App


#endif // _UNSUPPORTED_POPUP_HANDLER_H_
