/**************************************************************************************
* @file         : MediaUtils.h
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/


#ifndef STATE_TRANSITION_HANDLER_H_
#define STATE_TRANSITION_HANDLER_H_

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "AppHmi_MediaMessages.h"

enum enStateTransitionReason
{
   ST_TRANSITION_REASON_DEVICE_REMOVAL,
   ST_TRANSITION_REASON_USER_SRC_REQUEST,
   ST_TRANSITION_REASON_SONG_SELECT_IN_LIST,
   ST_TRANSITION_REASON_MEDIA_TYPE_CHANGE,
   ST_TRANSITION_REASON_APPFLY_INN,
   ST_TRANSITION_REASON_OTHERS,
   ST_TRANSITION_REASON_INVALID
};


#endif


namespace App {
namespace Core {
/***********************************************************************
Primary Declarations
***********************************************************************/
using namespace ::std;

class StateTransitionHandler
{
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   protected:
      bool onCourierMessage(const CurrentMediaStateUpdMsg& msg);
      bool onCourierMessage(const MediaSettingBackBtnPressUpdMsg& msg);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MEDIA_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(CurrentMediaStateUpdMsg)
      ON_COURIER_MESSAGE(MediaSettingBackBtnPressUpdMsg)
      COURIER_MSG_MAP_END()
#endif
   public:
      StateTransitionHandler();
      static StateTransitionHandler& getInstance();
      void removeInstance();
      ~StateTransitionHandler();
      void initializeMediaStateTransitions();
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      void setApplicationState(int);
      void activateMediaState(int state);
      void setStateTransitionReason(int reason);
      void stateTransit_onActiveSourceDeviceDisconnection();
      void stateTransit_onActiveSourceUpdate();
      void stateTransit_onSettingContextRequest();
      void stateTransit_onSourceSelectionContextUpdate();
      void stateTransit_onNowPlayingStatus();
      void stateTransit_onAppFlyInn();
      int getcurrentMediaState();
#endif
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
      void setCurrentStateTransitionReason(int currentStateTransitionReason);
      void setcurrentMediaState(int currentMediaState);
#endif
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   private:
#else
   public:
#endif
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      void performStateTransition();
#endif
      int getNextTransitionState();
      bool isValidStateTransitionReasonRequested(int reason);
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
   private:
#endif
      static StateTransitionHandler* _theInstance;

      int _currentMediaState;
      int _previousMediaState;
      int _pendingStateTransition;
      int _currentStateTransitionReason;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      int _applicationState;
#endif
};


} // end of namespace Core
} // end of namespace App


#endif /* STATE_TRANSITION_HANDLER_H_ */
