/**************************************************************************************
* @file         : StateTransitionHandler.cpp
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "hall_std_if.h"
#endif
#include "StateTransitionHandler.h"
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "ProjectBaseTypes.h"
#endif
#include <stdio.h>

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::StateTransitionHandler::
#include "trcGenProj/Header/StateTransitionHandler.cpp.trc.h"
#endif

#endif

#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
#include "utest/stubs/Apphmi_Media_Types_Common.h"
#endif

namespace App {
namespace Core {

/***************************************************************************
* Handling for Constructor & Destructor & Instance <start>
***************************************************************************/
StateTransitionHandler* StateTransitionHandler::_theInstance = 0;

StateTransitionHandler& StateTransitionHandler::getInstance()
{
   if (_theInstance == 0)
   {
      _theInstance = new StateTransitionHandler();
   }

   //assert(_theInstance);
   return *_theInstance;
}


void StateTransitionHandler::removeInstance()
{
   if (_theInstance)
   {
      delete _theInstance;
      _theInstance = 0;
   }
}


/************************************************************************
*FUNCTION		: StateTransitionHandler
*DESCRIPTION	: Constructor. Initializes the member variables.
*PARAMETER		:
*PARAMETER		:
*RETURNVALUE	: NA
************************************************************************/
StateTransitionHandler::StateTransitionHandler()
{
   initializeMediaStateTransitions();
}


/************************************************************************
*FUNCTION		: StateTransitionHandler
*DESCRIPTION	: Destructor.
*PARAMETER		:
*RETURNVALUE	: NA
************************************************************************/
StateTransitionHandler::~StateTransitionHandler()
{
   removeInstance();
}


/***************************************************************************
* Handling for Constructor & Destructor & Instance <End>
***************************************************************************/
void StateTransitionHandler::initializeMediaStateTransitions()
{
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   ETG_TRACE_USR1(("StateTransitionHandler::initializeMediaStateTransitions"));
#endif
   _currentMediaState = MEDIA_STATE_INVALID;
   _previousMediaState = MEDIA_STATE_INVALID;
   _currentStateTransitionReason = ST_TRANSITION_REASON_INVALID;
   _pendingStateTransition = MEDIA_STATE_INVALID;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   _applicationState = MEDIA_STATE_BACKGROUND;
#endif
}


#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
bool StateTransitionHandler::onCourierMessage(const CurrentMediaStateUpdMsg& msg)
{
   ETG_TRACE_USR4(("StateTransitionHandler::onCourierMessage CurrentMediaStateUpdMsg  msg.GetCurrentState():%d", msg.GetCurrentState()));
   ETG_TRACE_USR4(("StateTransitionHandler::onCourierMessage CurrentMediaStateUpdMsg _previousMediaState:%d", _previousMediaState));
   ETG_TRACE_USR4(("StateTransitionHandler::onCourierMessage CurrentMediaStateUpdMsg _currentMediaState:%d", _currentMediaState));
   if (_previousMediaState == MEDIA_STATE_INVALID || (_currentMediaState != msg.GetCurrentState()))
   {
      _previousMediaState = _currentMediaState;
      _currentMediaState = msg.GetCurrentState();
   }
   return true;
}


bool StateTransitionHandler::onCourierMessage(const MediaSettingBackBtnPressUpdMsg& msg)
{
   ETG_TRACE_USR1(("StateTransitionHandler::MediaSettingBackBtnPressUpdMsg pendingStateTransition:%d", _pendingStateTransition));

   if (_pendingStateTransition == MEDIA_STATE_SOURCESELECTION)
   {
      activateMediaState(MEDIA_STATE_SOURCESELECTION);
   }
   else
   {
      activateMediaState(_previousMediaState);
   }

   return true;
}


void StateTransitionHandler::activateMediaState(int requestedState)
{
   ETG_TRACE_USR4(("StateTransitionHandler::activateMediaState: %d", requestedState));

   switch (requestedState)
   {
      case MEDIA_STATE_NOWPLAYING:
         POST_MSG((COURIER_MESSAGE_NEW(PlayAudioVideoSong)()));
         break;

      case MEDIA_STATE_LIST:
         POST_MSG((COURIER_MESSAGE_NEW(ActicvateAlbumSceneMsg)()));
         break;

      case MEDIA_STATE_SETTINGS:
         POST_MSG((COURIER_MESSAGE_NEW(Open_Settings_Screen)()));
         break;

      case MEDIA_STATE_SOURCESELECTION:
         POST_MSG((COURIER_MESSAGE_NEW(Open_SourceSelection_Screen)()));
         break;

      default:
         break;
   }
}


void StateTransitionHandler::performStateTransition()
{
   ETG_TRACE_USR1(("StateTransitionHandler::performStateTransition"));
   if (getNextTransitionState() != MEDIA_STATE_INVALID)
   {
      activateMediaState(getNextTransitionState());
   }
}


#endif


int StateTransitionHandler::getNextTransitionState()
{
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   ETG_TRACE_USR1(("StateTransitionHandler::getNextTransitionState currentStateTransitionReason:%d", _currentStateTransitionReason));
   ETG_TRACE_USR1(("StateTransitionHandler::getNextTransitionState currentMediaState:%d", _currentMediaState));
#endif
   int transitionState = MEDIA_STATE_INVALID;
   switch (_currentStateTransitionReason)
   {
      case ST_TRANSITION_REASON_DEVICE_REMOVAL:
      {
//			if(_applicationState == hmibase::IN_FOREGROUND)
         {
            if (_currentMediaState == MEDIA_STATE_NOWPLAYING || _currentMediaState == MEDIA_STATE_LIST)
            {
               transitionState = MEDIA_STATE_SOURCESELECTION;
               _pendingStateTransition = MEDIA_STATE_INVALID;
            }
            else if (_currentMediaState == MEDIA_STATE_SETTINGS)
            {
               _pendingStateTransition = MEDIA_STATE_SOURCESELECTION;
            }
         }
      }
      break;
      case ST_TRANSITION_REASON_USER_SRC_REQUEST:
      case ST_TRANSITION_REASON_APPFLY_INN:
      {
         _pendingStateTransition = MEDIA_STATE_INVALID;
         transitionState = MEDIA_STATE_NOWPLAYING;
      }
      break;
      default:
         break;
   }
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   ETG_TRACE_USR4(("StateTransitionHandler:: getNextTransitionState : %d", transitionState));
#endif
   return transitionState;
}


#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
void StateTransitionHandler::setStateTransitionReason(int reason)
{
   ETG_TRACE_USR4(("StateTransitionHandler:: setStateTransitionReason : %d", reason));
   if (isValidStateTransitionReasonRequested(reason))
   {
      _currentStateTransitionReason = reason;
   }
}


void StateTransitionHandler::setApplicationState(int state)
{
   ETG_TRACE_USR4(("StateTransitionHandler:: setApplicationState : %d", state));
   _applicationState = state;
}


void StateTransitionHandler::stateTransit_onActiveSourceDeviceDisconnection()
{
   ETG_TRACE_USR1(("StateTransitionHandler::stateTransit_onActiveSourceDeviceDisconnection"));
   performStateTransition();
}


void StateTransitionHandler::stateTransit_onActiveSourceUpdate()
{
   ETG_TRACE_USR1(("StateTransitionHandler::stateTransit_onActiveSourceUpdate"));
   performStateTransition();
}


void StateTransitionHandler::stateTransit_onAppFlyInn()
{
   ETG_TRACE_USR4(("StateTransitionHandler::stateTransit_onAppFlyInn"));
   if (_currentStateTransitionReason == ST_TRANSITION_REASON_APPFLY_INN)
   {
      performStateTransition();
   }
}


void StateTransitionHandler::stateTransit_onSettingContextRequest()
{
   ETG_TRACE_USR1(("StateTransitionHandler::stateTransit_onSettingContextRequest"));
   if (_currentMediaState != MEDIA_STATE_SETTINGS)
   {
      activateMediaState(MEDIA_STATE_SETTINGS);
   }
}


void StateTransitionHandler::stateTransit_onSourceSelectionContextUpdate()
{
   ETG_TRACE_USR1(("StateTransitionHandler::stateTransit_onSourceSelectionContextUpdate"));
   if (_currentMediaState != MEDIA_STATE_SOURCESELECTION)
   {
      activateMediaState(MEDIA_STATE_SOURCESELECTION);
   }
}


void StateTransitionHandler::stateTransit_onNowPlayingStatus()
{
   ETG_TRACE_USR4(("StateTransitionHandler::stateTransit_onNowPlayingStatus _currentStateTransitionReason:%d", _currentStateTransitionReason));
   ETG_TRACE_USR4(("StateTransitionHandler::stateTransit_onNowPlayingStatus _currentMediaState:%d", _currentMediaState));
   if ((_currentStateTransitionReason == ST_TRANSITION_REASON_SONG_SELECT_IN_LIST) ||	// When a song is selected from list, transit to nowplaying screen
         (_currentStateTransitionReason == ST_TRANSITION_REASON_USER_SRC_REQUEST) || (_currentStateTransitionReason == ST_TRANSITION_REASON_MEDIA_TYPE_CHANGE && _currentMediaState == MEDIA_STATE_NOWPLAYING)) // Screen transition between mp3 and video screen
   {
      activateMediaState(MEDIA_STATE_NOWPLAYING);
      setStateTransitionReason(ST_TRANSITION_REASON_INVALID); // Once screen reaches main screen, resetting the state transition reason
   }
}


#endif


bool StateTransitionHandler::isValidStateTransitionReasonRequested(int requestedReason)
{
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   ETG_TRACE_USR4(("StateTransitionHandler::isValidStateTransitionReasonRequested requestedReason:%d", requestedReason));
   ETG_TRACE_USR4(("StateTransitionHandler::isValidStateTransitionReasonRequested currentStateTransitionReason:%d", _currentStateTransitionReason));
#endif
   if ((_currentStateTransitionReason == ST_TRANSITION_REASON_SONG_SELECT_IN_LIST ||
         _currentStateTransitionReason == ST_TRANSITION_REASON_USER_SRC_REQUEST)
         && requestedReason == ST_TRANSITION_REASON_MEDIA_TYPE_CHANGE)
   {
      return false;
   }
   return true;
}


#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
void StateTransitionHandler::setCurrentStateTransitionReason(int currentStateTransitionReason)
{
   _currentStateTransitionReason = currentStateTransitionReason;
}


void StateTransitionHandler::setcurrentMediaState(int currentMediaState)
{
   _currentMediaState = currentMediaState;
}


#endif
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
int StateTransitionHandler::getcurrentMediaState()
{
   ETG_TRACE_USR4(("StateTransitionHandler::getcurrentMediaState CurrentState:%d", _currentMediaState));
   return _currentMediaState;
}


#endif
} // end of namespace Core
} // end of namespace App
