/**************************************************************************************
* @file         : IPluginClientAppl.h
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef IPluginClientAppl_h
#define IPluginClientAppl_h

#include "AppBase/ServiceAvailableIF.h"
#include "AvdeccPluginConstant.h"
#include "ProjectPluginMsgs.h"
#include "Core/ExternalMediaPlaybackHandler/ExternalMediaPlaybackHandler.h"
#include "Core/PlayableContentInterfaceHandler/PlayableContentInterfaceHandler.h"

namespace App {
namespace Core {

class ExternalMediaSourceHandler;

class IPluginClientAppl
{
   public:

      IPluginClientAppl() {}
      virtual ~IPluginClientAppl() {}

      virtual void sendPluginRequest(uint16 ControlValue, int srcID) = 0;
      virtual int getPlaybackActionStreamType(int srcID, int u8activeRegion) = 0;
      virtual int getRepeatModeStreamType(int srcID, int u8activeRegion) = 0;
      virtual void updateSeekToStreamType(uint16 seekPercent) = 0;
      virtual uint8 getPluginValue(EventDataItem* eventDataItemControlVal) = 0;
      virtual std::string getPluginValueString(EventDataItem* eventDataItemControlVal) = 0;
      virtual void sendpluginUpdate(uint16 ControlId, uint16 ControlValue, uint8 activeRegion, uint8 listValue, uint16 positionValue) = 0;
      virtual double getSliderValue() = 0;
      virtual void onMessagePluginUpdateResp(EventDataItem* eventDataItem, EventDataItem* eventDataItemControlVal, EventDataItem* eventDataItemPosition, EventDataItem* trackIndex, EventDataItem* folderPath, EventDataItem* listType, EventDataItem* subSrcType, EventDataItem* region) = 0;
      virtual void setExternalMediaSrcHandlerInstance(ExternalMediaSourceHandler* _externalMediaSourceHandlerObject) = 0;
      virtual void updateCurrentPlayingListType(uint8 listtype, uint16 position) = 0;
      virtual void updateCurentPlayingFolderPath(std::string folderPath) = 0;
      virtual void updateCurrentPlayingSrcType(uint8 srcType) = 0;
      virtual void updateCurrentPlayingFileType(uint16 fileType) = 0;
      virtual void onPlaySelectedListItem(uint8 listtype, uint16 position, std::string folderPath, int fileType) = 0;
      virtual void resetMetadata() = 0;
      virtual void resetCurrentTrackInfo() = 0;
      virtual void setPlayableContentInterfaceHandlerInstance(PlayableContentInterfaceHandler* _playableContentInterfaceHandlerObject) = 0;
};


} // namespace Core
} // namespace App
#endif
