/**************************************************************************************
* @file         : CamportUSBPluginClientHandler.cpp
* @author       : ECH - voa4kor
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "hall_std_if.h"
#include "Core/PluginClientHandlerAppl/CamportUSBPluginClientHandler.h"
#include "../ApplicationSwitchClientHandler/ApplicationSwitchClientHandler.h"
#include "Core/ExternalMediaPlaybackHandler/ExternalMediaPlaybackHandler.h"
#include "Core/MediaSourceListHandler/MediaSourceListHandler.h"
#include "DataModel/HMIModelComponent.h"
#include "Core/Utils/MediaUtils.h"
#include "PluginConstants.h"
#include "MediaCameraPort.h"
#include "Core/SourceSwitch/MediaSourceHandling.h"
#include "Core/Utils/DbDownloadMap.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS         TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL             TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX          "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX               App::Core::CamportUSBPluginClientHandler::

#include "trcGenProj/Header/CamportUSBPluginClientHandler.cpp.trc.h"
#endif


namespace App {
namespace Core {


CamportUSBPluginClientHandler::CamportUSBPluginClientHandler()
   : _externalMediaSourceHandler(NULL)
   , _playableContentInterfaceHandler(NULL)
{
   ETG_TRACE_USR1(("CamportUSBPluginClientHandler constructor \n"));
   m_sElapsedplaytimeData = " ";
   m_Elapsedslidervalue = MEDIA_C_VALUE_ZERO;
   m_Totalslidervalue = MEDIA_C_VALUE_ZERO;
   m_totaltime = MEDIA_C_VALUE_ZERO;
   NowPlayingInfoStatus = (struct stNowPlayingInfo)
   {
      "", "", "", MEDIA_C_VALUE_ZERO, "", MEDIA_C_VALUE_ZERO, "", MEDIA_C_VALUE_ZERO
   };
   m_splaytimeData = " ";
   m_strEmpData = " ";
   m_strEmpEpisodeData = " ";
   strEmpData = " ";
   _currentPlayingListType = EnumConst::entListType_Invalid;
   _currentPlayingSongPosition = 0;
   _folderPath = " ";
   _srcType = EnumConst::entSourceType_CMP;
   _fileType = entFileType__entFileType_unknown;
   initialiseStreamTypeMap();
}


CamportUSBPluginClientHandler::~CamportUSBPluginClientHandler()
{
   ETG_TRACE_USR1(("CamportUSBPluginClientHandler Destructor \n"));
}


void CamportUSBPluginClientHandler::resetCurrentTrackInfo()
{
   _folderPath = " ";
}


void CamportUSBPluginClientHandler::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("CamportUSBPluginClientHandler::registerProperties"));
}


void CamportUSBPluginClientHandler::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("CamportUSBPluginClientHandler::deregisterProperties"));
}


void CamportUSBPluginClientHandler::onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("CamportUSBPluginClientHandler::onUnavailable"));
}


void CamportUSBPluginClientHandler::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("CamportUSBPluginClientHandler::onAvailable"));
}


void CamportUSBPluginClientHandler::initialiseStreamTypeMap()
{
   ETG_TRACE_USR1(("CamportUSBPluginClientHandler::initialiseStreamTypeMap is entered \n"));

   m_StreamTypeMap[REGION_CABIN_A][SRC_CAMERAPORT1_USB_VIDEO] = StreamType(STREAM1PLAYACTION, STREAM1REPEATMODE, STREAM1SEEKTO);
   m_StreamTypeMap[REGION_CABIN_A][SRC_CAMERAPORT1_USB_AUDIO] = StreamType(STREAM3PLAYACTION, STREAM3REPEATMODE, STREAM3SEEKTO);
   m_StreamTypeMap[REGION_CABIN_B][SRC_CAMERAPORT1_USB_VIDEO] = StreamType(STREAM1PLAYACTION, STREAM1REPEATMODE, STREAM1SEEKTO);
   m_StreamTypeMap[REGION_CABIN_B][SRC_CAMERAPORT1_USB_AUDIO] = StreamType(STREAM3PLAYACTION, STREAM3REPEATMODE, STREAM3SEEKTO);
}


void CamportUSBPluginClientHandler::setExternalMediaSrcHandlerInstance(ExternalMediaSourceHandler* _externalMediaSourceHandlerObject)
{
   ETG_TRACE_USR1(("CamportUSBPluginClientHandler::setExternalMediaSrcHandlerInstance is entered \n"));
   _externalMediaSourceHandler = _externalMediaSourceHandlerObject;
}


void CamportUSBPluginClientHandler::setPlayableContentInterfaceHandlerInstance(PlayableContentInterfaceHandler* _playableContentInterfaceHandlerObject)
{
   ETG_TRACE_USR1(("CamportUSBPluginClientHandler::setPlayableContentInterfaceHandlerInstance is entered \n"));
   _playableContentInterfaceHandler = _playableContentInterfaceHandlerObject;
}


void CamportUSBPluginClientHandler::sendPluginRequest(uint16 ControlValue, int srcID)
{
   ETG_TRACE_USR4(("CamportUSBPluginClientHandler::sendPluginRequest ControlValue  : %d", ControlValue));
   ETG_TRACE_USR4(("CamportUSBPluginClientHandler::sendPluginRequest srcID : %d", srcID));

   ETG_TRACE_USR4(("CamportUSBPluginClientHandler::sendPluginRequest _currentPlayingListType : %d", _currentPlayingListType));
   tU8 l_Operationtype = ExternalMediaPlaybackHandler::getInstance()->getOperationType();
   ETG_TRACE_USR4(("CamportUSBPluginClientHandler::sendPluginRequest l_Operationtype : %d", l_Operationtype));
   uint16 l_ControlId = 0;
   uint16 l_ControlValue = ControlValue;
   uint8 l_ListValue = _currentPlayingListType;
   uint16 l_PositionValue = _currentPlayingSongPosition;
   // if ((ControlValue == EXT_MEDIA_NORMAL) || (ControlValue == EXT_MEDIA_REPEAT_TRACK) || (ControlValue == EXT_MEDIA_SHUFFLE))
   //{
   if ((l_Operationtype == EN_MEDIA_REPEAT_OFF)
         || (l_Operationtype == EN_MEDIA_REPEAT_TRACK)
         || (l_Operationtype == EN_MEDIA_REPEAT_LIST))
   {
      l_ControlValue = ExternalMediaPlaybackHandler::getInstance()->getRepeatState();
      l_ControlId = getRepeatModeStreamType(srcID, REGION_CABIN_A);
   }
   else if ((l_Operationtype == EN_MEDIA_SHUFFLE_OFF) || (l_Operationtype == EN_MEDIA_SHUFFLE_LIST))
   {
      l_ControlValue = ExternalMediaPlaybackHandler::getInstance()->getShuffleState();
      l_ControlId = getRepeatModeStreamType(srcID, REGION_CABIN_A);
   }
   else
   {
      l_ControlId = getPlaybackActionStreamType(srcID, REGION_CABIN_A);
   }

   sendpluginUpdate(l_ControlId, l_ControlValue, REGION_CABIN_A, l_ListValue, l_PositionValue);
}


void CamportUSBPluginClientHandler::sendpluginUpdate(uint16 ControlId, uint16 ControlValue, uint8 activeRegion, uint8 listValue, uint16 positionValue)
{
   ETG_TRACE_USR4(("CamportUSBPluginClientHandler::sendpluginUpdate ControlId : %d ControlValue: %d activeRegion: %d listValue :%d positionValue :%d",
                   ControlId, ControlValue, activeRegion, listValue, positionValue));

   uint8 l_ListValue = listValue;
   uint16 l_PositionValue = positionValue;
   uint8 srcType = _srcType;
   uint16 fileType = _fileType;
   uint16 filterTag1 = 0;
   uint16 filterTag2 = 0;
   std::string folderPath = _folderPath;
   boost::shared_ptr<EventDataUtility> pluginData(EventDataUtility::newEventDataUtility());
   if (NULL != pluginData.get())
   {
      pluginData->addEventData(ControlId);
      pluginData->addEventData(ControlValue);
      pluginData->addEventData(activeRegion);
      pluginData->addEventData(l_ListValue);
      pluginData->addEventData(l_PositionValue);
      pluginData->addEventData(srcType);
      pluginData->addEventData(fileType);
      pluginData->addEventData(filterTag1);
      pluginData->addEventData(filterTag2);
      pluginData->addEventData(folderPath);
      POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(PluginCommandReqMsg)(PLUGIN_NAME_MEDIA, "", pluginData)));
   }
}


void CamportUSBPluginClientHandler::updateCurrentPlayingListType(uint8 Listtype, uint16 Position)
{
   _currentPlayingListType = Listtype;
   _currentPlayingSongPosition  = Position;
   ETG_TRACE_USR4(("CamportUSBPluginClientHandler::updateCurrentPlayingListType _currentPlayingListType : %d ,_currentPlayingSongPosition :%d ", _currentPlayingListType, _currentPlayingSongPosition));
}


void CamportUSBPluginClientHandler::updateCurentPlayingFolderPath(std::string folderPath)
{
   _folderPath = folderPath;
   ETG_TRACE_USR1(("CamportUSBPluginClientHandler::updateCurentPlayingFolderPath: _folderPath %s", _folderPath.c_str()));
}


void CamportUSBPluginClientHandler::updateCurrentPlayingSrcType(uint8 srcType)
{
   _srcType = srcType;
   ETG_TRACE_USR1(("CamportUSBPluginClientHandler::updateCurentPlayingFolderPath: _srcType %d", ETG_CENUM(enSubSourceType, _srcType)));
   int srcID = MediaSourceHandling::getInstance().getCurrentRegionSrcId();
   if (srcID == SRC_CAMERAPORT1_USB_VIDEO)
   {
      _fileType = entFileType__entFileType_Video;
   }
   else if (srcID == SRC_CAMERAPORT1_USB_AUDIO)
   {
      _fileType = entFileType__entFileType_Audio;
   }
}


void CamportUSBPluginClientHandler::updateCurrentPlayingFileType(uint16 fileType)
{
   _fileType = fileType;
   ETG_TRACE_USR1(("CamportUSBPluginClientHandler::updateCurentPlayingFolderPath: _fileType %d", ETG_CENUM(entFileType, fileType)));
}


int CamportUSBPluginClientHandler::getRepeatModeStreamType(int srcID, int u8activeRegion)
{
   int repeatModeStreamType = STREAM1REPEATMODE;
   ::std::map< uint32, ::std::map< int, StreamType > >::iterator itr = m_StreamTypeMap.find(u8activeRegion);
   if (itr != m_StreamTypeMap.end())
   {
      ::std::map< int, StreamType >::iterator itr1 = itr->second.find(srcID);
      if (itr1 != itr->second.end())
      {
         repeatModeStreamType = itr1->second.RepeatMode;
      }
   }

   ETG_TRACE_USR3(("CamportUSBPluginClientHandler::getRepeatModeStreamType repeatModeStreamType:%d ,srcID:%d,u8activeRegion:%d",
                   repeatModeStreamType, srcID, u8activeRegion));
   return repeatModeStreamType;
}


int CamportUSBPluginClientHandler::getPlaybackActionStreamType(int srcID, int u8activeRegion)
{
   int playBackStreamType = STREAM1PLAYACTION;
   ::std::map< uint32, ::std::map< int, StreamType > >::iterator itr = m_StreamTypeMap.find(u8activeRegion);
   if (itr != m_StreamTypeMap.end())
   {
      ::std::map< int, StreamType >::iterator itr1 = itr->second.find(srcID);
      if (itr1 != itr->second.end())
      {
         playBackStreamType = itr1->second.PlayAction;
      }
   }
   ETG_TRACE_USR3(("CamportUSBPluginClientHandler::getPlaybackActionStreamType playBackStreamType:%d ,srcID:%d,u8activeRegion:%d",
                   playBackStreamType, srcID, u8activeRegion));
   return playBackStreamType;
}


void CamportUSBPluginClientHandler::updateSeekToStreamType(uint16 seekPercent)
{
   uint8 l_ListValue = 0;
   uint16 l_PositionValue = 0;
   int seekToStreamType = STREAM1SEEKTO;
   int srcID = MediaSourceHandling::getInstance().getCurrentRegionSrcId();
   uint8 u8activeRegion = ApplicationSwitchClientHandler::poGetInstance()->getActiveRegion();
   ::std::map< uint32, ::std::map< int, StreamType > >::iterator itr = m_StreamTypeMap.find(u8activeRegion);
   if (itr != m_StreamTypeMap.end())
   {
      ::std::map< int, StreamType >::iterator itr1 = itr->second.find(srcID);
      if (itr1 != itr->second.end())
      {
         seekToStreamType = itr1->second.SeekTo;
      }
   }
   ETG_TRACE_USR3(("CamportUSBPluginClientHandler::getPlaybackActionStreamType seekToStreamType:%d ,srcID:%d,u8activeRegion:%d,seekpercent:%d",
                   seekToStreamType, srcID, u8activeRegion, seekPercent));;
   sendpluginUpdate(seekToStreamType, seekPercent, u8activeRegion, l_ListValue, l_PositionValue);
}


void CamportUSBPluginClientHandler::onMessagePluginUpdateResp(EventDataItem* eventDataItem, EventDataItem* eventDataItemControlVal, EventDataItem* eventDataItemPosition, EventDataItem* trackIndex, EventDataItem* folderPath, EventDataItem* listType, EventDataItem* subSrcType, EventDataItem* region)
{
   ETG_TRACE_USR1(("CamportUSBPluginClientHandler::onCourierMessage:onMessagePluginUpdateResp"));
   uint8 u8ControlVal = 0;
   uint32 ElapsedTime = 0;
   uint32 TotalTime = 0;
   uint16 fileType = 0;
   uint16 track = 0;
   std::string path = "";
   uint16 listtype = 0;
   uint8 src = SRC_CAMERAPORT1_USB_VIDEO;
   uint16 regionId = 0;
   if (NULL != eventDataItem)
   {
      const EventDataItem::Data& eventDataPosition = eventDataItemPosition->getData();

      uint32 m_control_id = getControlId(eventDataItem);
      uint16 u16Position = eventDataPosition._value._uint16Value;
      ETG_TRACE_USR4(("CamportUSBPluginClientHandler::onCourierMessage:onMessagePluginUpdateResp control block id : %d Position : %d",
                      m_control_id, u16Position));

      switch (m_control_id)
      {
         case STREAM1PLAYACTION:
         case STREAM3PLAYACTION:
         {
            if (NULL != eventDataItemControlVal)
            {
               u8ControlVal = getPluginValue(eventDataItemControlVal);
               ExternalMediaPlaybackHandler::getInstance()->vUpdatePlayItems(u8ControlVal, SRC_CAMERAPORT1_USB_VIDEO);
            }
         }
         break;
         case STREAM1REPEATMODE:
         case STREAM3REPEATMODE:
         {
            if (NULL != eventDataItemControlVal)
            {
               u8ControlVal = getPluginValue(eventDataItemControlVal);
               ExternalMediaPlaybackHandler::getInstance()->vUpdateRepeatShuffleItems(u8ControlVal, SRC_CAMERAPORT1_USB_VIDEO);
            }
         }
         break;
         case STREAM1CURPLAYTIME:
         case STREAM3CURPLAYTIME:
         {
            if (NULL != eventDataItemControlVal)
            {
               m_sElapsedplaytimeData = getPluginValueString(eventDataItemControlVal);
               ETG_TRACE_USR4(("CamportUSBPluginClientHandler::onCourierMessage:onMessagePluginUpdateResp inside m_sElapsedplaytimeData %s", m_sElapsedplaytimeData.c_str()));
               if (!m_sElapsedplaytimeData.empty())
               {
                  m_Elapsedslidervalue = getSlidertime(m_sElapsedplaytimeData);
                  ElapsedTime = m_Elapsedslidervalue;
                  ETG_TRACE_USR4(("CamportUSBPluginClientHandler::onCourierMessage:onMessagePluginUpdateResp inside m_Elapsedslidervalue %f", ElapsedTime));
               }
            }
            ExternalMediaPlaybackHandler::getInstance()->handleExternalSourcePlayTimePluginUpdate(m_sElapsedplaytimeData, m_Elapsedslidervalue, m_Totalslidervalue, m_splaytimeData, SRC_CAMERAPORT1_USB_VIDEO);
         }
         break;
         case STREAM1TOTPLAYTIME:
         case STREAM3TOTPLAYTIME:
         {
            if (NULL != eventDataItemControlVal)
            {
               m_splaytimeData = getPluginValueString(eventDataItemControlVal);
               ETG_TRACE_USR4(("CamportUSBPluginClientHandler::onCourierMessage:onMessagePluginUpdateResp m_splaytimeData %s", m_splaytimeData.c_str()));

               if (!m_splaytimeData.empty())
               {
                  NowPlayingInfoStatus.TotalTime = m_splaytimeData;
                  ExternalMediaPlaybackHandler::getInstance()->updateTotalTime(m_splaytimeData);
                  m_Totalslidervalue = getSlidertime(m_splaytimeData);
                  TotalTime = m_Totalslidervalue;
                  ETG_TRACE_USR4(("CamportUSBPluginClientHandler::onCourierMessage:onMessagePluginUpdateResp inside TotalTime %f", TotalTime));
               }
            }
            ExternalMediaPlaybackHandler::getInstance()->handleExternalSourcePlayTimePluginUpdate(m_sElapsedplaytimeData, m_Elapsedslidervalue, m_Totalslidervalue, m_splaytimeData, SRC_CAMERAPORT1_USB_VIDEO);
         }
         break;
         case VIDNAME:
         {
            if (NULL != eventDataItemControlVal)
            {
               m_strEmpData = getPluginValueString(eventDataItemControlVal);
               ETG_TRACE_USR4(("CamportUSBPluginClientHandler::onCourierMessage:onMessagePluginUpdateResp m_strEmpData %s", m_strEmpData.c_str()));

               if (!m_strEmpData.empty())
               {
                  NowPlayingInfoStatus.ArtistName = m_strEmpData;
                  ExternalMediaPlaybackHandler::getInstance()->updateArtistName(m_strEmpData);
               }
               else
               {
                  ExternalMediaPlaybackHandler::getInstance()->updateArtistName("");
               }
            }
            ExternalMediaPlaybackHandler::getInstance()->handleExternalSourceMetaDataPluginUpdate(SRC_CAMERAPORT1_USB_VIDEO);
         }
         break;
         case VIDEPISODE:
         {
            if (NULL != eventDataItemControlVal)
            {
               m_strEmpEpisodeData = getPluginValueString(eventDataItemControlVal);
               ETG_TRACE_USR4(("CamportUSBPluginClientHandler::onCourierMessage:onMessagePluginUpdateResp videoepisode %s", m_strEmpEpisodeData.c_str()));

               if (!m_strEmpEpisodeData.empty())
               {
                  NowPlayingInfoStatus.TitleName = m_strEmpEpisodeData;
                  ExternalMediaPlaybackHandler::getInstance()->updateTitleName(m_strEmpEpisodeData);
               }
               else
               {
                  ExternalMediaPlaybackHandler::getInstance()->updateTitleName("");
               }
            }
            ExternalMediaPlaybackHandler::getInstance()->handleExternalSourceMetaDataPluginUpdate(SRC_CAMERAPORT1_USB_VIDEO);
         }
         break;
         case TRACK:
         {
            if (NULL != eventDataItemControlVal)
            {
               strEmpData = getPluginValueString(eventDataItemControlVal);
               ETG_TRACE_USR4(("CamportUSBPluginClientHandler::onCourierMessage:onMessagePluginUpdateResp TRACK strEmpData %s", strEmpData.c_str()));

               if (!strEmpData.empty())
               {
                  NowPlayingInfoStatus.ArtistName = strEmpData;
                  //MediaUtils::getInstance().m_ActiveDeviceDataMap[REGION_CABIN_A].ArtistName = strEmpData;
                  ExternalMediaPlaybackHandler::getInstance()->updateArtistName(strEmpData);
               }
               else
               {
                  ExternalMediaPlaybackHandler::getInstance()->updateArtistName("");
               }
            }
            ExternalMediaPlaybackHandler::getInstance()->handleExternalSourceMetaDataPluginUpdate(SRC_CAMERAPORT1_USB_VIDEO);
         }
         break;
         case HDMISTATUS:
         {
            if (NULL != eventDataItemControlVal)
            {
               int iHdmiConnectionStatus = getPluginValue(eventDataItemControlVal);
               int iSrcId = SRC_INVALID;
               ETG_TRACE_USR4(("CamportUSBPluginClientHandler::onCourierMessage:onMessagePluginUpdateResp HDMI Connection Status : %d", iHdmiConnectionStatus));
               if (u16Position == EN_POSITION_PRIMARY)
               {
                  iSrcId = SRC_CAMERAPORT1_HDMI;
               }
               else if (u16Position == EN_POSITION_SECONDARY)
               {
                  iSrcId = SRC_CAMERAPORT2_HDMI;
               }
               else if (u16Position == EN_POSITION_TERTIARY)
               {
                  iSrcId = SRC_CAMERAPORT3_HDMI;
               }

               _externalMediaSourceHandler->updateCamportSourceConnectionState(iSrcId, iHdmiConnectionStatus);
            }
         }
         break;
         case USBAUDIOSTATUS:
         {
            if (NULL != eventDataItemControlVal)
            {
               int iUsbConnectionStatus = getPluginValue(eventDataItemControlVal);
               ETG_TRACE_USR4(("CamportUSBPluginClientHandler::onCourierMessage:onMessagePluginUpdateResp USB Connection Status : %d", iUsbConnectionStatus));
               _externalMediaSourceHandler->updateCamportSourceConnectionState(SRC_CAMERAPORT1_USB_VIDEO, iUsbConnectionStatus);
            }
         }
         break;
         case CHECKSUM:
         {
            if (NULL != eventDataItemControlVal)
            {
               int checkSumStatus = getPluginValue(eventDataItemControlVal);
               ETG_TRACE_USR4(("CamportUSBPluginClientHandler::onCourierMessage:onMessagePluginUpdateResp checkSumStatus %d", checkSumStatus));
               _playableContentInterfaceHandler->onCRCStatusReceived(EnumConst::entSourceType_CMP, checkSumStatus);
            }
         }
         break;
         case SIGNAL_SOURCE_CHANGE:
         {
            if (NULL != eventDataItemControlVal)
            {
               fileType = getPluginValue(eventDataItemControlVal);
            }
            if (NULL != trackIndex)
            {
               track = getPluginValue(trackIndex);
            }
            if (NULL != folderPath)
            {
               path = getPluginValueString(folderPath);
            }
            if (NULL != listType)
            {
               listtype = getPluginValue(listType);
            }
            if (NULL != subSrcType)
            {
               src = getPluginValue(subSrcType);
            }
            if (NULL != region)
            {
               regionId = getPluginValue(region);
            }
            ETG_TRACE_USR2(("CamportUSBPluginClientHandler::onCourierMessage:PluginUpdateRespMsg: SIGNAL_SOURCE_CHANGE: fileType %d, track %d, listtype %d, srcType %d, regionId %d, path %s", ETG_CENUM(entFileType, fileType), track, ETG_CENUM(entListType, listtype), ETG_CENUM(enSubSourceType, src), regionId, path.c_str()));
            ExternalMediaPlaybackHandler::getInstance()->onFolderPlaybackSrcChange(fileType, track, path, listtype, src, regionId);
         }
         break;
         case DBSTATUS:
         {
            if (NULL != eventDataItemControlVal)
            {
               int dbStatus = getPluginValue(eventDataItemControlVal);
               ETG_TRACE_USR4(("CamportUSBPluginClientHandler::onCourierMessage:onMessagePluginUpdateResp dbStatus %d", dbStatus));
               DbDownloadMap::getInstance().setDbState(EnumConst::entSourceType_CMP, dbStatus);
               MediaSourceListHandler::getInstance().updateMediaSourceList(LIST_ID_MEDIA_SOURCE_LIST);
            }
         }
         break;
         default:
            ETG_TRACE_USR1(("CamportUSBPluginClientHandler::onCourierMessage:onMessagePluginUpdateResp controlindex default"));
            break;
      }
      ETG_TRACE_USR4(("CamportUSBPluginClientHandler:: onCourierMessage:PluginUpdateRespMsg  UpdateSlider"));
   }
   ETG_TRACE_USR4(("CamportUSBPluginClientHandler::onCourierMessage:onMessagePluginUpdateResp control value : %d", u8ControlVal));
}


double CamportUSBPluginClientHandler::getSliderValue()
{
   ETG_TRACE_USR4(("CamportUSBPluginClientHandler::getSliderValue %d", m_Totalslidervalue));
   return m_Totalslidervalue;
}


uint8 CamportUSBPluginClientHandler::getPluginValue(EventDataItem* eventDataItemControlVal)
{
   EventDataItem::Data eventDataControlVal = eventDataItemControlVal->getData();
   ETG_TRACE_USR4(("CamportUSBPluginClientHandler::getPluginValue eventDataItemControlVal  %d", eventDataControlVal._type));
   uint8 l_ControlVal = 0;
   if (EventDataItem::UINT16 == eventDataControlVal._type)
   {
      l_ControlVal = eventDataControlVal._value._uint16Value;
   }
   else if (EventDataItem::UINT8 == eventDataControlVal._type)

   {
      l_ControlVal = eventDataControlVal._value._uint8Value;
   }
   ETG_TRACE_USR4(("CamportUSBPluginClientHandler::getPluginValue l_ControlVal  %d", l_ControlVal));

   return l_ControlVal;
}


uint32 CamportUSBPluginClientHandler::getControlId(EventDataItem* eventDataItem)
{
   EventDataItem::Data eventData = eventDataItem->getData();
   ETG_TRACE_USR4(("CamportUSBPluginClientHandler::getControlId eventDataItem  %d", eventData._type));
   uint32 u32ControlId = 0;
   if (EventDataItem::UINT16 == eventData._type)
   {
      u32ControlId = eventData._value._uint16Value;
   }
   else if (EventDataItem::UINT32 == eventData._type)

   {
      u32ControlId = eventData._value._uint32Value;
   }
   ETG_TRACE_USR4(("CamportUSBPluginClientHandler::getPluginValue u32ControlId  %d", u32ControlId));

   return u32ControlId;
}


std::string CamportUSBPluginClientHandler::getPluginValueString(EventDataItem* eventDataItemControlVal)
{
   EventDataItem::Data eventDataControlVal = eventDataItemControlVal->getData();
   std::string l_ControlVal = "";
   if (EventDataItem::STRING == eventDataControlVal._type)
   {
      l_ControlVal = eventDataControlVal._value._stringValue->c_str();
   }
   return l_ControlVal;
}


double CamportUSBPluginClientHandler::getSlidertime(std::string totaltimeslidervalue)
{
   ETG_TRACE_USR4(("CamportUSBPluginClientHandler::getSlidertime hh:mm:ss : %s", totaltimeslidervalue.c_str()));

   vector <string> timetokens;
   string hr = "";
   string min = "";
   string sec = "";
   double hr1 = 0;
   double hour = 0;
   double min1 = 0;
   double minute = 0;
   double sec1 = 0;
   double second = 0;
   stringstream check1(totaltimeslidervalue);
   string intermediate = "";
   while (getline(check1, intermediate, ':'))
   {
      timetokens.push_back(intermediate);
   }
   ETG_TRACE_USR4(("CamportUSBPluginClientHandler::getSlidertime timetokens.size() : %d", timetokens.size()));
   if (timetokens.size() >= 1)
   {
      hr = timetokens[0];
      hr1 = atof(hr.c_str());
      hour = hr1 * 3600;
      min = timetokens[1];
      min1 = atof(min.c_str());
      minute = min1 * 60;
      sec = timetokens[2];
      sec1 = atof(sec.c_str());
      second = sec1;
      m_totaltime = hour + minute + second;
      ETG_TRACE_USR4(("CamportUSBPluginClientHandler::getSlidertime m_totaltime : %d", m_totaltime));
      timetokens.clear();//clearing the vector
   }
   return m_totaltime;
}


void CamportUSBPluginClientHandler::onPlaySelectedListItem(uint8 listtype, uint16 position, std::string folderPath, int fileType)
{
   ETG_TRACE_USR1(("CamportUSBPluginClientHandler::onPlaySelectedListItem entered"));
   uint16 positionValue = position;
   uint8  listtypeValue = listtype;
   _fileType = fileType;
   _folderPath = folderPath;
   boost::shared_ptr<EventDataUtility> pluginData(EventDataUtility::newEventDataUtility());
   uint8 u8activeRegion = ApplicationSwitchClientHandler::poGetInstance()->getActiveRegion();
   int srcID = MediaSourceHandling::getInstance().getCurrentRegionSrcId();
   uint8 controlValue = MEDIA_BROWSE_LIST_VALUE;
   uint8 controlId = getPlaybackActionStreamType(srcID, u8activeRegion);
   ETG_TRACE_USR1(("CamportUSBPluginClientHandler::onPlaySelectedListItem srcID %d", srcID));
   sendpluginUpdate(controlId, controlValue, u8activeRegion, listtype, position);
   ETG_TRACE_USR4(("CamportUSBPluginClientHandler::onPlaySelectedListItem controlId, controlValue, u8activeRegion, listtype, position %d %d %d %d %d",
                   controlId, controlValue, u8activeRegion, listtype, position));
}


void CamportUSBPluginClientHandler::resetMetadata()
{
   ETG_TRACE_USR1(("CamportUSBPluginClientHandler::resetMetadata entered"));
   ExternalMediaPlaybackHandler::getInstance()->updateTitleName("");
   ExternalMediaPlaybackHandler::getInstance()->updateArtistName("");
   HMIModelComponent::getInstance().bOnUpdateNowPlayingStatusCamera();
   HMIModelComponent::getInstance().vUpdateCamporUSBHomescreenStatus();
}


}//App
}//Core
