/**************************************************************************************
* @file         : MediaSourceListHandler.h
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
*01.07.20 Rev. 0.1 Naga Suman (RBEI/ECG5)
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _MEDIA_SOURCELIST_HANDLER_H_
#define _MEDIA_SOURCELIST_HANDLER_H_

#include "Core/MediaClientHandler/MediaClientHandler.h"
#include "Core/ApplicationSwitchClientHandler/ApplicationSwitchClientHandler.h"
#include "Core/SourceSwitch/MediaSourceHandling.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "AppHmi_MediaDatabinding.h"
#include "List/Data/ListDataProviderDistributor.h"
#include <map>

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#include "DataModel/HMIModelComponent.h"
#include "AppHmi_MediaTypes.h"
#include "AppHmi_MediaStateMachine.h"
#include "Core/Utils/clMetaData.h"
#include "Core/ListHandling/ExternalMediaListDBManager/ExternalMediaListDBManager.h"
#include "Core/ExternalMediaClientHandler/ExternalMediaClientHandler.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include "AppHmi_MediaMessages.h"
#include "Common/DataModel/ListRegistry.h"
#include "Core/ExternalMediaClientHandler/ExternalMediaClientInterfaceHandler.h"
#include "Core/Utils/ExternalMediaSourceConnectionStatus.h"
#include "Core/ExternalMediaSourceConnectionStateHandler/ExternalMediaSourceConnectionStateHandler.h"

#else
#include "utest/stubs/Apphmi_Media_Types_Common.h"
#include "utest/stubs/Core/BTClientHandler.h"
#include "utest/stubs/Core/KDSHandler.h"
#include "utest/stubs/AudioDefines.h"
#include "utest/stubs/ProjectBaseTypes.h"
#include "utest/stubs/Core/SystemInfoMap.h"
#endif

namespace App {
namespace Core {

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST

class KDSHandler;
class MediaSourceListHandler: public ListImplementation,
   public IExternalSourceAvailabilityStatusObserver,
   public ::App::Core::IExternalDBDownloadUpdateObservor
//public IExternalGlassConnectionInfoListener,

#else
class MediaSourceListHandler
#endif
{
   public:
      MediaSourceListHandler();
      virtual ~MediaSourceListHandler();
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MEDIA_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()
      static MediaSourceListHandler& getInstance();
      virtual tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& listDataInfo);
      tSharedPtrDataProvider getMediaSourceList();
      tSharedPtrDataProvider updateCockpitMediaSourceToListBuilder(uint8 activeRegion);
      tSharedPtrDataProvider updateCabinMediaSourceToListBuilder(uint8 activeRegion);
      void setExternalMediaSourceConnectionStatusInstance(ExternalMediaSourceConnectionStatus* _externalMediaSourceConnectionStatusInstance);
      void setExternalMediaSourceConnectionStateHandlerInstance(ExternalMediaSourceConnectionStateHandler* _externalMediaSourceConnectionStateHandlerInstance);
      void setExternalMediaListDBManagerInstance(ExternalMediaListDBManager* _externalMediaListDBManagerInstance);
      void onExternalSourceAvailabilityUpdate();
      void onExternalDBDownloadUpdate(uint8 downloadState, EnumConst::entSourceType sourceType);
      void updateMediaSourceList(const uint32& listID);
      void removeInstance();
      void onSourceSelectedInSourceList(unsigned int devicetype);
      bool isSourceInIndexCabinEnabled(int index);
#else
      void setstateMachineVariantAux(int stateMachineVariantAux);
      int getstateMachineVariantAux();
#endif
      void setSystemInfoMapInstance(SystemInfoMap* _systemInfoMapInstance);
      void setKdsHandlerInstance(KDSHandler* _kdsHandlerInstance);
      void initialiseHdmiSrcAvailabilityMap();
      void setRouterUsbAvailabilityInSourceList(bool bState);
      bool isSourceAvailableInCockpitRegion(int index);
      bool isSourceAvailableInCabinRegion(int index);
      bool isCockpitSourceInIndexActive(int index);
      bool isCabinSourceInIndexActive(int index);
      void initialiseMediaDevicesMap();
      void initialiseMediaCabinDevicesMap();
      bool isSourceInIndexCockpitEnabled(int index);
      void setCamportUsbAvailabilityInSourceList(bool bState);
      DownloadVisibilityDataItemData updateCabinDownloadState(int index);
   private:
      bool _isGlassAvailable;
      bool m_bCamportUsbState;
      bool m_bRouterUsbState;
      static  MediaSourceListHandler* _mediaSourceListHandler;
      std::map < int, stSourceListDetails> m_MediaDevices;
      std::map < int, stSourceListDetails> m_MediaCabinDevices;
      KDSHandler* _kdsHandler;
      SystemInfoMap* _systemInfoMap;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      ExternalMediaSourceConnectionStatus* _externalMediaSourceConnectionStatus;
      ExternalMediaSourceConnectionStateHandler* _externalMediaSourceConnectionStateHandler;
      ExternalMediaListDBManager* _externalMediaListDBManager;
#else
      int	m_stateMachineVariantAux;

#endif
};


}//end of Core
}//end of App


#endif // _MEDIA_SOURCELIST_HANDLER_H_
