/**************************************************************************************
* @file         : MediaPlaybackStatusUpdater..h
* @author       : RBEI/ECH2-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _MediaPlaybackStatusUpdater_H_
#define _MediaPlaybackStatusUpdater_H_


#include <bits/stdc++.h>
#include "VEHICLE_MAIN_FIProxy.h"
#include "vehicle_main_fi_types.h"
#include "AppBase/ServiceAvailableIF.h"
#include "mplay_MediaPlayer_FIProxy.h"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeProxy.h"
#include "ApplicationSwitch.h"
#include "ApplicationSwitchProxy.h"
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"


#include "Core/MediaSourceListHandler/MediaSourceListHandler.h"


#define MASTERAUDIOSERVICE_INTERFACE ::bosch::cm::ai::hmi::masteraudioservice

namespace App {
namespace Core {


class MediaPlaybackStatusUpdater : public StartupSync::PropertyRegistrationIF,
   public hmibase::ServiceAvailableIF,
   public ::VEHICLE_MAIN_FI::MediaStatusCurrTrackNumCallbackIF,
   public ::VEHICLE_MAIN_FI::DeviceStatusUSB1PresentCallbackIF,
   public ::VEHICLE_MAIN_FI::DeviceStatusUSB1SrcCallbackIF,
   public ::VEHICLE_MAIN_FI::DeviceStatusUSB2PresentCallbackIF,
   public ::VEHICLE_MAIN_FI::DeviceStatusUSB2SrcCallbackIF,
   public ::VEHICLE_MAIN_FI::MediaStatusMixStateCallbackIF,
   public ::VEHICLE_MAIN_FI::MediaStatusPlayStatusCallbackIF,
   public ::VEHICLE_MAIN_FI::MediaStatusRepeatStatusCallbackIF,
   public ::VEHICLE_MAIN_FI::MediaStatusTrackTimeCallbackIF,
   public ::VEHICLE_MAIN_FI::SourceCommandCallbackIF,
   public ::mplay_MediaPlayer_FI::PlaybackStateCallbackIF,
   public ::mplay_MediaPlayer_FI::NowPlayingCallbackIF,
   public ::mplay_MediaPlayer_FI::RepeatModeCallbackIF,
   public ::mplay_MediaPlayer_FI::PlaybackModeCallbackIF,
   public ::mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsCallbackIF,
   public ::mplay_MediaPlayer_FI::PlaytimeCallbackIF,
   public MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceCallbackIF,
   public ::VEHICLE_MAIN_FI::MediaStatusSeekStatusCallbackIF,
   public ::VEHICLE_MAIN_FI::DeviceStatusBluetoothAvailCallbackIF
//   public ::mplay_MediaPlayer_FI::SeekToCallbackIF,

{
   public:
      MediaPlaybackStatusUpdater();
      virtual ~MediaPlaybackStatusUpdater();
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      void onMediaStatusCurrTrackNumError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusCurrTrackNumError >& error) ;
      void onMediaStatusCurrTrackNumResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusCurrTrackNumResult >& result) ;
      void onDeviceStatusUSB1PresentError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceStatusUSB1PresentError >& error) ;
      void onDeviceStatusUSB1PresentResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceStatusUSB1PresentResult >& result) ;
      void onDeviceStatusUSB1SrcError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceStatusUSB1SrcError >& error) ;
      void onDeviceStatusUSB1SrcResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceStatusUSB1SrcResult >& result) ;
      void onDeviceStatusUSB2PresentError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceStatusUSB2PresentError >& error) ;
      void onDeviceStatusUSB2PresentResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceStatusUSB2PresentResult >& result) ;
      void onDeviceStatusUSB2SrcError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceStatusUSB2SrcError >& error) ;
      void onDeviceStatusUSB2SrcResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceStatusUSB2SrcResult >& result) ;
      void onMediaStatusMixStateError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusMixStateError >& error) ;
      void onMediaStatusMixStateResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusMixStateResult >& result) ;
      void onMediaStatusPlayStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusPlayStatusError >& error) ;
      void onMediaStatusPlayStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusPlayStatusResult >& result) ;
      void onMediaStatusRepeatStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusRepeatStatusError >& error) ;
      void onMediaStatusRepeatStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusRepeatStatusResult >& result) ;
      void onMediaStatusSeekStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusSeekStatusError >& error) ;
      void onMediaStatusSeekStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusSeekStatusResult >& result) ;
      void onMediaStatusTrackTimeError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusTrackTimeError >& error) ;
      void onMediaStatusTrackTimeResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusTrackTimeResult >& result) ;

      void onSourceCommandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SourceCommandError >& error) ;
      void onSourceCommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SourceCommandStatus >& Status) ;

      virtual void onNowPlayingError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy, const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::NowPlayingError >& error);
      virtual void onNowPlayingStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy, const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::NowPlayingStatus >& status);

      virtual void onPlaybackStateError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy, const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::PlaybackStateError >& error);
      virtual void onPlaybackStateStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy, const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::PlaybackStateStatus >& status);

      virtual void onPlaytimeError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy, const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::PlaytimeError >& error);
      virtual void onPlaytimeStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy, const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::PlaytimeStatus >& status);

      virtual void onMediaPlayerDeviceConnectionsStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/, const boost::shared_ptr< ::mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsStatus >& status); /*status*/
      virtual void onMediaPlayerDeviceConnectionsError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/, const boost::shared_ptr< ::mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsError >& /*error*/);

      virtual void onRepeatModeError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/, const boost::shared_ptr< ::mplay_MediaPlayer_FI::RepeatModeError >& /*error*/);
      virtual void onRepeatModeStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/, const boost::shared_ptr< ::mplay_MediaPlayer_FI::RepeatModeStatus >& status);

      virtual void onPlaybackModeError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/, const boost::shared_ptr< ::mplay_MediaPlayer_FI::PlaybackModeError >& /*error*/);
      virtual void onPlaybackModeStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/, const boost::shared_ptr< ::mplay_MediaPlayer_FI::PlaybackModeStatus >& status);

      virtual void onActiveSourceError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/, const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceError >& /*error*/);
      virtual void onActiveSourceUpdate(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/, const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceUpdate >& update);

      void onDeviceStatusBluetoothAvailError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceStatusBluetoothAvailError >& error) ;
      void onDeviceStatusBluetoothAvailResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceStatusBluetoothAvailResult >& result) ;

      ApplicationSwitchClientComponent* _applicationSwitchClientComponent;

   private:
      ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy> _vehicleProxy;
      ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy > _mediaPlayerProxy;
      ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy > _audioSourceChangeProxy;

      bool _isSeekUpdated;
      tU8  _playbackCANstate;
      tU32 _currentElapsedTime;
      tU8 _shuffleCANStatus;
      tU8 _repeatCANStatus;
      tU16 _currentTrackNum;
};


} // namespace Core
} // namespace App


#endif  /* _ExternalMediaSourceHandler_H_ */
