/* ***************************************************************************************
* FILE:          MediaHall.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  MediaHall.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef MediaHall_h
#define MediaHall_h

#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "AppBase/HallComponentBase.h"
#include "VehicleSrvClient/VehicleSrvClient.h"
#include "AppHmi_MediaMessages.h"
#include "Core/ExternalMediaClientHandler/ExternalMediaClientHandler.h"
#include "Core/ExternalMediaSourceStateUpdateHandler/ExternalMediaSourceStateUpdateHandler.h"
#include "Core/MediaClientHandler/MediaClientHandler.h"
#include "Core/TunerClientHandler/TunerClientHandler.h"
#include "Core/ExternalMediaPlaybackHandler/ExternalMediaPlaybackHandler.h"
#include "Core/MediaSourceListHandler/MediaSourceListHandler.h"
#include "Core/UnSupportedPopupHandler/UnSupportedPopupHandler.h"
#include "Core/BTClientHandler/BTClientHandler.h"
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#include "Common/PopupTimer/PopupTimer.h"
#include "Common/DataModel/NavigationModeDBHandler.h"
#include "ApplicationSwitchClientHandler/ApplicationSwitchClientHandler.h"
#include "Core/StateTransitionHandler/StateTransitionHandler.h"
#include "Core/ExternalMediaSourceHandler/ExternalMediaSourceHandler.h"
#include "Core/ExternalMediaStateHandler/ExternalMediaStateHandler.h"
#include "Core/ListHandling/ExternalMediaListDBManager/ExternalMediaListDBManager.h"
#include "Core/ListHandling/ListGuiRequestHandler/ListGuiRequestHandler.h"
#include "Core/ListHandling/HorizontalListManager/HorizontalListManager.h"
#include "Core/ListHandling/VerticalListManager/VerticalListManager.h"
#include "Core/PlayableContentInterfaceHandler/PlayableContentInterfaceHandler.h"
#include "Core/ExternalMediaListManager/ExternalMediaListManager.h"
#include "Core/Utils/PlayableContentMap.h"
#include "Core/Utils/SystemInfoMap.h"
#include "Core/Utils/ExternalMediaSourceConnectionStatus.h"
#include "ApplicationSwitch.h"
#include "ApplicationSwitchProxy.h"
#include "Common/DefSetServiceBase/DefSetServiceBase.h" //Reset To Factory
#include "Core/SourceSwitch/MediaSourceHandling.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include "Common/PluginClientHandler/PluginClientHandler.h"
#include <Adapter/LanguageHandlerAdapter.h>
#include "Core/SpeedLockStatusHandler/SpeedLockStatusHandler.h"
#include "Core/KDSHandler/KDSHandler.h"
#include "Core/CabinSourceRestoration/CabinSourceRestoration.h"
#include "Core/CabinSystemStateHandler/CabinSystemStateHandler.h"
#include "Core/HmiStateHandler/HmiStateHandler.h"
#include "Core/ExternalMediaSourceConnectionStateHandler/ExternalMediaSourceConnectionStateHandler.h"
#include "Core/MediaPlaybackStatusUpdater/MediaPlaybackStatusUpdater.h"
#include "Core/MediaPlaybackLongDataUpdater/MediaPlaybackLongDataUpdater.h"


using namespace ::asf::core;
using namespace ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch;
#define AUDIOMANAGER_COMMANDINTERFACE org::genivi::audiomanager::CommandInterface
#define MASTERAUDIOSERVICE_INTERFACE ::bosch::cm::ai::hmi::masteraudioservice


namespace App {
namespace Core {

class ExternalMediaSourceHandler;

class MediaHall
   : public HallComponentBase
   , public iDefSetServiceBase   // for factory reset
   , public ::languageHandler::LanguageHandlerAdapter
{
   public:
      MediaHall();
      MediaHall(const MediaHall&);
      MediaHall& operator =(const MediaHall&);
      virtual ~MediaHall();

      //member functions
      void setExternalMediaClientHandlerDependency();

      //TTFis Trace cmds
      static void TraceCmd_onTestTraceCommand();
      static void TraceCmd_Operation(uint8 operationType);
      void methodOperation(uint8 operationType);
      static void TraceCmd_onMediaContext(uint32 regionid, uint32 currentAppid, uint32 currentactivityid, uint32 targetappid, uint32 targetactivityid);
      static void TraceCmd_WaitAnimation(enAnimationReqType state);
      static void TraceCmd_UnSupportedPopup(bool state);
      static void TraceCmd_UnSupportedPopupHUB(bool state);
      static void TraceCmd_InitiateCamportUSBScreen();
      static void TraceCmd_setDBDownloadStateVert(int dbState, EnumConst::entSourceType sourceType);
      static void TraceCmd_enableUSBCamport(bool bState);
      static void TraceCmd_connectionStatusExternalUsbCamport(int bState);
      static void TraceCmd_connectionStatusExternalHDMI(int srcId, int bState);
      static void TraceCmd_SourceAllocation(int srcId, int sinkId, int connectionState);
      static void TraceCmd_connectionStatusExternalUsbCamportAudio(int bState);
      static void TraceCmd_SimHK(const HardKeyCodeEnum keyCode, const hmibase::HardKeyStateEnum keyState);
      static void TraceCmd_enableRouterUSB(int bState);

   protected:
      virtual bool onCourierMessage(const SwitchApplicationReq& oMsg);
      bool onCourierMessage(const SelectHomescreenMediaTab& msg);
      bool onCourierMessage(const NavigationCarModeInfo& msg);

      // for factory reset
      virtual void reqPrepareResponse(const PrepareResDiagMsgData&);
      virtual void reqExecuteResponse(const ExecuteResDiagMsgData&);
      virtual void reqFinalizeResponse(const FinalizeResDiagMsgData&);
      void setKDSHandlerDependency();
      void setPlayableContentMapDependency();
      void setSystemInfoMapDependency();
      void setCabinSourceRestorationDependency();

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MEDIA_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(SwitchApplicationReq)
      ON_COURIER_MESSAGE(SelectHomescreenMediaTab)
      ON_COURIER_MESSAGE(NavigationCarModeInfo)

      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_OBJ(_hmiModelComponent)
      COURIER_MSG_DELEGATE_TO_OBJ(_hmiModelListImplementation)
      COURIER_MSG_DELEGATE_TO_OBJ(_hmiModelTabImplementation)
      COURIER_MSG_DELEGATE_TO_OBJ(_mediaClientHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_mediaSourceListHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_speedStatusHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_unSupportedPopupHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_tunerClientHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_externalMediaPlaybackHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_externalMediaClientHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_mediaPlaybackLongDataUpdater)
      COURIER_MSG_DELEGATE_TO_OBJ(_VehicleSrvClient)
      COURIER_MSG_DELEGATE_TO_OBJ(_pluginClientHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_applicationSwitchClientHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_stateTransitionHandler)
      //  COURIER_MSG_DELEGATE_TO_OBJ(_listGuiRequestHandler)
      //  COURIER_MSG_DELEGATE_TO_OBJ(_verticalListManager)
      COURIER_MSG_DELEGATE_TO_OBJ(_externalMediaListManager)
      COURIER_MSG_DELEGATE_TO_OBJ(_externalMediaSourceHandler)
      COURIER_MSG_DELEGATE_TO_CLASS(::languageHandler::LanguageHandlerAdapter)
      COURIER_MSG_DELEGATE_TO_CLASS(HallComponentBase)
      COURIER_MSG_DELEGATE_TO_REF(_mPopupTimer)

      COURIER_MSG_MAP_DELEGATE_END()

   private:

      NavigationModeDBHandler* _navigationModeDBHandler;
      DataBindingItem<CarModeVisibilityDataBindingSource> _carModeVisibilityStatus;

      ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy > _audioSourceChangeSPIProxy;
      ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy > _soundPropertiesProxy;

      /** Instance for the DefSetServiceBase */
      DefSetServiceBase* _mdefSetServiceBase;
      VehicleSrvClient* _VehicleSrvClient;

      tclMediaClientHandler* _mediaClientHandler;
      MediaSourceListHandler* _mediaSourceListHandler;
      SpeedLockStatusHandler*  _speedStatusHandler;
      UnSupportedPopupHandler* _unSupportedPopupHandler;
      TunerClientHandler* _tunerClientHandler;
      ExternalMediaPlaybackHandler* _externalMediaPlaybackHandler;
      ApplicationSwitchClientComponent* _applicationSwitchClientComponent;
      ApplicationSwitchClientHandler* _applicationSwitchClientHandler;
      ExternalMediaClientHandler* _externalMediaClientHandler;
      ExternalMediaSourceStateUpdateHandler* _externalMediaSourceStateUpdateHandler;
      ExternalMediaSourceConnectionStateHandler* _externalMediaSourceConnectionStateHandler;
      HMIModelComponent* _hmiModelComponent;
      HMIModelListImplementation* _hmiModelListImplementation;
      HMIModelTabImplementation* _hmiModelTabImplementation;
      MediaSourceHandling* _mediaSourceHandling;
      PluginClientHandler* _pluginClientHandler;
      KDSHandler* _kdsHandler;
      BTClientHandler* _btClientHandler;
      StateTransitionHandler* _stateTransitionHandler;
      ExternalMediaSourceHandler* _externalMediaSourceHandler;
      ExternalMediaStateHandler* _externalMediaStateHandler;
      ExternalMediaListDBManager* _externalMediaListDBManager;
      // ListGuiRequestHandler* _listGuiRequestHandler;
      //  HorizontalListManager* _horizontalListManager;
      // VerticalListManager* _verticalListManager;
      CabinSystemStateHandler* _cabinSystemStateHandler;
      HmiStateHandler* _hmiStateHandler;
      PlayableContentInterfaceHandler* _playableContentInterfaceHandler;
      ExternalMediaListManager* _externalMediaListManager;
      PlayableContentMap* _playableContentMap;
      PopupTimerHandler::PopupTimer _mPopupTimer;
      CabinSourceRestoration* _cabinSourceRestoration;
      SystemInfoMap* _systemInfoMap;
      ExternalMediaSourceConnectionStatus* _externalMediaSourceConnectionStatus;
      MediaPlaybackStatusUpdater* _mediaPlaybackStatusUpdater;
      MediaPlaybackLongDataUpdater* _mediaPlaybackLongDataUpdater;
      DECLARE_CLASS_LOGGER();
};


} // namespace Core
} // namespace App


#endif
