/* ***************************************************************************************
* FILE:          MediaGui.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  MediaGui.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef MediaGui_h
#define MediaGui_h

#include "AppBase/GuiComponentBase.h"
#include "HMIAppCtrl/Proxy/ProxyHandler.h"

// datapool for persistent data
//#define DP_S_IMPORT_INTERFACE_FI
//#include "dp_hmi_01_if.h"

namespace App {
namespace Core {


class MediaGui :
   public GuiComponentBase
{
   public:
      MediaGui();
      virtual ~MediaGui();

      virtual void preRun();
      virtual void postRun();

      static void TraceCmd_NotProcessedMsg(const unsigned char* pcu8Data);
      static void TraceCmd_Test(uint8 operationType);

      virtual unsigned int getDefaultTraceClass();
      virtual void setupCgiInstance();

   private:

      void PersistentValuesRead();
      void PersistentValuesWrite();
      //HmiAppMedia::PersMemVars _mvar;

      hmibase::services::hmiappctrl::ProxyHandler _hmiAppCtrlProxyHandler;
};


} // namespace Core
} // namespace App


#endif
