/**************************************************************************************
* @file         : MediaClientHandler.h
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
*21.09.17 Rev. 0.1 Ruchi (RBEI/ECG5)
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _MEDIA_CLIENT_HANDLER_H_
#define _MEDIA_CLIENT_HANDLER_H_

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#include "mplay_MediaPlayer_FI.h"
#include "mplay_MediaPlayer_FIProxy.h"
#include "DataModel/HMIModelComponent.h"
#include "DataModel/HMIModelListImplementation.h"
#include "DataModel/HMIModelTabImplementation.h"
#include "Core/BTClientHandler/BTClientHandler.h"
#include "AppHmi_MediaTypes.h"
#include "AppHmi_MediaStateMachine.h"
#include "AppHmi_MediaDatabinding.h"
#include "Core/Utils/clMetaData.h"
#include "Core/Utils/ListUtilityDatabase.h"
#include "Core/ExternalMediaClientHandler/ExternalMediaClientHandler.h"
#include "AppBase/ServiceAvailableIF.h"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeProxy.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesProxy.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include "Core/TunerClientHandler/TunerClientHandler.h"
#include "AppHmi_MediaMessages.h"
#include <ilm_client.h>
#include <ilm_control.h>
#include "Core/ExternalMediaSourceHandler/ExternalMediaSourceHandler.h"
#include "Core/KDSHandler/KDSHandler.h"
#include "Core/PlayableContentInterfaceHandler/PlayableContentInterfaceHandler.h"

#include "asf/core/Timer.h"

class StartupSync;

#include "mplay_MediaPlayer_FIProxy.h"

#else
#include "asf/core/Types.h"
#endif

namespace App {
namespace Core {

class MediaSourceHandling;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
struct FolderListInfo
{
   uint32 _listHandle;
   uint32 _listSize;
};


class clMetaData;

class tclMediaClientHandler
   : public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF
   , public ::App::Core::IhdmiSourceAvailabilityObservor
   , public ::mplay_MediaPlayer_FI::PlaybackStateCallbackIF
   , public ::mplay_MediaPlayer_FI::RequestPlaybackActionCallbackIF
   , public ::mplay_MediaPlayer_FI::NowPlayingCallbackIF
   , public ::mplay_MediaPlayer_FI::RepeatModeCallbackIF
   , public ::mplay_MediaPlayer_FI::PlaybackModeCallbackIF
   , public ::mplay_MediaPlayer_FI::GetMediaObjectAlbumArtInfoCallbackIF
   , public ::mplay_MediaPlayer_FI::GetMediaObjectAlbumArtCallbackIF
   , public ::mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsCallbackIF
   , public ::mplay_MediaPlayer_FI::ActiveMediaDeviceCallbackIF
   , public ::mplay_MediaPlayer_FI::PlaytimeCallbackIF
   , public ::mplay_MediaPlayer_FI::SeekToCallbackIF
   , public ::mplay_MediaPlayer_FI::CreateMediaPlayerIndexedListCallbackIF
   , public ::mplay_MediaPlayer_FI::RequestMediaPlayerIndexedListSliceCallbackIF
   , public ::mplay_MediaPlayer_FI::PlayItemFromListByTagCallbackIF
   , public ::mplay_MediaPlayer_FI::CreateMediaPlayerFileListCallbackIF
   , public ::mplay_MediaPlayer_FI::ReleaseMediaPlayerListCallbackIF
   , public ::mplay_MediaPlayer_FI::RequestMediaPlayerFileListSliceCallbackIF
   , public ::mplay_MediaPlayer_FI::PlayItemFromListCallbackIF
   , public ::mplay_MediaPlayer_FI::FolderBrowseStructureClearedCallbackIF
   , public ::mplay_MediaPlayer_FI::ClearMediaPlayerDataCallbackIF
   , public ::mplay_MediaPlayer_FI::SendAppleHIDCommandCallbackIF
   , public ::asf::core::TimerCallbackIF
   , public ::mplay_MediaPlayer_FI::CreateMediaPlayerPlaylistListCallbackIF
   , public ::App::Core::ICamportUsbSourceAvailabilityObservor
   , public ::mplay_MediaPlayer_FI::MediaPlayerListChangeCallbackIF
   , public ::App::Core::IRouterSourceAvailabilityObservor
{
#else
class tclMediaClientHandler
{
#endif
   public:
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      virtual bool onCourierMessage(const Courier::StartupMsg& oMsg);
      bool onCourierMessage(const MediaOperationMsgReq& oMsg);
      bool onCourierMessage(const MediaBTOperationMsgReq& oMsg);
      bool onCourierMessage(const BrowseListReqMsg& oMsg);
      bool onCourierMessage(const VideoRequest& oMsg);
      bool onCourierMessage(const StartVideoTimerMsg& oMsg);
      bool onCourierMessage(const StopVideoTimerMsg& oMsg);
      bool onCourierMessage(const Open_SourceSelection_Screen& oMsg);
      bool onCourierMessage(const AppleHIDCommandMsg& msg);
      bool onCourierMessage(const AnimationWidgetIndMsg& oMsg);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MEDIA_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(Courier::UpdateModelMsg)
      ON_COURIER_MESSAGE(MediaOperationMsgReq)
      ON_COURIER_MESSAGE(MediaBTOperationMsgReq)
      ON_COURIER_MESSAGE(SelectDeviceSourceMsg)
      ON_COURIER_MESSAGE(BrowseListReqMsg)
      ON_COURIER_MESSAGE(StartVideoTimerMsg)
      ON_COURIER_MESSAGE(StopVideoTimerMsg)
      ON_COURIER_MESSAGE(USB2SelectDeviceMsg)
      ON_COURIER_MESSAGE(AppleHIDCommandMsg)
      ON_COURIER_MESSAGE(AnimationWidgetIndMsg)
      ON_COURIER_MESSAGE(Open_SourceSelection_Screen)
      ON_COURIER_MESSAGE(onHardKeyPress)
      COURIER_MSG_MAP_END()

      COURIER_BINDING_MAP_BEGIN()

      COURIER_BINDING_ITEM_CHANGE(PlaybackActionItem)
      COURIER_BINDING_ITEM_CHANGE(AppleDeviceItem)
      COURIER_BINDING_ITEM_CHANGE(BTPlayInfoUpdateItem)
      COURIER_BINDING_MAP_END()
#endif
      virtual ~tclMediaClientHandler();
      tclMediaClientHandler();
      static tclMediaClientHandler& getInstance();

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void setActiveBTSource();
      void setActiveAUXSource();
      // ServiceAvailableIF implementation
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void vResetMediaSourcesPriorityStruct();
      void onHdmiSourceAvailabilityUpdate(int srcId, int hdmiavailable);
      void onCamportUsbSourceAvailabilityUpdate(int iCamportVideoAvailability);
      void setExternalMediaSourceHandlerInstance(ExternalMediaSourceHandler* _externalMediaSourceHandlerInstance);
      void setKdsHandlerInstance(KDSHandler* _kdsHandlerInstance);
      virtual void onMediaPlayerDeviceConnectionsStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/,
            const boost::shared_ptr< ::mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsStatus >& status);/*status*/
      virtual void onMediaPlayerDeviceConnectionsError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/,
            const boost::shared_ptr< ::mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsError >& /*error*/);

      void vUpdateConnectedDeviceInfo(const ::mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsStatus& oDeviceInfoDataObject);
      void vOnDeviceConnection(stDeviceConnectionInfo* StrDevice, tU8 iCurrListIndex);
      virtual bool onCourierMessage(const SelectDeviceSourceMsg& oMsg);
      virtual bool onCourierMessage(const USB2SelectDeviceMsg& oMsg);
      void vOnDeviceSelection(stDeviceConnectionInfo StrDevice, tU8 u8RequestedSrc, tU8 u8UsbNum);
      void AudioAllocationRequest(tU8 u8SelectedDevType, stDeviceConnectionInfo StrDevice);
      void vUpdateActiveMediaDeviceStatus(const ::mplay_MediaPlayer_FI::ActiveMediaDeviceStatus& oActiveDeviceInfoDataObject);
      //void vUpdateCurrentSource(tU8 CurrentDevType);

      virtual void onActiveMediaDeviceError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/,
                                            const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::ActiveMediaDeviceError >& /*error*/);
      virtual void onActiveMediaDeviceStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/,
                                             const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::ActiveMediaDeviceStatus >& status);

      virtual void onPlaytimeError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
                                   const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::PlaytimeError >& error);

      virtual void onPlaytimeStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
                                    const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::PlaytimeStatus >& status);
      void vUpdateMediaPlayTime(const tU32& u32TotalPlaytime, const tU32& u32Elapsetime);

      virtual void onSeekToError(const ::boost::shared_ptr< mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
                                 const ::boost::shared_ptr< mplay_MediaPlayer_FI::SeekToError >& error);
      virtual void onSeekToResult(const ::boost::shared_ptr< mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
                                  const ::boost::shared_ptr< mplay_MediaPlayer_FI::SeekToResult >& result);

      virtual void onPlaybackStateError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
                                        const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::PlaybackStateError >& error);

      virtual void onPlaybackStateStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
                                         const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::PlaybackStateStatus >& status);

      virtual void onRequestPlaybackActionError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
            const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::RequestPlaybackActionError >& error);

      virtual void onRequestPlaybackActionResult(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
            const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::RequestPlaybackActionResult >& result);

      virtual void onNowPlayingError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
                                     const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::NowPlayingError >& error);

      virtual void onNowPlayingStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
                                      const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::NowPlayingStatus >& status);

      virtual void onCreateMediaPlayerPlaylistListError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/,
            const boost::shared_ptr< ::mplay_MediaPlayer_FI::CreateMediaPlayerPlaylistListError >& /*error*/);

      virtual void onCreateMediaPlayerPlaylistListResult(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/,
            const boost::shared_ptr< ::mplay_MediaPlayer_FI::CreateMediaPlayerPlaylistListResult >& result);
      virtual void onMediaPlayerListChangeError(const ::boost::shared_ptr< mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy, const ::boost::shared_ptr< mplay_MediaPlayer_FI::MediaPlayerListChangeError >& error);
      virtual void onMediaPlayerListChangeStatus(const ::boost::shared_ptr< mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy, const ::boost::shared_ptr< mplay_MediaPlayer_FI::MediaPlayerListChangeStatus >& status);
      void vSetPlaybackAction(tU32 u32ActionType, tU8 u8NextPrevSkipCount);
      void vUpdateNowPlayingMediaInfo(const ::mplay_MediaPlayer_FI::NowPlayingStatus& oMediaInfo);
      void vUpdateMetadtaInfo(const ::mplay_MediaPlayer_FI::NowPlayingStatus& oMediaInfo);

      void vModelComponentStatusUpdate(tU8 u8DevTag);
      void vAlbumArtUpdate(const ::mplay_MediaPlayer_FI::NowPlayingStatus& oMediaInfo);

      virtual void onRepeatModeError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/, const boost::shared_ptr< ::mplay_MediaPlayer_FI::RepeatModeError >& /*error*/);
      virtual void onRepeatModeStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/, const boost::shared_ptr< ::mplay_MediaPlayer_FI::RepeatModeStatus >& status);

      void vUpdateRepeatModeStatus(const uint32& u32RepeatMode);

      virtual void onPlaybackModeError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/, const boost::shared_ptr< ::mplay_MediaPlayer_FI::PlaybackModeError >& /*error*/);
      virtual void onPlaybackModeStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/, const boost::shared_ptr< ::mplay_MediaPlayer_FI::PlaybackModeStatus >& status);

      virtual void onGetMediaObjectAlbumArtInfoError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
            const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::GetMediaObjectAlbumArtInfoError >& error) ;

      virtual void onGetMediaObjectAlbumArtInfoResult(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
            const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::GetMediaObjectAlbumArtInfoResult >& result) ;

      virtual void onGetMediaObjectAlbumArtError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
            const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::GetMediaObjectAlbumArtError >& error);

      virtual void onGetMediaObjectAlbumArtResult(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
            const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::GetMediaObjectAlbumArtResult >& result);

      virtual void onPlayItemFromListByTagError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
            const boost::shared_ptr< ::mplay_MediaPlayer_FI::PlayItemFromListByTagError >& error);
      virtual void onPlayItemFromListByTagResult(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
            const boost::shared_ptr< ::mplay_MediaPlayer_FI::PlayItemFromListByTagResult >& result);
      void vUpdatePlayBackModeStatus(const uint32& u32PlayBackMode);

      // Folder based browsing methods
      virtual void onCreateMediaPlayerFileListError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
            const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::CreateMediaPlayerFileListError >& error);

      virtual void onCreateMediaPlayerFileListResult(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
            const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::CreateMediaPlayerFileListResult >& result);

      virtual void onRequestMediaPlayerFileListSliceError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/,
            const boost::shared_ptr< ::mplay_MediaPlayer_FI::RequestMediaPlayerFileListSliceError >& /*error*/);

      virtual void onRequestMediaPlayerFileListSliceResult(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/,
            const boost::shared_ptr< ::mplay_MediaPlayer_FI::RequestMediaPlayerFileListSliceResult >& result);

      void vUpdateNowPlayingAlbumArt(tU8 e8MediaDeviceType, const tChar* sMIMEImageSubtype, tU32 u32ImageSize, tU8* vImageData);

      bool onCourierBindingItemChange_PlaybackActionItem(const Courier::Request& request);
      bool onCourierBindingItemChange_AppleDeviceItem(const Courier::Request& request);
      bool onCourierBindingItemChange_BTPlayInfoUpdateItem(const Courier::Request& request);
      virtual void onReleaseMediaPlayerListError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/,
            const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::ReleaseMediaPlayerListError >& /*error*/);

      virtual void onReleaseMediaPlayerListResult(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
            const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::ReleaseMediaPlayerListResult >& result);

      virtual void onPlayItemFromListError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/,
                                           const boost::shared_ptr< ::mplay_MediaPlayer_FI::PlayItemFromListError >& /*error*/);

      virtual void onPlayItemFromListResult(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/,
                                            const boost::shared_ptr< ::mplay_MediaPlayer_FI::PlayItemFromListResult >& result);

      /*Entertainment mute functionality */

      virtual void onCreateMediaPlayerIndexedListError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
            const boost::shared_ptr< ::mplay_MediaPlayer_FI::CreateMediaPlayerIndexedListError >& error);

      virtual void onCreateMediaPlayerIndexedListResult(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
            const boost::shared_ptr< ::mplay_MediaPlayer_FI::CreateMediaPlayerIndexedListResult >& result);

      virtual void onRequestMediaPlayerIndexedListSliceError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
            const boost::shared_ptr< ::mplay_MediaPlayer_FI::RequestMediaPlayerIndexedListSliceError >& error);

      virtual void onRequestMediaPlayerIndexedListSliceResult(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
            const boost::shared_ptr< ::mplay_MediaPlayer_FI::RequestMediaPlayerIndexedListSliceResult >& result);

      virtual void onFolderBrowseStructureClearedError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
            const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::FolderBrowseStructureClearedError >& error);

      virtual void onFolderBrowseStructureClearedStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
            const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::FolderBrowseStructureClearedStatus >& status);

      /* Callback methods to clear the media player data for factory reset */
      virtual void onClearMediaPlayerDataError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
            const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::ClearMediaPlayerDataError >& error);

      virtual void onClearMediaPlayerDataResult(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
            const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::ClearMediaPlayerDataResult >& result);
      virtual void onSendAppleHIDCommandResult(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/, const boost::shared_ptr< ::mplay_MediaPlayer_FI::SendAppleHIDCommandResult >& result);
      virtual void onSendAppleHIDCommandError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/, const boost::shared_ptr< ::mplay_MediaPlayer_FI::SendAppleHIDCommandError >& /*error*/);
      void vTriggertStatemachine();
      void initStatemachine();
      void RequestMediaPlayerIndexedList(uint8 ListType, uint32 Index);
      void requestMediaPlayerSliceList(uint32 startIndex, uint32 windowSize);
      void RequestFolderList(uint32 m_u32SelectedIndex);
      void requestFolderSliceList(uint32 startIndex, uint32 windowSize);
      void createInstanceIfNull(uint32 listType);
      void insertNewUtilityDatabaseToListMap(uint32 listType, ListUtilityDatabase* listUtilityDatabase);
      void vReleaseMediaplayerListHandle(uint32 listType);
      void UpdateAlbumArt();
      void vPlayitemRequest(uint32 Index);
      void vRequestSubList(uint32 DestlistType, uint32 Index);
      void UpdateCurrentDevType();

      void BrowseListItemSelect(uint32 DestlistType, uint32 Index);
      void vUsbVideoLayerVisibility(bool VideoLayervisibility);
      void HandleBrowseFolderSubListRequest(uint32 SourcelistType, uint32 DestlistType, uint32 Index);
      bool bIsMaxFolderDepthReached() const;
      bool bHandleFilePlay(uint32 Index, uint32 SourceListtype);
      uint16 currentPlayingMediaType();
      void vCreateMapListTypetoMetaDataTag();
      void vUpdateIndexDatabase(uint32_t u8ListType, uint32_t u32Index);
      void vUpdateMetadataTags(::MPlay_fi_types::T_MPlayMediaObjects _oMediaObjects);
      void vUpdatePlayableStatus(::MPlay_fi_types::T_MPlayMediaObjects _oMediaObjects);
      void vCreateListData(::MPlay_fi_types::T_MPlayMediaObjects _oMediaObjects);
      void vHandleOneFieldListCreation(const uint32_t u32CurrentListType, ::MPlay_fi_types::T_MPlayMediaObjects _oMediaObjects);
      void vHandleTwoFieldListCreation(const uint32_t& u8CurrentListType, ::MPlay_fi_types::T_MPlayMediaObjects _oMediaObjects);
      void onRouterSourceAvailabilityUpdate(int iRouterAvailability);
      bool bCheckFolder(tU32 u32CurrentIndex);
      void vHandleParentLevelFolderListRequest();
      void vRequestParentfolderItems();
      void requestNewListEntry();

      void SetFileInfoStr(std::string _fileInfoStr);

      void vClearListDetailsMaps();
      void vClearListDataOnSizeEmpty();
      void vClearListInModel(uint32_t u32CurrentListType);
      void vClearListHandle();

      static void TraceCmd_TrackChange(uint8 operationType);
      void GetMetadataInfo(tU8 region, stNowPlayingInfo&);
      void onTrackCommandChangeRequest(uint32 u8trackCommandValue);
      virtual bool onCourierMessage(const onHardKeyPress& msg);
      bool vRequestRemoteCommands(uint32 hardkeyPress, uint32 hardKeyValue);
      void initialiseHdmiSrcAvailabilityMap();
#endif
      int getSourceId(int iDeviceType);
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      bool PerformToggleContext();

      virtual void onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data);

      std::string getBTDeviceName(uint8_t deviceTag);
      bool isDeviceConnectedInEvenPortNumber(std::string& sysPath);

      void setUSB2Visibile();
      int getUSBDevNum();
      void setUSBInactive();

      void clearMediaplayerDataForFactoryReset();
      int getActiveDeviceType();
      void sourceActivation(uint8 deviceTag);
      int getMediaPlayerDeviceType();

      int GetActiveUSBnum();
      void SetActiveSource(int subsrcid, int srcid);
      void getListHandle(uint32 listType);

      void updateFolderInfo();
      void updateFolderBrowsingHistory();
      void populateListFromHistory();
      void updateFolderListParameters();
      void releaseListHandle(uint32 listHandle);
      int getDeviceTag(int devicetype);
      int getUSB1DeviceTag();
      int getUSB2DeviceTag();
      int getIPODDeviceTag();
      int getBTDeviceTag();
      void clearFolderBrowseHistory();
      bool GetMediaDeviceConnectedStatus(uint8 deviceTag);
      bool getPrioSourceConnectedInfo();
      void vResetSeekedSliderFlag();
      int getMediaType();
      void getNowplayingStatus();
      void setTAActiveStatus(int taActiveStatus);
#endif
      uint32 ListTypeToStoreMetadataTag();
      uint32 ListTypeToUpdateIndexDatabase(uint32 listType);
      uint32 GetMediaDeviceType(uint8 deviceTag);
      int GetActiveUSBSource(int subsrcid);

#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
      void updateCurrentListType(uint32 listType);
      void setMediaDeviceType(int iDeviceType);
      void setActiveUSBSource(int iUSbDevNum);

#endif

   private:
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      ExternalMediaSourceHandler* _externalMediaSourceHandler;
      KDSHandler* _kdsHandler;
      std::string szOnGetDeviceName(tU32 uDeviceType)const;

      ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy > _mediaPlayerProxy; // reference for media player proxy

      ::boost::shared_ptr< bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy > _audioSourceChangeProxy;
      /** Instance of SoundPropertiesProxy */
      ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundPropertiesProxy > _soundPropertiesProxy;

      tVoid szOnConvertPlayTime(Candera::String& refTime, tU32 u32PlayTime);
      ::mplay_MediaPlayer_FI::NowPlayingStatus m_oMediaInfo;
      int  m_playbackstate;
      tU8 m_u8NowPlayingDevType;
      tU8 m_u8ActiveDevType;
      tU8 m_u8SinkId;
      tU8 m_u8ActiveRegion;
      tU32 m_TrackPosition;
      tU32 m_ListHandle;
      tU32 m_u32LastRequestedListHandle;
      char m_szCurrentTrackNumber[MEDIA_C_ETA_BUFFER_SIZE];
      tU8 m_u8PrevDevType;
      tU8 m_u8PrevDevTag;
      static tU8 m_u8CurrentDevType;
      act_t m_listReqAct;
      tU8 m_u8PrevMediaFileType;
      uint32 m_u32RepeatMode;
      uint32 m_u32PlayBackMode;
      uint16 m_MediaType;
      std::string strAlbumArt;
      std::string strCurrentAlbumArt;
      tChar m_sMIMEImageSubtype[256];
      tU32 mutable m_u32ImageSize;
      ::MPlay_fi_types::T_MPlayImageData m_ImageData;
      tU32 m_u32PrevImageSize;
      uint32 m_ConnectedDeviceCount;

      //Device Connection
      ::mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsStatus m_oDeviceConnectionStatus;
      stDeviceConnectionInfo m_StrDevice_USB;
      stDeviceConnectionInfo m_StrDevice_AUX;
      stDeviceConnectionInfo m_StrDevice_USB2;
      stDeviceConnectionInfo m_StrDevice_Apple_USB;
      stDeviceConnectionInfo m_StrDevice_BT;
      stDeviceInfo m_rActivedeviceInfo;
      SourcePrioDetails _mediaSourcesPriority;

      std::map <int, stDeviceConnectionInfo> m_DeviceInfoMap;
      std::map <int, stDeviceConnectionInfo>::iterator itr;
      std::map < SourceList, int > srcPriorityMap;

      tenBTDeviceType m_enBTDeviceType;
      int32 m_u32NumberOfFiles;
      uint8 m_u8CurrentEntGroup;

      uint8 m_u8CurrentDeviceTag;
      uint8 m_u8PreviousDeviceTag;
      uint8 m_u8ConnectedDeviceTag;
      uint8 m_e8ConnectedDeviceType;
      uint8 m_u8ActiveDeviceType;
      uint8 m_u8PrevConnectType;
      uint8 m_u8ConnectionType;
      uint8 m_u8CurrentEntGrp;
      uint8 m_u8CurrentNowplayingState;
      uint32 m_u32previousElapsedTime;

      uint8 m_selectedDevTag;

      uint8 _flagTile;

      DataBindingItem<PlaybackActionDataBindingSource> m_MediaPlayBackData;
      DataBindingItem<AppleDeviceDataBindingSource> m_MediaAppleDeviceData;
      DataBindingItem<BTPlayInfoUpdateDataBindingSource> m_MediaBTDeviceData;
      DataBindingItem<BrowseTextChangeDataBindingSource> _browseText;
      DataItemContainer<USB2VisibilityDataBindingSource> oUSB2Visibility;
      DataItemContainer<USB1ButtonDataBindingSource> USB1Button;
      DataItemContainer<GadgetItemVisibilityStateDataBindingSource> m_GadgetItemsVisibility;

      //uint32_t m_currentListSize;
      uint8 m_currentListState;
#endif
      uint32_t m_u32CurrentListType;
      static  tclMediaClientHandler* _mediaClientHandler;
      int m_deviceusbnum;

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      int32_t m_windowStartIndex;
      int32_t m_FolderFilewindowStartIndex;
      int32_t m_windowSize;
      uint32 _remainItem;
      int32 m_i32requestedSeekTime;
      bool m_isSeeked;
      uint32 m_u32SelectedIndex;
      //int32_t u32listtype;
      uint32 m_u32ParentListType;
      std::map<uint32, ListUtilityDatabase* > _listMap;
      std::map <tU32, tU32> m_ListTypetoMetaDataTagMap;

      //std::map <tU8, stNowPlayingInfo> _metadataMap;
      std::map <tU8, tU8> m_u8DevTagMap;

      ::MPlay_fi_types::T_MPlayMediaObjects _oMediaObjects;
      ::MPlay_fi_types::T_MPlayFileList _oFileListMediaObjects;

      std::vector<std::string> _sOneItemListText;
      std::vector<media_TwoTextListInfo> _sTwoItemListText;
      std::vector<std::string> _sFolderListItemText;

      ListStatus enListStatus;
      ListType enListType;

      std::string m_fileInfoStr;

      asf::core::Timer _videoTimer;
      trMplay_FolderList m_oMPlayHistoryFolderList;
      /*Handle to maintain folder hierarchy during BTN_Up */
      trMplay_FolderList m_oMPlayParentFolderList;  /* Create one new vector for structure trMPlay_FolderListItem */
      trMPlay_FolderListItem m_oFolderListItem;
      uint8 m_u8ChangedDeviceHandle;
      FolderListInfo _folderListInfo;
      std::vector<FolderListInfo> _folderListBrowsingHistory;
      std::map < int, int> _hdmiSrcAvailability;
      tU8 m_u8Filetype;
      int m_routerUsbConnectionState;
      int _usbCamportAvailability;

      bool m_fastForwardOnGoing;
      bool m_fastBackwardOnGoing;
      int _taActiveValue;
#else
      int  m_deviceType ;

#endif
};


}//end of Core
}//end of App


#endif // _MEDIA_PLAYSCREEN_HANDLING_H_
