/**************************************************************************************
 * @file         : ListSession.cpp
 * @author       : RBEI/ECH2-INF4CV_MediaTeam
 * @addtogroup   : AppHmi_media
 * @brief        :
 * @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 * 		  			Initial Revision.
 **************************************************************************************/

#include "hall_std_if.h"
#include "Core/ListHandling/ListSession/ListSession.h"
#include <vector>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::ListSession::
#include "trcGenProj/Header/ListSession.cpp.trc.h"
#endif

namespace App {
namespace Core {

ListSession::ListSession()
{
   ETG_TRACE_USR1(("ListSession constructor \n"));
   resetSession();
}


ListSession::~ListSession()
{
   ETG_TRACE_USR1(("ListSession Destructor \n"));
}


void ListSession::resetSession()
{
   ETG_TRACE_USR1(("ListSession resetSession \n"));
   m_currentListSession = LIST_SESSION_UNKNOWN;
}


void ListSession::setNextListSession(enListSession activeListSession)
{
   ETG_TRACE_USR4(("ListSession setNextListSession activeListSession %d", ETG_CENUM(enListSession, activeListSession)));
   m_currentListSession = activeListSession;
}


enListSession ListSession::getCurrentSession()
{
   ETG_TRACE_USR4(("ListSession getCurrentSession _currentListSession  %d", ETG_CENUM(enListSession, m_currentListSession)));
   return m_currentListSession;
}


}// namespace Core
}// namespace App
