/**************************************************************************************
* @file         : ListInfoDatabaseHandler..h
* @author       : RBEI/ECH2-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _ListInfoDatabaseHandler_H_
#define _ListInfoDatabaseHandler_H_

#include "AppBase/ServiceAvailableIF.h"
#include "AppHmi_MediaStateMachine.h"
#include "AppHmi_MediaDatabinding.h"
#include "AvdeccPluginConstant.h"
#include "Core/ExternalMediaDefines.h"
#include "Core/ListHandling/ListInfoDatabase/ListInfoDatabase.h"
#include <bits/stdc++.h>

namespace App {
namespace Core {

class ListInfoDatabase;

class ListInfoDatabaseHandler
{
   public:
      ListInfoDatabaseHandler();
      virtual ~ListInfoDatabaseHandler();

      EnumConst::entListType getActiveListType();
      enListState getListStateOnListDataRequest(EnumConst::entListType iActiveListType);
      void createDbIfNotAvailable(EnumConst::entListType iActiveListType);
      void updateCurrentListSize(EnumConst::entListType iActiveListType, int icurrentlistSize);
      int getCurrentListSize(EnumConst::entListType iActiveListType);
      void updateListState(EnumConst::entListType iActiveListType, enListState listState);
      bool isListTypeAvailable(EnumConst::entListType iActiveListType);
      void resetDatabase();
      void resetMembers();
      void updateListStateOnListExit();
      void updateListStateOnDeviceDisconnection();
      int getAbsoluteIndex(EnumConst::entListType iActiveListType, int selectedrow);
      void updateAbsoluteIndex(EnumConst::entListType iActiveListType, std::vector<uint16>& absoluteIndex);
      void updateStartIndex(EnumConst::entListType iActiveListType, uint16 startIndex);
   private:
      ListInfoDatabase* _listInfoDatabase;
      ListInfoDatabaseHandler& operator= (const ListInfoDatabaseHandler& obj);
      ListInfoDatabaseHandler(const ListInfoDatabaseHandler& obj);
};


} // namespace Core
} // namespace App


#endif  /* _ListInfoDatabaseHandler_H_ */
