/**************************************************************************************
 * @file         : ListInfoDatabaseHandler.cpp
 * @author       : RBEI/ECH2-INF4CV_MediaTeam
 * @addtogroup   : AppHmi_media
 * @brief        :
 * @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 * 		  			Initial Revision.
 **************************************************************************************/

#include "hall_std_if.h"
#include "Core/ListHandling/ListInfoDatabaseHandler/ListInfoDatabaseHandler.h"
#include "Core/ExternalMediaDefines.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include <vector>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::ListInfoDatabaseHandler::
#include "trcGenProj/Header/ListInfoDatabaseHandler.cpp.trc.h"
#endif

namespace App {
namespace Core {

ListInfoDatabaseHandler::ListInfoDatabaseHandler()
   : _listInfoDatabase(NULL)
{
   ETG_TRACE_USR1(("ListInfoDatabaseHandler constructor \n"));
   if (NULL == _listInfoDatabase)
   {
      _listInfoDatabase = new ListInfoDatabase();
   }
}


ListInfoDatabaseHandler::~ListInfoDatabaseHandler()
{
   ETG_TRACE_USR1(("ListInfoDatabaseHandler Destructor \n"));

   if (NULL != _listInfoDatabase)
   {
      delete _listInfoDatabase;
      _listInfoDatabase = NULL;
   }

   resetMembers();
}


void ListInfoDatabaseHandler::resetMembers()
{
   ETG_TRACE_USR1(("ListInfoDatabaseHandler resetMembers \n"));
}


EnumConst::entListType ListInfoDatabaseHandler::getActiveListType()
{
   EnumConst::entListType activeListType = EnumConst::entListType_Invalid;
   bool bListStatus = _listInfoDatabase->isListActive();
   if (bListStatus)
   {
      activeListType = _listInfoDatabase->getListTypeActive();
   }

   ETG_TRACE_USR4(("ListInfoDatabaseHandler getActiveListType bListStatus  activeListType %d   %d", bListStatus, ETG_CENUM(entListType, activeListType)));
   return activeListType;
}


enListState ListInfoDatabaseHandler::getListStateOnListDataRequest(EnumConst::entListType iActiveListType)
{
   enListState currentListState = _listInfoDatabase->getListState(iActiveListType);
   ETG_TRACE_USR4(("ListInfoDatabaseHandler getListStateOnListDataRequest listState  %d", ETG_CENUM(enListState, currentListState)));

   if (currentListState == EN_LIST_STATE_UNKNOWN)
   {
      createDbIfNotAvailable(iActiveListType);
   }
   return currentListState;
}


void ListInfoDatabaseHandler::createDbIfNotAvailable(EnumConst::entListType iActiveListType)
{
   bool isListInfoAvail = _listInfoDatabase->isListInfoAvailable(iActiveListType);
   ETG_TRACE_USR4(("ListInfoDatabaseHandler createDbIfNotAvailable iActiveListType %d  isListInfoAvail  %d", ETG_CENUM(entListType, iActiveListType), isListInfoAvail));

   if (isListInfoAvail == false)
   {
      _listInfoDatabase->createListDatabase(iActiveListType);
   }
}


bool ListInfoDatabaseHandler::isListTypeAvailable(EnumConst::entListType iActiveListType)
{
   bool isListInfoAvail = _listInfoDatabase->isListInfoAvailable(iActiveListType);
   ETG_TRACE_USR4(("ListInfoDatabaseHandler createDbIfNotAvailable iActiveListType %d  isListInfoAvail  %d", ETG_CENUM(entListType, iActiveListType), isListInfoAvail));
   return isListInfoAvail;
}


void ListInfoDatabaseHandler::updateCurrentListSize(EnumConst::entListType iActiveListType, int icurrentlistSize)
{
   bool isListInfoAvail = _listInfoDatabase->isListInfoAvailable(iActiveListType);
   ETG_TRACE_USR4(("ListInfoDatabaseHandler updateCurrentListSize isListInfoAvail  %d", isListInfoAvail));

   if (isListInfoAvail == true)
   {
      _listInfoDatabase->updateListSize(iActiveListType, icurrentlistSize);
   }
}


int ListInfoDatabaseHandler::getCurrentListSize(EnumConst::entListType iActiveListType)
{
   int iListSize = _listInfoDatabase->getCurrentListSize(iActiveListType);
   ETG_TRACE_USR4(("ListInfoDatabaseHandler getCurrentListSize iActiveListType   %d isListInfoAvail  %d", ETG_CENUM(entListType, iActiveListType), iListSize));
   return iListSize;
}


void ListInfoDatabaseHandler::updateListState(EnumConst::entListType iActiveListType, enListState listState)
{
   _listInfoDatabase->updateListState(iActiveListType, listState);
   ETG_TRACE_USR4(("ListInfoDatabaseHandler updateListState iActiveListType  listState   %d    %d", ETG_CENUM(entListType, iActiveListType), ETG_CENUM(enListState, listState)));
}


void ListInfoDatabaseHandler::resetDatabase()
{
   ETG_TRACE_USR4(("ListInfoDatabaseHandler::resetDatabase "));
   _listInfoDatabase->resetListDatabase();
}


void ListInfoDatabaseHandler::updateListStateOnListExit()
{
   ETG_TRACE_USR1(("ListInfoDatabaseHandler::updateListStateOnListExit "));
   _listInfoDatabase->updateListStateOnBrowseExit();
}


void ListInfoDatabaseHandler::updateListStateOnDeviceDisconnection()
{
   ETG_TRACE_USR1(("ListInfoDatabaseHandler::updateListStateOnDeviceDisconnection "));
   _listInfoDatabase->updateListStateOnDeviceRemoval();
}


void ListInfoDatabaseHandler::updateAbsoluteIndex(EnumConst::entListType iActiveListType, std::vector<uint16>& absoluteIndex)
{
   ETG_TRACE_USR4(("ListInfoDatabaseHandler::updateAbsoluteIndex iActiveListType  %d , vector size  %d ", ETG_CENUM(entListType, iActiveListType), absoluteIndex.size()));
   _listInfoDatabase->updateAbsoluteIndex(iActiveListType, absoluteIndex);
}


int ListInfoDatabaseHandler::getAbsoluteIndex(EnumConst::entListType iActiveListType, int selectedrow)
{
   int _absoluteIndex = 0;
   ETG_TRACE_USR1(("ListInfoDatabaseHandler::getAbsoluteIndex iActiveListType  selectedrow   %d    %d", ETG_CENUM(entListType, iActiveListType), selectedrow));
   _absoluteIndex = _listInfoDatabase->getAbsoluteIndex(iActiveListType, selectedrow);

   return _absoluteIndex;
}


void ListInfoDatabaseHandler::updateStartIndex(EnumConst::entListType iActiveListType, uint16 startIndex)
{
   ETG_TRACE_USR4(("ListInfoDatabaseHandler::updateStartIndex startIndex  %d ", startIndex));
   _listInfoDatabase->updateStartIndex(iActiveListType, startIndex);
}


}// namespace Core
}// namespace App
