/**************************************************************************************
* @file         : ListInfoDatabase..h
* @author       : RBEI/ECH2-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _ListInfoDatabase_H_
#define _ListInfoDatabase_H_

#include <map>

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "Core/ExternalMediaDefines.h"
#include "AppHmi_MediaStateMachine.h"
#include "AppHmi_MediaDatabinding.h"
#include "AvdeccPluginConstant.h"
#include <bits/stdc++.h>
#else
#include "utest/stubs/Apphmi_Media_Types_Common.h"
#include "utest/stubs/etg.h"
#endif

namespace App {
namespace Core {
class ListInfoDatabase
{
   public:
      ListInfoDatabase();
      virtual ~ListInfoDatabase();

      bool isListInfoAvailable(EnumConst::entListType listType);
      void createListDatabase(EnumConst::entListType listType);
      void resetListDatabase();
      void resetMembers();
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      enListState getListState(EnumConst::entListType listType);
      void updateListSize(EnumConst::entListType listType, int totalListSize);
      EnumConst::entListType getListTypeActive();
      int getCurrentListSize(EnumConst::entListType iActiveListType);
      void updateListState(EnumConst::entListType iActiveListType, enListState currentListState);
      bool isListActive();
      void updateListStateOnDeviceRemoval();
      void updateListStateOnBrowseExit();
      void updateOtherListStatesInactive(EnumConst::entListType iActiveListType);
      void updateAbsoluteIndex(EnumConst::entListType iActiveListType, std::vector<uint16>& _absoluteIndex);
      int getAbsoluteIndex(EnumConst::entListType iActiveListType, int selectedrow);
      void updateStartIndex(EnumConst::entListType iActiveListType, uint16 startIndex);
#endif
   private:
      std::map<EnumConst::entListType, stListInfo> _listInfoMap;
      stListInfo stListDetails;
      EnumConst::entListType m_activeListType;
};


} // namespace Core
} // namespace App


#endif  /* _ListInfoDatabase_H_ */
