/**************************************************************************************
 * @file         : HorizontalListGuiResponseHandler.cpp
 * @author       : RBEI/ECH2-INF4CV_MediaTeam
 * @addtogroup   : AppHmi_media
 * @brief        :
 * @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 * 		  			Initial Revision.
 **************************************************************************************/


#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "hall_std_if.h"
#endif
#include "Core/ListHandling/ListGuiResponseHandler/HorizontalListGuiResponseHandler.h"
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "Core/SourceSwitch/MediaSourceHandling.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include "Core/Utils/DbDownloadMap.h"
#include "DataModel/HMIModelComponent.h"
#include "CgiExtensions/ImageLoader.h"
#include "MPlay_fi_types.h"
#include <vector>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::HorizontalListGuiResponseHandler::
#include "trcGenProj/Header/HorizontalListGuiResponseHandler.cpp.trc.h"
#endif

#endif
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
#include "utest/stubs/Apphmi_Media_Types_Common.h"
#endif

namespace App {
namespace Core {

#define TOTAL_HOR_LIST_ITEMS 9;

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
HorizontalListGuiResponseHandler::HorizontalListGuiResponseHandler(PlayableContentMap* _playableContentMapInstance, EnumConst::entSourceType sourceType)
{
   ETG_TRACE_USR1(("HorizontalListGuiResponseHandler constructor \n"));
   vCreateMapListTypetoListTabInfo();
   _playableContentMap = _playableContentMapInstance;
   m_u8startindex = 0;
   _currentSourceType = sourceType;
   m_currentListType = EnumConst::entListType_Invalid;
   //m_downloadStatus = 0;
}


HorizontalListGuiResponseHandler::~HorizontalListGuiResponseHandler()
{
   ETG_TRACE_USR1(("HorizontalListGuiResponseHandler Destructor \n"));
}


void HorizontalListGuiResponseHandler::resetMembers()
{
   ETG_TRACE_USR1(("HorizontalListGuiResponseHandler resetMembers \n"));
   m_u8startindex = 0;
   m_currentListType = EnumConst::entListType_Invalid;
}


void HorizontalListGuiResponseHandler::updateListContent()
{
   tSharedPtrDataProvider dataProvider = buildHorizontalList();
   int pageIndex = onScrollToIndex();
   ETG_TRACE_USR4(("HorizontalListGuiResponseHandler updateListContent pageIndex %d", pageIndex));

   dataProvider->setListChangeSetIndex(pageIndex);
   dataProvider->setCacheOnOff(false);
   POST_MSG((COURIER_MESSAGE_NEW(ListDateProviderResMsg)(dataProvider)));
}


tSharedPtrDataProvider HorizontalListGuiResponseHandler::buildHorizontalList()
{
   ListDataProviderBuilder listBuilder(LISTID_EXTERNAL_MEDIA_HOR, "MediaMenuVideo");

   unsigned item = 0;

   for (unsigned size = 0; size < m_ListTypetoTabInfo.size(); size++)
   {
      if (m_currentListType == m_ListTypetoTabInfo[item].currentListType)
      {
         listBuilder.AddItem(item, 0, m_ListTypetoTabInfo[item].ListTemplate).AddData(1).AddData(isHorizontalListTabEnabled(item));
      }
      else
      {
         listBuilder.AddItem(item, 0, m_ListTypetoTabInfo[item].ListTemplate).AddData(0).AddData(isHorizontalListTabEnabled(item));
      }
      item++;
   }

   tSharedPtrDataProvider dataProvider = listBuilder.CreateDataProvider();

   (*_setTabVideoSource).mTabVideoSourceVisibility = true;
   _setTabVideoSource.MarkAllItemsModified();
   _setTabVideoSource.SendUpdate(true);

   return dataProvider;
}


#endif


void HorizontalListGuiResponseHandler::updateListType(EnumConst::entListType listType)
{
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   ETG_TRACE_USR4(("HorizontalListGuiResponseHandler::updateListType listType:%d", listType));
#endif
   m_currentListType = listType;
}


int HorizontalListGuiResponseHandler::onScrollToIndex()
{
   int pageIndex = EN_MEDIA_INDEX0;

   switch (m_u8startindex)
   {
      case EN_MEDIA_INDEX0:
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
         POST_MSG(COURIER_MESSAGE_NEW(ListChangeMsg)(LISTID_MEDIA_HOR, ListChangeSet, EN_MEDIA_INDEX0));
#endif
         pageIndex = 0;
         break;
      case EN_MEDIA_INDEX3:
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
         POST_MSG(COURIER_MESSAGE_NEW(ListChangeMsg)(LISTID_MEDIA_HOR, ListChangeSet, EN_MEDIA_INDEX3));
#endif
         pageIndex = 3;
         break;
      case EN_MEDIA_INDEX6:
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
         POST_MSG(COURIER_MESSAGE_NEW(ListChangeMsg)(LISTID_MEDIA_HOR, ListChangeSet, EN_MEDIA_INDEX5));
#endif
         pageIndex = 6;
         break;
      default:
         break;
   }


#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   switch (m_u8startindex)
   {
      case EN_MEDIA_INDEX0:
         //Disable the previous button and enable next button

         if ((_playableContentMap->getPlayableAudioContent(_currentSourceType) == true) || (_playableContentMap->getPlayableVideoContent(_currentSourceType) == true))
         {
            (*_pageNextPrevIndex).mPrevIndex = false;
            (*_pageNextPrevIndex).mNextIndex = true;

            (*_pageNextPrevIndex).mEnableTouchPrev = false;
            (*_pageNextPrevIndex).mEnableTouchNext = true;
         }
         else
         {
            (*_pageNextPrevIndex).mPrevIndex = false;
            (*_pageNextPrevIndex).mNextIndex = false;

            (*_pageNextPrevIndex).mEnableTouchPrev = false;
            (*_pageNextPrevIndex).mEnableTouchNext = false;
         }
         break;
      case EN_MEDIA_INDEX3:

         (*_pageNextPrevIndex).mPrevIndex = true;
         (*_pageNextPrevIndex).mNextIndex = true;

         (*_pageNextPrevIndex).mEnableTouchPrev = true;
         (*_pageNextPrevIndex).mEnableTouchNext = true;
         break;
      case EN_MEDIA_INDEX5:
         if ((_playableContentMap->getPlayableAudioContent(_currentSourceType) == true) || (_playableContentMap->getPlayableVideoContent(_currentSourceType) == true))
         {
            //Disable the Nextybutton and enable Previous button

            (*_pageNextPrevIndex).mPrevIndex = true;
            (*_pageNextPrevIndex).mNextIndex = false;

            (*_pageNextPrevIndex).mEnableTouchPrev = true;
            (*_pageNextPrevIndex).mEnableTouchNext = false;
         }
         else
         {
            (*_pageNextPrevIndex).mPrevIndex = false;
            (*_pageNextPrevIndex).mNextIndex = false;

            (*_pageNextPrevIndex).mEnableTouchPrev = false;
            (*_pageNextPrevIndex).mEnableTouchNext = false;
         }
         break;
      default:
         break;
   }

   _pageNextPrevIndex.MarkAllItemsModified();
   _pageNextPrevIndex.SendUpdate();

   ETG_TRACE_USR4(("HorizontalListGuiResponseHandler::onScrollToIndex pageIndex:%d", pageIndex));
#endif
   return pageIndex;
}


void HorizontalListGuiResponseHandler::updateListStartIndex(int startIndex)
{
   m_u8startindex = startIndex;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   ETG_TRACE_USR4(("HorizontalListGuiResponseHandler::updateListStartIndex m_u8startindex:%d", m_u8startindex));
#endif
}


#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
void HorizontalListGuiResponseHandler::vCreateMapListTypetoListTabInfo()
{
   m_ListTypetoTabInfo[EXT_TAB_TITLE].ListTemplate = "MediaMenuTitle";
   m_ListTypetoTabInfo[EXT_TAB_TITLE].currentListType = EnumConst::entListType_Song;
   ///////
   m_ListTypetoTabInfo[EXT_TAB_ARTIST].ListTemplate = "MediaMenuArtist";
   m_ListTypetoTabInfo[EXT_TAB_ARTIST].currentListType = EnumConst::entListType_Artist;

   //////
   m_ListTypetoTabInfo[EXT_TAB_ALBUM].ListTemplate = "MediaMenuAlbum";
   m_ListTypetoTabInfo[EXT_TAB_ALBUM].currentListType = EnumConst::entListType_Album;

   /////////
   m_ListTypetoTabInfo[EXT_TAB_GENRE].ListTemplate = "MediaMenuGenre";
   m_ListTypetoTabInfo[EXT_TAB_GENRE].currentListType = EnumConst::entListType_Genre;

   //////
   m_ListTypetoTabInfo[EXT_TAB_FOLDER].ListTemplate = "MediaMenuFolder";
   m_ListTypetoTabInfo[EXT_TAB_FOLDER].currentListType = EnumConst::entListType_Folder;

   ///////
   m_ListTypetoTabInfo[EXT_TAB_PLAYLIST].ListTemplate = "MediaMenuPlaylist";
   m_ListTypetoTabInfo[EXT_TAB_PLAYLIST].currentListType = EnumConst::entListType_Playlist;

   /////
   m_ListTypetoTabInfo[EXT_TAB_AUDIOBOOK].ListTemplate = "MediaMenuAudiobook";
   m_ListTypetoTabInfo[EXT_TAB_AUDIOBOOK].currentListType = EnumConst::entListType_Invalid;

   /////
   m_ListTypetoTabInfo[EXT_TAB_PODCAST].ListTemplate = "MediaMenuPodcast";
   m_ListTypetoTabInfo[EXT_TAB_PODCAST].currentListType = EnumConst::entListType_Invalid;

   //////
   m_ListTypetoTabInfo[EXT_TAB_VIDEO].ListTemplate = "MediaMenuVideo";
   m_ListTypetoTabInfo[EXT_TAB_VIDEO].currentListType = EnumConst::entListType_Video;

   m_ListTypetoTabInfo[EXT_TAB_VIDEO_LANGUAGE].ListTemplate = "MediaMenuVideoLanguage";
   m_ListTypetoTabInfo[EXT_TAB_VIDEO_LANGUAGE].currentListType = EnumConst::entListType_Video_Languages;
}


#endif

bool HorizontalListGuiResponseHandler::isHorizontalListTabEnabled(int index)
{
   bool isHorizontalListTabEnabled = false;
   // uint16 l_downloadStatus;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   // l_downloadStatus = DbDownloadMap::getInstance().getDbDownloadState(_currentSourceType);
   //ETG_TRACE_USR4(("HorizontalListGuiResponseHandler::isHorizontalListTabEnabled index %d DownloadStatus %d ", index, l_downloadStatus));
#endif
   //if (l_downloadStatus == EnumConst::entDownloadState_Downloadsuccess)
   //{
   //--Code start Temprorily adding code to disabele all tabs other than title and video
   /*if (((index >= TAB_TITLE) && (index <= TAB_PLAYLIST)) && (_isAudioFileAvailable))
   {
      // temporarily disabling folder, becuase the implementation for folder is not available from emplisthandler
      if (index != TAB_FOLDER)
      {
         isHorizontalListTabEnabled = true;
      }
   }
   else if ((index == TAB_VIDEO) && (_isVideoFileAvailable))
   {
      isHorizontalListTabEnabled = true;
   } temprory disabling the other tabs*/
   //--Code end>>
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   switch (index)
   {
      case EXT_TAB_TITLE:
      {
         if (_playableContentMap->getPlayableAudioContent(_currentSourceType) == true)
         {
            isHorizontalListTabEnabled = true;
         }
         break;
      }

      case EXT_TAB_ARTIST:
      case EXT_TAB_ALBUM:
      case EXT_TAB_GENRE:
      case EXT_TAB_PLAYLIST:

      {
         if (_playableContentMap->getPlayableAudioContent(_currentSourceType) == true)
         {
            isHorizontalListTabEnabled = ((_currentSourceType == EnumConst::entSourceType_CMP) || (_currentSourceType == EnumConst::entSourceType_CMR)) ? false : true;
         }
         break;
      }
      case EXT_TAB_VIDEO:
      case EXT_TAB_VIDEO_LANGUAGE:

      {
         if (_playableContentMap->getPlayableVideoContent(_currentSourceType) == true)
         {
            isHorizontalListTabEnabled = true;
         }

         break;
      }
      case EXT_TAB_FOLDER:
      {
         if (_playableContentMap->getPlayableAudioContent(_currentSourceType) == true || (_playableContentMap->getPlayableVideoContent(_currentSourceType) == true))
         {
            isHorizontalListTabEnabled = true;
         }
         break;
      }
      default:
      {
         ETG_TRACE_USR4(("ExternalMediaClientHandler::onCourierMessage:srcID: INVALID DEVICE"));
         break;
      }
   }// End of Switch
#endif
   // }
   ETG_TRACE_USR1(("HorizontalListGuiResponseHandler: isHorizontalListTabEnabled: index %d, isHorizontalListTabEnabled %d", index, isHorizontalListTabEnabled));
   return isHorizontalListTabEnabled;
}


}// namespace Core
}// namespace App
