/**************************************************************************************
 * @file         : ListGuiRequestHandler.cpp
 * @author       : RBEI/ECH2-INF4CV_MediaTeam
 * @addtogroup   : AppHmi_media
 * @brief        :
 * @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 * 		  			Initial Revision.
 **************************************************************************************/

#include "hall_std_if.h"
#include "Core/ListHandling/ListGuiRequestHandler/ListGuiRequestHandler.h"
#include "Core/SourceSwitch/MediaSourceHandling.h"
#include "Core/ApplicationSwitchClientHandler/ApplicationSwitchClientHandler.h"
#include "Core/ListHandling/HorizontalListManager/HorizontalListManager.h"
#include "Core/ListHandling/VerticalListManager/VerticalListManager.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include "AppHmi_MediaStateMachine.h"
#include "AppHmi_MediaDatabinding.h"
#include "CgiExtensions/ImageLoader.h"
#include "AvdeccPluginConstant.h"
#include "Core/ExternalMediaDefines.h"
#include "ProjectBaseTypes.h"
#include "MPlay_fi_types.h"
#include <vector>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::ListGuiRequestHandler::
#include "trcGenProj/Header/ListGuiRequestHandler.cpp.trc.h"
#endif

namespace App {
namespace Core {


ListGuiRequestHandler::ListGuiRequestHandler(HorizontalListManager* _horizontalListManagerObj,
      VerticalListManager* _verticalListManagerObj)
{
   ETG_TRACE_USR1(("ListGuiRequestHandler Parameterised constructor \n"));
   _horizontalListManager = _horizontalListManagerObj;
   _verticalListManager = _verticalListManagerObj;
   m_windowSize = WINDOW_SIZE;
}


ListGuiRequestHandler::~ListGuiRequestHandler()
{
   ETG_TRACE_USR1(("ListGuiRequestHandler Destructor \n"));
   m_windowSize = 0;
}


void ListGuiRequestHandler::resetMembers()
{
   ETG_TRACE_USR1(("ListGuiRequestHandler resetMembers \n"));
   m_windowSize = 0;
}


/* ***********************************************************
* Function 		: getListDataProvider
* Description 	: Updates the List data Based on the LIST_IDs
* Parameters 	: ListDateProviderReqMsg &oMsg
* Return value	: tSharedPtrDataProvider
* ***********************************************************/
tSharedPtrDataProvider ListGuiRequestHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_USR4(("ListGuiRequestHandler::getListDataProvider list id %u, startindex %d, count %u", oMsg.GetListId(), oMsg.GetStartIndex(), oMsg.GetWindowElementSize()));

   tSharedPtrDataProvider dataProvider;

   if (oMsg.GetListId() == LISTID_EXTERNAL_MEDIA_HOR)
   {
      _horizontalListManager->onListDataRequest(oMsg.GetStartIndex());
   }
   else if (oMsg.GetListId() == LIST_ID_EXTERNAL_MEDIA_VER)
   {
      _verticalListManager->onListDataRequest(oMsg.GetListId(), oMsg.GetStartIndex(), oMsg.GetWindowElementSize());
   }

   return dataProvider;
}


/* ***********************************************************
* Function 		: onCourierMessage
* Description 	: Courier message received when there is change in the list
* Parameters 	: oMsg
* Return value	: void
* ***********************************************************/
bool ListGuiRequestHandler::onCourierMessage(const ListChangedUpdMsg& oMsg)
{
   ETG_TRACE_USR4(("ListGuiRequestHandler::onCourierMessage:ListChangedUpdMsg listid:%d", oMsg.GetListId()));
   EnumConst::entListType listType = EnumConst::entListType_Invalid;
   if (oMsg.GetListId() == LISTID_EXTERNAL_MEDIA_HOR)
   {
      _horizontalListManager->onListChangeUpdate(oMsg.GetStartIndex());
      return true;
   }
   return false;
}


bool ListGuiRequestHandler::onCourierMessage(const ExternalMediaListItemPressUpdMsg& oMsg)
{
   unsigned int Hdl = oMsg.GetHdl();
   unsigned int SubHdl = oMsg.GetSubHdl();
   ETG_TRACE_USR1(("ListGuiRequestHandler::ExternalMediaListItemPressUpdMsg Hdl: %d, SubHdl %d", Hdl, SubHdl));
   _verticalListManager->onListItemPressed(Hdl, SubHdl);
   return true;
}


bool ListGuiRequestHandler::onCourierMessage(const ExternalMediaTabBtnPressUpdMsg& oMsg)
{
   ETG_TRACE_USR4(("ListGuiRequestHandler::ExternalMediaTabBtnPressUpdMsg SelectMediaTab: %d", oMsg.GetSelectMediaTab()));
   unsigned int selectMediaTab = oMsg.GetSelectMediaTab();
   _horizontalListManager->onHorizontalListTabPressed(selectMediaTab);
   return true;
}


bool ListGuiRequestHandler::onCourierMessage(const ExternalMediaTabListPageUpReqMsg& oMsg)
{
   ETG_TRACE_USR1(("ListGuiRequestHandler::ExternalMediaTabListPageUpReqMsg"));
   int8_t pageDirection = EN_MEDIATAB_PAGEUP;
   _horizontalListManager->onHorizontalListPageUpPageDownPressed(pageDirection);
   return true;
}


bool ListGuiRequestHandler::onCourierMessage(const ExternalMediaTabListPageDownReqMsg& oMsg)
{
   ETG_TRACE_USR1(("ListGuiRequestHandler::ExternalMediaTabListPageDownReqMsg:"));
   int8_t pageDirection = EN_MEDIATAB_DOWN;
   _horizontalListManager->onHorizontalListPageUpPageDownPressed(pageDirection);
   return true;
}


bool ListGuiRequestHandler::onCourierMessage(const ExternalMediaBackButtonPressUpdMsg& oMsg)
{
   ETG_TRACE_USR1(("ListGuiRequestHandler::ExternalMediaBackButtonPressUpdMsg"));
   _verticalListManager->onPreviousButtonPressed();
   return true;
}


bool ListGuiRequestHandler::onCourierMessage(const ExternalMediaAllButtonPressUpdMsg& oMsg)
{
   ETG_TRACE_USR1(("ListGuiRequestHandler::ExternalMediaAllButtonPressUpdMsg"));
   _verticalListManager->onAllButtonPressed();
   return true;
}


bool ListGuiRequestHandler::onCourierMessage(const ExternalBrowseScreenExitUpdMsg& oMsg)
{
   ETG_TRACE_COMP(("ListGuiRequestHandler::ExternalBrowseScreenExitUpdMsg: oMsg.GetListId() = %d", oMsg.GetListId()));
   if (oMsg.GetListId() == LIST_ID_EXTERNAL_MEDIA_VER)
   {
      _verticalListManager->onExternalBrowseScreenExit();
   }
   return true;
}


}// namespace Core
}// namespace App
