/**************************************************************************************
 * @file         : ListContainer.cpp
 * @author       : RBEI/ECH2-INF4CV_MediaTeam
 * @addtogroup   : AppHmi_media
 * @brief        :
 * @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 * 		  			Initial Revision.
 **************************************************************************************/

#include "hall_std_if.h"
#include "ListContainer.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::ListContainer::
#include "trcGenProj/Header/ListContainer.cpp.trc.h"
#endif

namespace App {
namespace Core {


ListContainer::ListContainer()
{
   ETG_TRACE_USR1(("ListContainer constructor \n"));
   _isAllLanguageSelected = false;
   _currentFolderPath = "/";
   _fileType.clear();
}


ListContainer::~ListContainer()
{
   ETG_TRACE_USR1(("ListContainer Destructor \n"));
}


void ListContainer::resetMembers()
{
   ETG_TRACE_USR1(("ListContainer resetMembers \n"));
   m_firstMetadata.clear();
   m_secondMetadata.clear();
   m_absoluteIndex.clear();
   _isLanguageSelected.clear();
   _isAllLanguageSelected = false;
   _selectedLanguageId.clear();
   _currentFolderPath = "/";
}


void ListContainer::setFirstTextOfList(std::vector<std::string> _firstMetadata)
{
   ETG_TRACE_USR1(("ListContainer setAbsoluteIndex: _firstMetadata.size() = %d\n", _firstMetadata.size()));
   m_firstMetadata = _firstMetadata;
}


void ListContainer::setSecondTextOfList(std::vector<std::string> _secondMetadata)
{
   ETG_TRACE_USR1(("ListContainer setAbsoluteIndex: _secondMetadata.size() = %d\n", _secondMetadata.size()));
   m_secondMetadata = _secondMetadata;
}


void ListContainer::setAbsoluteIndex(std::vector<uint16> _absoluteIndex)
{
   ETG_TRACE_USR1(("ListContainer setAbsoluteIndex: _absoluteIndex.size() = %d\n", _absoluteIndex.size()));
   m_absoluteIndex = _absoluteIndex;
}


void ListContainer::setIsLanguageSelected(std::vector<bool> status)
{
   ETG_TRACE_COMP(("ListContainer setIsLanguageSelected: status.size() = %d\n", status.size()));
   _isLanguageSelected = status;
   updateSelectedLanguageId();
}


void ListContainer::setFileType(std::vector<bosch::cm::di::HmiEmpListInterface::entFileType> fileType)
{
   ETG_TRACE_COMP(("ListContainer setFileType \n"));
   _fileType = fileType;
}


int ListContainer::getFileType(int selectedRow)
{
   int fileType = 0;
   ETG_TRACE_COMP(("ListContainer getFileType \n"));
   for (int index = 0; index < _fileType.size(); index++)
   {
      if (index == selectedRow)
      {
         fileType = _fileType[index];
         break;
      }
   }
   ETG_TRACE_USR4(("ListContainer getFileType fileType  %d  ", fileType));
   return fileType;
}


bool ListContainer::checkFileType(int index)
{
   ETG_TRACE_COMP(("ListContainer checkFileType \n"));
   bool bIsFolder = false;
   tU8 u8Filetype = _fileType[index];
   ETG_TRACE_USR4(("ListContainer::bCheckFolder index:%d, u8Filetype:%d", index, u8Filetype));
   bIsFolder = (u8Filetype == entFileType__entFileType_Folder) ? false : true;
   ETG_TRACE_USR4(("ListContainer::bCheckFolder bIsFolder :%d", bIsFolder));

   return bIsFolder;
}


void ListContainer::updateIsAllLanguageSelected(bool status)
{
   _isAllLanguageSelected = status;
   ETG_TRACE_USR1(("ListContainer updateIsAllLanguageSelected: _isAllLanguageSelected %d\n", _isAllLanguageSelected));
}


std::vector<std::string> ListContainer::getFirstTextOfList()
{
   ETG_TRACE_USR1(("ListContainer getFirstTextOfList \n"));
   return m_firstMetadata;
}


std::vector<std::string> ListContainer::getSecondTextOfList()
{
   ETG_TRACE_USR1(("ListContainer getSecondTextOfList \n"));
   return m_secondMetadata;
}


std::string ListContainer::getFolderName(int selectedItem)
{
   ETG_TRACE_USR1(("ListContainer getFirstTextOfList \n"));
   string iRootFolder = "/";
   for (int index = 0; index < m_firstMetadata.size(); ++index)
   {
      if (index == selectedItem)
      {
         iRootFolder = m_firstMetadata[index];
         break;
      }
   }
   ETG_TRACE_USR4(("ListContainer getFolderName selectedItem  %s  ", iRootFolder.c_str()));
   return iRootFolder;
}


std::vector<uint16> ListContainer::getAbsoluteIndex()
{
   ETG_TRACE_COMP(("ListContainer getAbsoluteIndex \n"));
   return m_absoluteIndex;
}


std::vector<bool> ListContainer::getIsLanguageSelected()
{
   ETG_TRACE_COMP(("ListContainer getIsLanguageSelected \n"));
   return _isLanguageSelected;
}


bool ListContainer::isAllLanguageSelected()
{
   ETG_TRACE_COMP(("ListContainer isAllLanguageSelected: _isAllLanguageSelected %d\n", _isAllLanguageSelected));
   return _isAllLanguageSelected;
}


uint16 ListContainer::getAbsoluteIndex(int selectedItem)
{
   uint16 absoluteIndex = 0;
   for (int index = 0; index < m_absoluteIndex.size(); ++index)
   {
      if (index == selectedItem)
      {
         absoluteIndex = m_absoluteIndex[index];
      }
   }
   ETG_TRACE_USR4(("ListContainer getAbsoluteIndex selectedItem  %d  absoluteIndex  %d ", selectedItem, absoluteIndex));
   return absoluteIndex;
}


void ListContainer::updateSelectedLanguageId()
{
   ETG_TRACE_COMP(("ListContainer::updateSelectedLanguageId"));
   _selectedLanguageId.clear();
   std::map<uint16, bool> selectedLanguageMap;

   std::vector<uint16>::iterator itr_1 = m_absoluteIndex.begin();
   std::vector<bool>::iterator itr_2 = _isLanguageSelected.begin();

   for (int index = 0; itr_1 != m_absoluteIndex.end(), itr_2 != _isLanguageSelected.end(); itr_1++, itr_2++, index++)
   {
      selectedLanguageMap[m_absoluteIndex[index]] = _isLanguageSelected[index];
   }

   std::map<uint16, bool>::iterator itr = selectedLanguageMap.begin();
   while (itr != selectedLanguageMap.end())
   {
      if (itr->second == 1)
      {
         _selectedLanguageId.push_back(itr->first);
      }
      itr ++;
   }
}


std::vector<uint16> ListContainer::getSelectedLanguageId()
{
   ETG_TRACE_COMP(("ListContainer::getSelectedLanguageId "));
   return _selectedLanguageId;
}


void ListContainer::updateFolderpath(std::string strPath)
{
   ETG_TRACE_USR4(("ListContainer::updateFolderpath"));
   _currentFolderPath = strPath;
}


std::string ListContainer::getFolderPath()
{
   ETG_TRACE_USR4(("ListContainer::getFolderPath "));
   return _currentFolderPath;
}


}// namespace Core
}// namespace App
