/**************************************************************************************
* @file         : HorizontalListManager..h
* @author       : RBEI/ECH2-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _HorizontalListManager_H_
#define _HorizontalListManager_H_

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "AppHmi_MediaStateMachine.h"
#include "Core/ListHandling/ListGuiResponseHandler/HorizontalListGuiResponseHandler.h"
#include "Core/ExternalMediaSourceHandler/ExternalMediaSourceHandler.h"
#include "Core/ListHandling/ExternalMediaListDBManager/ExternalMediaListDBManager.h"
#include "Core/PlayableContentInterfaceHandler/PlayableContentInterfaceHandler.h"
#include "Core/Utils/PlayableContentMap.h"
#include "AppHmi_MediaDatabinding.h"
#include "AppHmi_MediaStateMachine.h"
#include "AvdeccPluginConstant.h"
#include "Core/MediaDefines.h"
#include "Core/ExternalMediaDefines.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include <bits/stdc++.h>
#endif


#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
#include "utest/stubs/Apphmi_Media_Types_Common.h"
#endif

namespace App {
namespace Core {
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST

class ICategorySelectionUpdateObserver
{
   public:
      ICategorySelectionUpdateObserver() {}
      virtual ~ICategorySelectionUpdateObserver() {}
      virtual void onCategorySelection(EnumConst::entListType listType) = 0;
};


class HorizontalListManager
{
   public:
      HorizontalListManager(ExternalMediaSourceHandler* _mediaSourceHandler, EnumConst::entSourceType _SourceType, PlayableContentMap* _playableContentMapInstance);
      virtual ~HorizontalListManager();
#else
class HorizontalListManager
{
   public:
      HorizontalListManager();
      virtual ~HorizontalListManager();
#endif
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      void initialize();
      void clearInstance();
      void onListDataRequest(int startIndex);
      void registerObserver(ICategorySelectionUpdateObserver& imp);
      void deregisterObserver(ICategorySelectionUpdateObserver& imp);
      void updateCategorySelectionToObservors(EnumConst::entListType listType);
      void resetMembers();
      void onHorizontalListTabPressed(unsigned int selectMediaTab);//u
#endif

      EnumConst::entListType getListTypeOnTabPressed(unsigned int selectMediaTab);
      EnumConst::entListType getListTypeOnPageDirection();
      void onHorizontalListPageUpPageDownPressed(int pageDirection);
      void onListChangeUpdate(int startindex);//u

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#endif

   private:

      HorizontalListManager& operator= (const HorizontalListManager& obj);
      HorizontalListManager(const HorizontalListManager& obj);

      int  m_u8startindex;
      int  m_u8PageDirection;
      EnumConst::entSourceType m_currentSourceType;
      bool isValidListType(EnumConst::entListType listType);
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      HorizontalListGuiResponseHandler* _horizontalListGuiResponseHandler;
      ExternalMediaSourceHandler* _externalMediaSourceHandler;
      PlayableContentMap* _playableContentMap;
      ::std::vector< ICategorySelectionUpdateObserver* > m_categorySelectionUpdateObservor;

      EnumConst::entListType m_currentListType;
      bool _isFirstTimeBrowse;
      //uint8 m_mediaState;
#endif
};


} // namespace Core
} // namespace App


#endif  /* _HorizontalListManager_H_ */
