/**************************************************************************************
 * @file         : HorizontalListManager.cpp
 * @author       : RBEI/ECH2-INF4CV_MediaTeam
 * @addtogroup   : AppHmi_media
 * @brief        :
 * @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 * 		  			Initial Revision.
 **************************************************************************************/

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "hall_std_if.h"
#endif
#include "Core/ListHandling/HorizontalListManager/HorizontalListManager.h"
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "util/StrUtf8.h"
#include "Core/ListHandling/HorizontalListManager/HorizontalListManager.h"
#include "Core/ListHandling/ListGuiResponseHandler/HorizontalListGuiResponseHandler.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include "Core/SourceSwitch/MediaSourceHandling.h"
#include "CgiExtensions/ImageLoader.h"
#include "AvdeccPluginConstant.h"
#include "ProjectBaseTypes.h"
#include "Core/Utils/DbDownloadMap.h"
#include <iterator>
#include "MPlay_fi_types.h"
#include <vector>

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_MEDIA_HALL
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/HorizontalListManager.cpp.trc.h"
#endif

#endif

#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
#include "utest/stubs/Apphmi_Media_Types_Common.h"
#endif


namespace App {
namespace Core {

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
HorizontalListManager::HorizontalListManager(ExternalMediaSourceHandler* _mediaSourceHandler, EnumConst::entSourceType _SourceType, PlayableContentMap* _playableContentMapInstance)
   : _horizontalListGuiResponseHandler(NULL)
   , _externalMediaSourceHandler(NULL)
   , _playableContentMap(NULL)
{
   ETG_TRACE_USR1(("HorizontalListManager::HorizontalListManager constructor \n"));
   m_currentSourceType = _SourceType;
   _externalMediaSourceHandler = _mediaSourceHandler;
   _playableContentMap = _playableContentMapInstance;
   initialize();
}


HorizontalListManager::~HorizontalListManager()
{
   ETG_TRACE_USR1(("HorizontalListManager::HorizontalListManager Destructor \n"));
   m_categorySelectionUpdateObservor.clear();
   clearInstance();
}


void HorizontalListManager::initialize()
{
   ETG_TRACE_USR1(("HorizontalListManager::initialize\n"));
   m_u8PageDirection = 0;
   m_u8startindex = 0;
   //m_mediaState = MEDIA_STATE_INVALID;
   m_currentListType = EnumConst::entListType_Invalid;
   _isFirstTimeBrowse = 1;

   if (NULL == _horizontalListGuiResponseHandler)
   {
      _horizontalListGuiResponseHandler = new HorizontalListGuiResponseHandler(_playableContentMap, m_currentSourceType);
   }
}


void HorizontalListManager::clearInstance()
{
   ETG_TRACE_USR1(("HorizontalListManager::clearInstance\n"));
   if (NULL != _horizontalListGuiResponseHandler)
   {
      delete _horizontalListGuiResponseHandler;
      _horizontalListGuiResponseHandler = NULL;
   }
   _externalMediaSourceHandler = NULL;
}


void HorizontalListManager::resetMembers()
{
   ETG_TRACE_USR1(("HorizontalListManager resetMembers \n"));
   m_currentListType = EnumConst::entListType_Invalid;
   //m_mediaState = MEDIA_STATE_INVALID;
   m_currentSourceType = EnumConst::entSourceType_DEFAULT;
}


void HorizontalListManager::registerObserver(ICategorySelectionUpdateObserver& imp)
{
   ETG_TRACE_USR1(("HorizontalListManager::ICategorySelectionUpdateObserver entered"));
   ::std::vector< ICategorySelectionUpdateObserver* >::const_iterator itr = ::std::find(m_categorySelectionUpdateObservor.begin(), m_categorySelectionUpdateObservor.end(), (&imp));
   if (itr == m_categorySelectionUpdateObservor.end())
   {
      m_categorySelectionUpdateObservor.push_back((&imp));
   }
}


void HorizontalListManager::deregisterObserver(ICategorySelectionUpdateObserver& imp)
{
   ETG_TRACE_USR1(("HorizontalListManager::deregisterObserver entered"));
   ::std::vector< ICategorySelectionUpdateObserver* >::iterator itr = ::std::find(m_categorySelectionUpdateObservor.begin(), m_categorySelectionUpdateObservor.end(), (&imp));
   if (itr != m_categorySelectionUpdateObservor.end())
   {
      (void)m_categorySelectionUpdateObservor.erase(itr);
   }
}


void HorizontalListManager::updateCategorySelectionToObservors(EnumConst::entListType listType)
{
   ETG_TRACE_USR4(("HorizontalListManager::updateCategorySelectionToObservors iSourceAvailability %d", listType));

   for (::std::vector< ICategorySelectionUpdateObserver* >::const_iterator itr = m_categorySelectionUpdateObservor.begin(); (itr != m_categorySelectionUpdateObservor.end()); ++itr)
   {
      if (NULL != (*itr))
      {
         (*itr)->onCategorySelection(listType);
      }
   }
}


/* ***********************************************************
* Function 		: onListDataRequest
* Description 	: Updates the horizontal List data Based on the List Type
* Parameters 	:
* Return value	: void
* ***********************************************************/
void HorizontalListManager::onListDataRequest(int startIndex)
{
   ETG_TRACE_USR4(("HorizontalListManager::onListDataRequest startIndex  m_currentListType    %d       %d", startIndex, ETG_CENUM(entListType, m_currentListType)));
   ETG_TRACE_USR4(("HorizontalListManager::onListDataRequest m_currentSourceType    %d", ETG_CENUM(entSourceType, m_currentSourceType)));
   if (m_currentListType == EnumConst::entListType_Invalid)
   {
      if (_playableContentMap->getPlayableVideoContent(m_currentSourceType))
      {
         _horizontalListGuiResponseHandler->updateListType(EnumConst::entListType_Video);
         _horizontalListGuiResponseHandler->updateListStartIndex(EN_MEDIA_INDEX0);
         _horizontalListGuiResponseHandler->updateListContent();
         m_currentListType = EnumConst::entListType_Video;
         updateCategorySelectionToObservors(EnumConst::entListType_Video);
      }
      else if (_playableContentMap->getPlayableAudioContent(m_currentSourceType))
      {
         _horizontalListGuiResponseHandler->updateListType(EnumConst::entListType_Song);
         _horizontalListGuiResponseHandler->updateListStartIndex(EN_MEDIA_INDEX0);
         _horizontalListGuiResponseHandler->updateListContent();
         m_currentListType = EnumConst::entListType_Song;
         updateCategorySelectionToObservors(EnumConst::entListType_Song);
      }
   }
   else
   {
      _horizontalListGuiResponseHandler->updateListType(m_currentListType);
      _horizontalListGuiResponseHandler->updateListContent();
   }
}


#endif
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
HorizontalListManager::HorizontalListManager()
{
   m_u8startindex = 0;
   m_u8PageDirection = 0 ;
}


HorizontalListManager::~HorizontalListManager()
{
}


#endif

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
void HorizontalListManager::onHorizontalListTabPressed(unsigned int selectMediaTab)
{
   ETG_TRACE_USR4(("HorizontalListManager::onHorizontalListTabPressed selectMediaTab  %d", selectMediaTab));
   EnumConst::entListType listType = EnumConst::entListType_Invalid;
   listType = getListTypeOnTabPressed(selectMediaTab);
   ETG_TRACE_USR4(("HorizontalListManager::onHorizontalListTabPressed listType %d", listType));
   m_currentListType = listType;

   updateCategorySelectionToObservors(listType);

   _horizontalListGuiResponseHandler->updateListType(listType);
   _horizontalListGuiResponseHandler->updateListContent();
}


#endif

EnumConst::entListType HorizontalListManager::getListTypeOnTabPressed(unsigned int selectMediaTab)
{
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   ETG_TRACE_USR4(("HorizontalListManager::getListTypeOnTabPressed selectMediaTab  %d", selectMediaTab));
#endif
   EnumConst::entListType listType = EnumConst::entListType_Invalid;
   switch (selectMediaTab)
   {
      case EXT_TAB_TITLE:
      {
         listType = EnumConst::entListType_Song;
         break;
      }
      case EXT_TAB_ARTIST:
      {
         listType = EnumConst::entListType_Artist;
         break;
      }
      case EXT_TAB_ALBUM:
      {
         listType = EnumConst::entListType_Album;
         break;
      }
      case EXT_TAB_GENRE:
      {
         listType = EnumConst::entListType_Genre;
         break;
      }
      case EXT_TAB_FOLDER:
      {
         listType = EnumConst::entListType_Folder;
         break;
      }
      case EXT_TAB_PLAYLIST:
      {
         listType = EnumConst::entListType_Playlist;
         break;
      }
      case EXT_TAB_VIDEO:
      {
         listType = EnumConst::entListType_Video;
         break;
      }
      case EXT_TAB_VIDEO_LANGUAGE:
      {
         listType = EnumConst::entListType_Video_Languages;
         break;
      }
      default:
         break;
   }
   return listType;
}


void HorizontalListManager::onHorizontalListPageUpPageDownPressed(int pageDirection)
{
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   ETG_TRACE_USR4(("HorizontalListManager::onHorizontalListPageUpPageDownPressed pageDirection  %d", pageDirection));
#endif
   m_u8PageDirection = pageDirection;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   _isFirstTimeBrowse = 0;
   if (pageDirection == EN_MEDIATAB_PAGEUP)
   {
      COURIER_MESSAGE_NEW(ListChangeMsg)(LISTID_EXTERNAL_MEDIA_HOR, ListChangePageUp, 1)->Post();
   }
   else if (pageDirection == EN_MEDIATAB_DOWN)
   {
      COURIER_MESSAGE_NEW(ListChangeMsg)(LISTID_EXTERNAL_MEDIA_HOR, ListChangePageDown, 1)->Post();
   }
#endif
}


void HorizontalListManager::onListChangeUpdate(int startindex)
{
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   ETG_TRACE_USR4(("HorizontalListManager::onHorizontalListTabPressed startindex  %d", startindex));
#endif
   m_u8startindex = startindex;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   EnumConst::entListType listType = EnumConst::entListType_Invalid;

   ETG_TRACE_USR4(("HorizontalListManager::onListChangeUpdate m_u8startindex:%d", m_u8startindex));
   ETG_TRACE_USR4(("HorizontalListManager::onListChangeUpdate m_u8PageDirection %d", m_u8PageDirection));

   listType = getListTypeOnPageDirection();
   ETG_TRACE_USR4(("HorizontalListManager::onListChangeUpdate listType %d", listType));
   if (isValidListType(listType))
   {
      m_currentListType = listType;
      updateCategorySelectionToObservors(listType);
      _horizontalListGuiResponseHandler->updateListType(listType);
   }
   _horizontalListGuiResponseHandler->updateListStartIndex(m_u8startindex);
   _horizontalListGuiResponseHandler->updateListContent();
#endif
}


bool HorizontalListManager::isValidListType(EnumConst::entListType listType)
{
   bool isValidListType = false;
   switch (listType)
   {
      case EnumConst::entListType_Song:
      case EnumConst::entListType_Video:
      case EnumConst::entListType_Video_Languages:
      {
         isValidListType = true;
         break;
      }
      default:
         break;
   }
   ETG_TRACE_USR1(("HorizontalListManager::isValidListType: listType %d, isValidListType %d", ETG_CENUM(entListType, listType), isValidListType));
   return isValidListType;
}


EnumConst::entListType HorizontalListManager::getListTypeOnPageDirection()
{
   EnumConst::entListType listType = EnumConst::entListType_Invalid;
   if (m_u8PageDirection)//EN_MEDIATAB_DOWN
   {
      switch (m_u8startindex)
      {
         case EN_MEDIA_INDEX3://m_u8startindex == 3
         {
            listType = EnumConst::entListType_Artist;
            break;
         }
         case EN_MEDIA_INDEX6:
         {
            listType = EnumConst::entListType_Folder;
            break;
         }
         default:
            break;
      }
   }
   else//EN_MEDIATAB_PAGEUP
   {
      switch (m_u8startindex)
      {
         case EN_MEDIA_INDEX3:
         {
            listType = EnumConst::entListType_Genre;
            break;
         }
         case EN_MEDIA_INDEX0:
         {
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
            if (_playableContentMap->getPlayableVideoContent(m_currentSourceType))
            {
               listType = EnumConst::entListType_Video;
            }
            else if (_playableContentMap->getPlayableAudioContent(m_currentSourceType))
            {
               listType = EnumConst::entListType_Song;
            }
#endif
            break;
         }
         default:
            break;
      }
   }
   ETG_TRACE_USR1(("HorizontalListManager::getListTypeOnPageDirection:m_u8PageDirection %d, listType %d", m_u8PageDirection, ETG_CENUM(entListType, listType)));
   return listType;
}


}// namespace Core
}// namespace App
