/**************************************************************************************
* @file         : ExternalMediaStateHandler..h
* @author       : RBEI/ECH2-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _ExternalMediaListDBManager_H_
#define _ExternalMediaListDBManager_H_

#include "AppBase/ServiceAvailableIF.h"
#include "AppHmi_MediaStateMachine.h"
#include "AppHmi_MediaDatabinding.h"
#include "AvdeccPluginConstant.h"
#include "Core/ExternalMediaSourceHandler/ExternalMediaSourceHandler.h"
#include "bosch/cm/di/HmiEmpListInterfaceProxy.h"
#include "bosch/cm/di/HmiEmpListInterface.h"

using namespace ::bosch::cm::di::HmiEmpListInterface;

namespace App {
namespace Core {

class IExternalDBDownloadUpdateObservor
{
   public:
      IExternalDBDownloadUpdateObservor() {};
      virtual ~IExternalDBDownloadUpdateObservor() {};
      virtual void onExternalDBDownloadUpdate(uint8 downloadState, EnumConst::entSourceType sourceType) = 0;
};


class ExternalMediaListDBManager
   : public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF
   , public ::bosch::cm::di::HmiEmpListInterface::Sig_DBStateCallbackIF
   , public ReqDBDownloadCallbackIF
   , public ::App::Core::ICamportUsbSourceAvailabilityObservor
{
   public:

      ExternalMediaListDBManager(ExternalMediaSourceHandler* obj);
      virtual ~ExternalMediaListDBManager();

      void registerExternalDBDownloadObservor(IExternalDBDownloadUpdateObservor& imp);
      void deregisterExternalDBDownloadObservor(IExternalDBDownloadUpdateObservor& imp);
      void onCamportUsbSourceAvailabilityUpdate(int iAvailability);
      void registerObservers();
      void removeObservors();
      void updateDBDownloadStatusToObservors(uint8 downloadState, EnumConst::entSourceType sourceType);
      void resetMembers();
      void setDBDownloadState(int dbState, EnumConst::entSourceType sourceType);

      //<!--Property registration-->
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      virtual void onSig_DBStateError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_DBStateError >& error) ;
      virtual void onSig_DBStateSignal(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_DBStateSignal >& signal);

      virtual void onReqDBDownloadError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqDBDownloadError >& error);
      virtual void onReqDBDownloadResponse(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqDBDownloadResponse >& response);

   private:
      static ExternalMediaListDBManager* _externalMediaListDBManagerinstance;
      ::boost::shared_ptr<HmiEmpListInterfaceProxy> _hmiEmpListInterfaceProxy;
      ::std::vector< IExternalDBDownloadUpdateObservor* > m_dbDownloadStatusUpdateObservor;
      ExternalMediaSourceHandler* _externalMediaSourceHandler;
};


} // namespace Core
} // namespace App


#endif  /* _ExternalMediaListDBManager */
