/**************************************************************************************
 * @file         : EMPListPlaybackHandler.cpp
 * @author       : RBEI/ECH2-INF4CV_MediaTeam
 * @addtogroup   : AppHmi_media
 * @brief        :
 * @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 * 		  			Initial Revision.
 **************************************************************************************/

#include "hall_std_if.h"
#include "Core/ListHandling/EMPListPlaybackHandler/EMPListPlaybackHandler.h"
#include "Core/ApplicationSwitchClientHandler/ApplicationSwitchClientHandler.h"
#include "Core/PluginClientHandlerAppl/CamportUSBPluginClientHandler.h"
#include "Core/PluginClientHandlerAppl/RouterPluginClientHandler.h"
#include "Core/ExternalMediaSourceHandler/ExternalMediaSourceHandler.h"
#include "Core/PluginClientHandlerAppl/IPluginClientAppl.h"
#include "Core/PluginClientHandlerAppl/PluginClientFactory.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::EMPListPlaybackHandler::
#include "trcGenProj/Header/EMPListPlaybackHandler.cpp.trc.h"
#endif

using namespace ::bosch::cm::di::HmiEmpListInterface;

namespace App {
namespace Core {

EMPListPlaybackHandler::EMPListPlaybackHandler(VerticalListManager* _obj, EnumConst::entSourceType currentSourceType, ExternalMediaSourceHandler* _mediaSourceHandler)
{
   ETG_TRACE_USR1(("EMPListPlaybackHandler constructor \n"));
   StartupSync::getInstance().registerPropertyRegistrationIF(this, "HmiEmpListInterfacePort");
   _verticalListManager = _obj;
   m_currentSourceType = currentSourceType;
   _requestedListType = EnumConst::entListType_Invalid;
   _requestedAbsoluteIndex = 0;
   _isSourceChangeRequested = false;
   _externalMediaSourceHandler = _mediaSourceHandler;
   _folderPath = " ";
   _fileType = entFileType__entFileType_unknown;
}


EMPListPlaybackHandler::~EMPListPlaybackHandler()
{
   ETG_TRACE_USR1(("EMPListPlaybackHandler Destructor \n"));
   m_currentSourceType = EnumConst::entSourceType_DEFAULT;
   _requestedListType = EnumConst::entListType_Invalid;
   _requestedAbsoluteIndex = 0;
   _isSourceChangeRequested = false;
   clearInstance();
}


void EMPListPlaybackHandler::clearInstance()
{
   ETG_TRACE_USR1(("EMPListPlaybackHandler clearInstance \n"));
}


void EMPListPlaybackHandler::resetMembers()
{
   ETG_TRACE_USR1(("EMPListPlaybackHandler resetMembers \n"));
   _requestedListType = EnumConst::entListType_Invalid;
   _requestedAbsoluteIndex = 0;
   _isSourceChangeRequested = false;
}


void EMPListPlaybackHandler::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("EMPListPlaybackHandler::registerProperties"));
}


void EMPListPlaybackHandler::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("EMPListPlaybackHandler::deregisterProperties"));
}


void EMPListPlaybackHandler::onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("EMPListPlaybackHandler::onUnavailable"));
}


void EMPListPlaybackHandler::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("EMPListPlaybackHandler::onAvailable"));
}


void EMPListPlaybackHandler::onSourceAllocationUpdate()
{
   ETG_TRACE_USR1(("EMPListPlaybackHandler:: onSourceAllocationUpdate _isSourceChangeRequested %d", _isSourceChangeRequested));
   if (_isSourceChangeRequested == true)
   {
      updateRequestedListItemInfo();
      _isSourceChangeRequested = false;
   }
}


void EMPListPlaybackHandler::playItemRequest(EnumConst::entListType listType, uint16 absoluteIndex, bool isSameSource, std::string folderPath, int fileType)
{
   ETG_TRACE_USR4(("EMPListPlaybackHandler::playItemRequest absoluteIndex  %d  listType   %d isSameSource %d", absoluteIndex, ETG_CENUM(entListType, listType), isSameSource));
   _requestedListType  = listType;
   _requestedAbsoluteIndex = absoluteIndex;
   _fileType = fileType;
   if (listType == EnumConst::entListType_Folder)
   {
      _folderPath = folderPath;
   }

   if (isSameSource)
   {
      updateRequestedListItemInfo();
   }
   else
   {
      _isSourceChangeRequested = true;
   }
}


void EMPListPlaybackHandler::updateRequestedListItemInfo()
{
   uint8 u8ActiveRegion = ApplicationSwitchClientHandler::poGetInstance()->getActiveRegion();
   ETG_TRACE_USR4(("EMPListPlaybackHandler::updateRequestedListItemInfo u8ActiveRegion  %d", u8ActiveRegion));
   bosch::cm::di::HmiEmpListInterface::entListType  currentListType = static_cast <bosch::cm::di::HmiEmpListInterface::entListType>(_requestedListType);
   int iCurrentCabinSrcId = _externalMediaSourceHandler->getCabinSrcID(m_currentSourceType);
   ETG_TRACE_USR4(("EMPListPlaybackHandler::updateRequestedListItemInfo iCurrentCabinSrcId  %d", iCurrentCabinSrcId));

   IPluginClientAppl* l_iPluginClientAppl = PluginClientFactory::getPluginClient(iCurrentCabinSrcId);

   if (l_iPluginClientAppl != NULL)
   {
      l_iPluginClientAppl->updateCurrentPlayingListType(_requestedListType, _requestedAbsoluteIndex);
      l_iPluginClientAppl->onPlaySelectedListItem(_requestedListType, _requestedAbsoluteIndex, _folderPath, _fileType);
   }
}


}// namespace Core
}// namespace App
