/**************************************************************************************
* @file         : MockEMPListInterfaceHandler..h
* @author       : RBEI/ECH2-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _MockEMPListInterfaceHandler_H_
#define _MockEMPListInterfaceHandler_H_

#include "AppHmi_MediaStateMachine.h"
#include "AppHmi_MediaDatabinding.h"
#include "Core/ExternalMediaDefines.h"
#include "AvdeccPluginConstant.h"
#include "Core/ListHandling/EMPListInterfaceHandler/IEMPListHandler.h"
//#include "Core/ListHandling/VerticalListManager/VerticalListManager.h"
#include <bits/stdc++.h>
#include <vector>
#include "bosch/cm/di/HmiEmpListInterfaceProxy.h"

#include "Core/ExternalMediaClientHandler/Interface/HmiEmpListInterface.h"


class StartupSync;

namespace App {
namespace Core {

class ListContainer;
class ListInfoDatabaseHandler;
class VerticalListManager;
//class HmiEmpListInterface;

class MockEMPListInterfaceHandler
   : public CreateMediaPlayerIndexedListCallbackIF
   , public RequestMediaPlayerIndexedListSliceCallbackIF
   , public CreateMediaPlayerIndexedFolderListCallbackIF
   , public RequestMediaPlayerIndexedFolderListSliceCallbackIF
   , public SetMediaVideoLanguagesListCallbackIF
   , public IEmpListSizeObserver
   , public IEmpListContainerObserver
   , public IEMPListHandler
{
   public:

      MockEMPListInterfaceHandler(VerticalListManager* _obj, ListContainer* _container, ListInfoDatabaseHandler* _listInfoDBHandler);
      virtual ~MockEMPListInterfaceHandler();

      void createListRequest(EnumConst::entListType listType,  uint16 absoluteIndex1, uint16 absoluteIndex2);
      void sliceListRequest(EnumConst::entListType listType, uint16 startIndex, uint16 windowSize, uint16 absoluteIndex1, uint16 absoluteIndex2);

      void createListRequest(EnumConst::entListType listType, std::string folderPath);
      void sliceListRequest(uint16 startIndex, uint16 windowSize, std::string folderPath);

      void updateSelectedLanguageList();
      void onListSizeUpdate(ListSizeStruct strListSize);
      void onListContainerUpdate(std::vector<ListContainerStruct> strListContainer);
      void registerObservors();
      void deregisterObservors();

      virtual void onCreateMediaPlayerListError();
      virtual void onCreateMediaPlayerListResult();

      virtual void onRequestMediaPlayerListSliceError();
      virtual void onRequestMediaPlayerListSliceResult(std::vector<ListContainerStruct> listStruct);

      void onCreateMediaPlayerFolderListError();
      void onCreateMediaPlayerFolderListResult();

      void onRequestMediaPlayerFolderListSliceError();
      void onRequestMediaPlayerFolderListSliceResult();

      virtual void onMediaVideoLanguagesListError();
      virtual void onMediaVideoLanguagesListResponse();

      bool onCourierMessage(const MockCreateListandSliceListResMsg& oMsg);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MEDIA_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(MockCreateListandSliceListResMsg)
      COURIER_MSG_MAP_END()

   private:
      ListContainer* _containerObj;
      ListInfoDatabaseHandler* _listInfoDBHandlerObj;
      VerticalListManager* _verticalListManagerObj;

      EnumConst::entListType m_requestedlistType;
      EnumConst::entSourceType m_currentSourceType;
      uint8 m_currentActiveRegion;
      uint32 _currentListSize;

      std::vector<ListContainerStruct> _listContainer;
      std::vector<uint16> absoluteIndex;
      void updateFirstTextToContainer(std::vector<ListContainerStruct> _listContainer);
      void updateSecondTextToContainer(std::vector<ListContainerStruct> _listContainer);
      void updateAbsoluteIndexToContainer(std::vector<ListContainerStruct> _listContainer);
      void updateLanguageSelectionStatusToContainer(std::vector<ListContainerStruct> _listContainer);
      void updateFileTypeToContainer(std::vector<ListContainerStruct> _listContainer);

      //  ::boost::shared_ptr<HmiEmpListInterfaceProxy> _hmiEmpListInterfaceProxy;
};


} // namespace Core
} // namespace App


#endif  /* _MockEMPListInterfaceHandler_H_ */
