/**************************************************************************************
* @file         : EMPListFactory.h
** @author       : ECV - media
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (C) 2016 Robert Bosch GmbH
*                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef EMPLISTFACTORY_H_
#define EMPLISTFACTORY_H_

#include "IEMPListHandler.h"
#include "Core/ListHandling/EMPListInterfaceHandler/MockInterface/MockEMPListInterfaceHandler.h"
#include "Core/ListHandling/EMPListInterfaceHandler/EMPListInterfaceHandler.h"

namespace App {
namespace Core {

class EMPListFactory
{
   public:
      EMPListFactory();
      ~EMPListFactory();
      IEMPListHandler* getEMPListInterfaceObject(bool isMockActive);
      void setInstanceForMockEMP(MockEMPListInterfaceHandler* _mockEMPListInterfaceHandlerObject);
      void setInstanceForEMP(EMPListInterfaceHandler* _empListInterfaceHandlerObject);

   private:
      EMPListInterfaceHandler* _empListInterfaceHandler;
      MockEMPListInterfaceHandler* _mockEMPListInterfaceHandler;
};


}
}


#endif /* BROWSEFACTORY_H_ */
