/**************************************************************************************
* @file         : EMPListFactory.cpp
* @author       : ECV - media
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (C) 2016 Robert Bosch GmbH
*                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include <hmibase/hall_std_if.h>
#include "EMPListFactory.h"

namespace App {
namespace Core {

EMPListFactory::EMPListFactory()
   : _empListInterfaceHandler(NULL)
   , _mockEMPListInterfaceHandler(NULL)
{
}


EMPListFactory::~EMPListFactory()
{
}


/**
 *  EMPListFactory::getEMPListInterfaceObject - Function to return the IEMPListHandler pointer based on the availability of mock
 *  @param [in] listId
 *  @return IEMPListHandler
 */
IEMPListHandler* EMPListFactory::getEMPListInterfaceObject(bool isMockActive)
{
   IEMPListHandler* empListHandler = 0;

   if (isMockActive)
   {
      empListHandler = _mockEMPListInterfaceHandler;
   }
   else
   {
      empListHandler = _empListInterfaceHandler;
   }

   assert(empListHandler != NULL);
   return empListHandler;
}


void EMPListFactory::setInstanceForMockEMP(MockEMPListInterfaceHandler* _mockEMPListInterfaceHandlerObject)
{
   _mockEMPListInterfaceHandler = _mockEMPListInterfaceHandlerObject;
}


void EMPListFactory::setInstanceForEMP(EMPListInterfaceHandler* _empListInterfaceHandlerObject)
{
   _empListInterfaceHandler = _empListInterfaceHandlerObject;
}


}
}
