/**************************************************************************************
* @file         : BrowseFactory.h
** @author       : ECH5 - media
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (C) 2016 Robert Bosch GmbH
*                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef BROWSEFACTORY_H_
#define BROWSEFACTORY_H_

#include "IEMPBrowse.h"
#include "Core/ExternalMediaDefines.h"
#include "CategoryBrowse.h"
#include "FolderBrowse.h"
#include "bosch/cm/di/HmiEmpListInterfaceProxy.h"

using namespace ::bosch::cm::di::HmiEmpListInterface;

namespace App {
namespace Core {

class BrowseFactory
{
   public:
      BrowseFactory();
      ~BrowseFactory();
      IEMPBrowse* getBrowseObject(EnumConst::entListType listType, bosch::cm::di::HmiEmpListInterface::entFileType fileType);
      void setInstanceForCategoryBrowse(CategoryBrowse* _categoryBrowseObject);
      void setInstanceForFolderBrowse(FolderBrowse* _folderBrowseObject);

   private:
      CategoryBrowse* _categoryBrowse;
      FolderBrowse* _folderBrowse;
};


}
}


#endif /* BROWSEFACTORY_H_ */
