/**************************************************************************************
* @file         : BrowseFactory.cpp
* @author       : ECH5 - media
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (C) 2016 Robert Bosch GmbH
*                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include <hmibase/hall_std_if.h>
#include "BrowseFactory.h"

namespace App {
namespace Core {

BrowseFactory::BrowseFactory()
   : _categoryBrowse(NULL)
   , _folderBrowse(NULL)
{
}


BrowseFactory::~BrowseFactory()
{
}


/**
 *  BrowseFactory::getBrowseObject - Function to return the IEMPBrowse pointer based on the list type
 *  @param [in] listType
 *  @return IEMPBrowse
 */
IEMPBrowse* BrowseFactory::getBrowseObject(EnumConst::entListType listType, bosch::cm::di::HmiEmpListInterface::entFileType fileType)
{
   IEMPBrowse* browseHandler = NULL;
   switch (listType)
   {
      case EnumConst::entListType_Folder:
         (fileType == entFileType__entFileType_Folder) ? (browseHandler = _folderBrowse) : (browseHandler = _categoryBrowse);
         break;
      default:
         browseHandler = _categoryBrowse;
         break;
   }

   assert(browseHandler != NULL);
   return browseHandler;
}


void BrowseFactory::setInstanceForCategoryBrowse(CategoryBrowse* _categoryBrowseObject)
{
   _categoryBrowse = _categoryBrowseObject;
}


void BrowseFactory::setInstanceForFolderBrowse(FolderBrowse* _folderBrowseObject)
{
   _folderBrowse = _folderBrowseObject;
}


}
}
