/**************************************************************************************
* @file         : KDSHandler.h
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef _KDS_HANDLER_H_
#define _KDS_HANDLER_H_

#include "AppHmi_MediaTypes.h"
#include "AppHmi_MediaStateMachine.h"
#include "AppHmi_MediaMessages.h"
#include <ilm_client.h>
#include <ilm_control.h>

namespace App {
namespace Core {

class KDSHandler
{
   public:
      virtual ~KDSHandler();
      KDSHandler();
      void readUsbCamportKdsValue();
      bool getUsbCamportKdsValue();
      uint8 getRegionID();
      void readKdsForRegion();
      int getHdmiKDSValue();
      void readHdmiKDSValue();
      int getHubKDSValue();
      void readHubKDSValue();
      void readAuxKdsValue();

   private:
      uint8 m_UsbCamportKdsValue;
      uint8 _regionType;
      uint8 _HDMIKdsValue;
      uint8 _getHubConfig;
};


}//end of Core
}//end of App


#endif // _KDS_HANDLER_H_
