/**************************************************************************************
* @file         : ExternalMediaStateHandler..h
* @author       : RBEI/ECH2-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _ExternalMediaStateHandler_H_
#define _ExternalMediaStateHandler_H_

#include "AppBase/ServiceAvailableIF.h"
#include "AppHmi_MediaStateMachine.h"
#include "AppHmi_MediaDatabinding.h"
#include "Core/ExternalMediaSourceHandler/ExternalMediaSourceHandler.h"
#include "Core/SourceSwitch/MediaSourceHandling.h"
#include <bits/stdc++.h>

namespace App {
namespace Core {

class ExternalMediaStateHandler
   : public ::App::Core::ICamportUsbSourceAvailabilityObservor
{
   public:
      ExternalMediaStateHandler();
      virtual ~ExternalMediaStateHandler();
      static ExternalMediaStateHandler& getInstance();

      std::map <int, int> m_ExternalSourceAvailabilityMap;
      void onCamportUsbSourceAvailabilityUpdate(int iAvailability);
};


} // namespace Core
} // namespace App


#endif  /* _ExternalMediaSourceHandler_H_ */
