/**************************************************************************************
* @file         : ExternalMediaSourceHandler..h
* @author       : RBEI/ECH2-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _ExternalMediaSourceHandler_H_
#define _ExternalMediaSourceHandler_H_

#include <asf/core/Types.h>
#include <map>
#include <iterator>

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "AppBase/ServiceAvailableIF.h"
#include "AppHmi_MediaStateMachine.h"
#include "AppHmi_MediaDatabinding.h"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeProxy.h"
#include <bits/stdc++.h>
#include <vector>
#include "Core/ExternalMediaDefines.h"

#define MASTERAUDIOSERVICE_INTERFACE ::bosch::cm::ai::hmi::masteraudioservice

using namespace Courier;
#else
#include "utest/stubs/Apphmi_Media_Types_Common.h"
#endif

namespace App {
namespace Core {

//forward declartion
class ICamportUsbSourceAvailabilityObservor;
class ICamportUsbSourceAllocationObservor;
class IhdmiSourceAvailabilityObservor;
class IRouterSourceAllocationObservor;
class IRouterSourceAvailabilityObservor;
class IHdmiSourceAllocationObservor;

class ExternalMediaSourceHandler
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   : public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF
   , public MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceListCallbackIF
#endif
{
   public:
      ExternalMediaSourceHandler();
      virtual ~ExternalMediaSourceHandler();
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      //<!--Property registration-->
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      // ServiceAvailableIF implementation
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      virtual void onActiveSourceListError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& proxy,
                                           const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceListError >& error);

      virtual void onActiveSourceListUpdate(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& proxy,
                                            const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceListUpdate >& signal);

      void addCamportUsbSourceAllocObservor(ICamportUsbSourceAllocationObservor& imp);
      void removeCamportUsbSourceAllocObservor(ICamportUsbSourceAllocationObservor& imp);
      void addCamportUsbSourceAvailabilityObservor(ICamportUsbSourceAvailabilityObservor& imp);
      void removeCamportUsbSourceAvailabilityObservor(ICamportUsbSourceAvailabilityObservor& imp);
      void addHdmiSourceAvailabilityInfoObservor(IhdmiSourceAvailabilityObservor& imp);
      void removeHdmiSourceAvailabilityInfoObservor(IhdmiSourceAvailabilityObservor& imp);
      void addRouterSourceAllocationInfoObservor(IRouterSourceAllocationObservor& imp);
      void removeRouterSourceAllocationInfoObservor(IRouterSourceAllocationObservor& imp);
      void addRouterSourceAvailabilityInfoObservor(IRouterSourceAvailabilityObservor& imp);
      void removeRouterSourceAvailabilityInfoObservor(IRouterSourceAvailabilityObservor& imp);
      void addHdmiSourceAllocInfoObservor(IHdmiSourceAllocationObservor& imp);
      void removeHdmiSourceAllocInfoObservor(IHdmiSourceAllocationObservor& imp);

      void updateCamportUsbSourceAvailabilityObservors(int iSourceAvailability);
      void updateCamportUsbSourceAllocObservors(int iSourceId, int iSinkId, int connectionState);
      void updateRouterSourceAllocObservors(int iSourceId, int iSinkId, int connectionState);
      void updateHdmiSourceAllocObservors(int iSrcId, int iSinkId, int connectionState);
      int getCurrentExternalSourceAvailability(int iExternalSrcId);
      int getPreviousAudioStateOfExternalSource(int iSrcId, int iSinkId);
      //int getSinkId();
      //int getConnectionStateofExternalSource();
      void updateExternalSourceStateToObservers(int iSrcId, int iSinkId, int iConnectionState);
      bool isCamportUsbSourceAvailableInActiveSourceList(int iSrcId);
      void updateHDMISourceAvailabilityObservors(int srcId, int hdmiAvailable);
      int getCurrentActiveExternalSource();
      bool isCamportUsbSourceAvailableInPrevSourceList(int sinkId);
      bool isRouterSourceAvailableInPrevSourceList(int sinkId);
      bool isCamportHDMISourceAvailableInPrevSourceList(int sinkId);
      void checkExternalSourceDisconnected();
      bool getCurrentHdmiActiveState();
      void updateRouterUsbConnectionState(int usbConnected);
      int getCabinSrcID(EnumConst::entSourceType sourceType);
      void updateCamportSourceConnectionState(int srcId, int connectionState);
      uint8 getCabinSrcPlaybackState();
      void setCabinSrcPlaybackState(uint8 cabinPlaybackState);
      int getCabinSrc();
      void setCabinSrc(int cabinSrc);
      bool isMic1AvailableInPrevSourceList(int sinkId);
      bool isMediaSrcAvailableInPreviousSrcList(int sinkId);
#endif
      bool isExternalMediaSource(int srcid);
      bool isCurrentSrcExternalUSB(int iSrcId);
      bool isCurrentSrcHdmi(int iSrcId);
      void updateActiveExternalSourceInfoToMap(int iSrcId, int iSinkId, int iConnectionState);
      bool isCamportHDMISourceAvailableInCabinSink(int iSrcId, int sinkId);
      bool isCamportUsbSourceAvailableInCabinSink(int sinkId);
      bool isRouterSourceAvailableInCabinSink(int sinkId);
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      bool onCourierMessage(const ExternalCamportVideoSourceAvailabilityMsg& oMsg);
      bool onCourierMessage(const ExternalCamportAudioSourceAvailabilityMsg& oMsg);
      bool onCourierMessage(const ExternalHDMISourceAvailabilityMsg& oMsg);
      bool onCourierMessage(const SourceAllocationMsg& oMsg);
      bool onCourierMessage(const ExternalRouterSourceAvailabilityMsg& oMsg);

      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ExternalCamportVideoSourceAvailabilityMsg)
      ON_COURIER_MESSAGE(ExternalCamportAudioSourceAvailabilityMsg)
      ON_COURIER_MESSAGE(ExternalHDMISourceAvailabilityMsg)
      ON_COURIER_MESSAGE(SourceAllocationMsg)
      ON_COURIER_MESSAGE(ExternalRouterSourceAvailabilityMsg)
      COURIER_MSG_MAP_END()
#endif
   private:
      std::multimap <int, stActiveSourceInfo> m_activeSourceInfo;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy > _audioSourceChangeProxy;
      ::std::vector< ICamportUsbSourceAvailabilityObservor* > m_camportUsbSourceAvailObservor;
      ::std::vector< ICamportUsbSourceAllocationObservor* > m_camportUsbSourceAllocationObservor;
      std::vector<IhdmiSourceAvailabilityObservor* > m_hdmiSourceAvailObservor;
      std::vector<IRouterSourceAllocationObservor* > m_routerSourceAllocObservor;
      std::vector<IRouterSourceAvailabilityObservor* > m_routerSourceAvailObservor;
      std::vector<IHdmiSourceAllocationObservor* > m_hdmiSourceAllocObservor;
      std::vector<MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::sourceData> m_prevAudioSrcList;
      int m_disconnectedSource;
      bool m_bCabinHdmiActiveState;
      int _cabinSource;
      uint8 _cabinSourcePlaybackState;
#endif
};


class ICamportUsbSourceAvailabilityObservor
{
   public:
      ICamportUsbSourceAvailabilityObservor() {}
      virtual ~ICamportUsbSourceAvailabilityObservor() {}
      virtual void onCamportUsbSourceAvailabilityUpdate(int iAvailability) = 0;
};


class ICamportUsbSourceAllocationObservor
{
   public:
      ICamportUsbSourceAllocationObservor() {}
      virtual ~ICamportUsbSourceAllocationObservor() {}
      virtual void onCamportUsbSourceAllocationUpdate(int iSourceId, int iSinkId, int ConnectionState) = 0;
};


class IRouterSourceAllocationObservor
{
   public:
      IRouterSourceAllocationObservor() {}
      virtual ~IRouterSourceAllocationObservor() {}
      virtual void onRouterSourceAllocationUpdate(int iSourceId, int iSinkId, int ConnectionState) = 0;
};


class IhdmiSourceAvailabilityObservor
{
   public:
      IhdmiSourceAvailabilityObservor() {}
      virtual ~IhdmiSourceAvailabilityObservor() {}
      virtual void onHdmiSourceAvailabilityUpdate(int srcId, int hdmiAvailable) = 0;
};


class IRouterSourceAvailabilityObservor
{
   public:
      IRouterSourceAvailabilityObservor() {}
      virtual ~IRouterSourceAvailabilityObservor() {}
      virtual void onRouterSourceAvailabilityUpdate(int iAvailability) = 0;
};


class IHdmiSourceAllocationObservor
{
   public:
      IHdmiSourceAllocationObservor() {}
      virtual ~IHdmiSourceAllocationObservor() {}
      virtual void onHdmiSourceAllocationUpdate(int iSourceId, int iSinkId, int ConnectionState) = 0;
};


} // namespace Core
} // namespace App


#endif  /* _ExternalMediaSourceHandler_H_ */
