/**************************************************************************************
* @file         : IExternalMediaSourceActivationHandler.h
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef IEXTERNALMEDIASOURCEACTIVATIONHANDLER_h
#define IEXTERNALMEDIASOURCEACTIVATIONHANDLER_h

namespace App {
namespace Core {
class PlayableContentMap;

class IExternalMediaSourceActivationHandler
{
   public:

      IExternalMediaSourceActivationHandler();
      virtual ~IExternalMediaSourceActivationHandler();
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      virtual void requestSourceActivation(int) = 0;
      virtual void reset() = 0;
      virtual void toggleSource() = 0;
      virtual void setPlayableMapInstance(PlayableContentMap* _playableContentMapObject) = 0;
      virtual int getSourceIDFromActiveContent() = 0;


#endif
      virtual int getActiveSourceContentType() = 0;
      virtual void updateActivePlayableContentType() = 0;
};


} // namespace Core
} // namespace App
#endif
