/**************************************************************************************
 * @file         : CamportRouterSourceActivationHandler.cpp
 * @author       : RBEI/ECH2-INF4CV_MediaTeam
 * @addtogroup   : AppHmi_media
 * @brief        :
 * @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 * 		  			Initial Revision.
 **************************************************************************************/

#include "CamportRouterSourceActivationHandler.h"

#include "hall_std_if.h"
#include "Core/ExternalMediaSourceActivation/IExternalMediaSourceActivationHandler.h"
#include <string>
#include <stdint.h>
#include <map>
#include "Core/SourceSwitch/MediaSourceHandling.h"
#include "Core/ApplicationSwitchClientHandler/ApplicationSwitchClientHandler.h"
#include "Core/ExternalMediaDefines.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include "App/datapool/MediaDataPoolConfig.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::CamportRouterSourceActivationHandler::
#include "trcGenProj/Header/CamportRouterSourceActivationHandler.cpp.trc.h"
#endif

namespace App {
namespace Core {

CamportRouterSourceActivationHandler::CamportRouterSourceActivationHandler()
// : _playableContentInterfaceHandler(NULL)
   : _playableContentMap(NULL)
{
   ETG_TRACE_USR1(("CamportRouterSourceActivationHandler::CamportRouterSourceActivationHandler constructor is called \n"));
   _activeContentType = EN_DEFAULT_FILE_CONTENT;

   initializeDeviceContentMap();
   setLastActiveSourceContentType(MediaDataPoolConfig::getInstance()->getLastActiveRouterUSBSource());
}


CamportRouterSourceActivationHandler::~CamportRouterSourceActivationHandler()
{
   ETG_TRACE_USR1(("CamportRouterSourceActivationHandler::CamportRouterSourceActivationHandler  Destructor is called \n"));
}


void CamportRouterSourceActivationHandler::initializeDeviceContentMap()
{
   ETG_TRACE_USR1(("CamportRouterSourceActivationHandler::initializeDeviceContentMap is called"));

   _deviceContentMap.insert(pair<int, int>(EN_VIDEO_FILE_CONTENT, SRC_CMR1_USB1_VIDEO));
   _deviceContentMap.insert(pair<int, int>(EN_AUDIO_FILE_CONTENT, SRC_CMR1_USB1_AUDIO));
   _deviceContentMap.insert(pair<int, int>(EN_DEFAULT_FILE_CONTENT, SRC_INVALID));
}


void CamportRouterSourceActivationHandler::requestSourceActivation(int regionId)
{
   int srcId;
   ETG_TRACE_USR4(("CamportRouterSourceActivationHandler::requestSourceActivation regionId %d \n", regionId));
   srcId = _deviceContentMap[_activeContentType];
   ETG_TRACE_USR4(("CamportRouterSourceActivationHandler::requestSourceActivation srcId %d \n", srcId));
   MediaDataPoolConfig::getInstance()->setLastActiveRouterUSBSource(srcId);
   if (srcId != SRC_INVALID)
   {
      MediaSourceHandling::getInstance().requestSourceActivation(srcId, -1, regionId);
   }
}


void CamportRouterSourceActivationHandler::reset()
{
   ETG_TRACE_USR1(("CamportRouterSourceActivationHandler reset \n"));
   _activeContentType = EN_DEFAULT_FILE_CONTENT;
}


void CamportRouterSourceActivationHandler::updateActivePlayableContentType()
{
   ETG_TRACE_USR1(("CamportRouterSourceActivationHandler::updateActivePlayableContentType \n"));
   bool l_bPlayableAudioContent = false;
   bool l_bPlayableVideoContent = false;
   ETG_TRACE_USR4(("CamportRouterSourceActivationHandler::updateActivePlayableContentType _activeContentType  %d", _activeContentType));
   l_bPlayableAudioContent = _playableContentMap->getPlayableAudioContent(EnumConst::entSourceType_CMR);
   l_bPlayableVideoContent = _playableContentMap->getPlayableVideoContent(EnumConst::entSourceType_CMR);
   ETG_TRACE_USR4(("CamportRouterSourceActivationHandler::updateActivePlayableContentType l_bPlayableVideoContent , l_bPlayableAudioContent : %d, %d", l_bPlayableVideoContent, l_bPlayableAudioContent));
   if (_activeContentType == EN_DEFAULT_FILE_CONTENT)
   {
      if (l_bPlayableVideoContent == true)
      {
         _activeContentType = EN_VIDEO_FILE_CONTENT;
      }
      else
      {
         _activeContentType = EN_AUDIO_FILE_CONTENT;
      }
   }
}


void CamportRouterSourceActivationHandler::toggleSource()
{
   ETG_TRACE_USR1(("CamportRouterSourceActivationHandler toggleSource \n"));
   ETG_TRACE_USR4(("CamportRouterSourceActivationHandler::toggleSource _activeContentType  %d", _activeContentType));

   if (_activeContentType == EN_AUDIO_FILE_CONTENT)
   {
      _activeContentType = EN_VIDEO_FILE_CONTENT;
   }
   else if (_activeContentType == EN_VIDEO_FILE_CONTENT)
   {
      _activeContentType = EN_AUDIO_FILE_CONTENT;
   }
}


int CamportRouterSourceActivationHandler::getActiveSourceContentType()
{
   ETG_TRACE_USR4(("CamportRouterSourceActivationHandler getActiveSourceContentType _activeContentType %d\n", _activeContentType));
   return _activeContentType;
}


void CamportRouterSourceActivationHandler::setPlayableMapInstance(PlayableContentMap* _playableContentMapObject)
{
   ETG_TRACE_USR1(("CamportRouterSourceActivationHandler::setPlayableMapInstance is entered \n"));
   _playableContentMap = _playableContentMapObject;
}


void CamportRouterSourceActivationHandler::setLastActiveSourceContentType(int sourceId)
{
   if ((sourceId == SRC_CMR1_USB1_VIDEO) || (sourceId == SRC_CMR1_USB1_AUDIO))
   {
      if (sourceId == SRC_CMR1_USB1_VIDEO)
      {
         _activeContentType = 	EN_VIDEO_FILE_CONTENT;
      }
      else if (sourceId == SRC_CMR1_USB1_AUDIO)
      {
         _activeContentType = 	EN_AUDIO_FILE_CONTENT;
      }
   }
   else
   {
      _activeContentType = EN_DEFAULT_FILE_CONTENT;
   }
   ETG_TRACE_USR4(("CamportRouterSourceActivationHandler::setLastActiveSourceContentType sourceId ,_activeContentType %d ,%d\n", sourceId, _activeContentType));
}


int  CamportRouterSourceActivationHandler::getSourceIDFromActiveContent()
{
   int srcID = SRC_INVALID;
   if (_activeContentType == EN_AUDIO_FILE_CONTENT)
   {
      srcID = SRC_CMR1_USB1_AUDIO;
   }
   else if (_activeContentType ==	EN_VIDEO_FILE_CONTENT)
   {
      srcID = SRC_CMR1_USB1_VIDEO;
   }
   else
   {
      srcID = SRC_INVALID;
   }
   return srcID;
   ETG_TRACE_USR4(("CamportRouterSourceActivationHandler::getSourceIDFromActiveContent sourceId ,_activeContentType %d ,%d\n", srcID, _activeContentType));
}


}// namespace Core
}// namespace App
