/**************************************************************************************
* @file         : ExternalMediaListManager..h
* @author       : RBEI/ECH2-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _ExternalMediaListManager_H_
#define _ExternalMediaListManager_H_

#include "AppBase/ServiceAvailableIF.h"
#include "bosch/cm/di/HmiEmpListInterfaceProxy.h"
#include "Core/ListHandling/ExternalMediaListDBManager/ExternalMediaListDBManager.h"
#include "Core/ExternalMediaSourceHandler/ExternalMediaSourceHandler.h"
#include <bits/stdc++.h>
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"
#include "Core/ListHandling/HorizontalListManager/HorizontalListManager.h"
#include "Core/PlayableContentInterfaceHandler/PlayableContentInterfaceHandler.h"
#include "Core/ListHandling/VerticalListManager/VerticalListManager.h"

using namespace Courier;


namespace App {
namespace Core {

class ExternalMediaSourceHandler;
class ListGuiRequestHandler;

class ExternalMediaListManager
   : public ListImplementation
   , public ::App::Core::ICamportUsbSourceAllocationObservor
   , public ::App::Core::ICamportUsbSourceAvailabilityObservor
   , public ::App::Core::IRouterSourceAllocationObservor
   , public ::App::Core::IRouterSourceAvailabilityObservor
{
   public:

      ExternalMediaListManager(ExternalMediaSourceHandler* _externalMediaSourceHandlerInstance
                               , PlayableContentMap* _playableContentMapInstance);
      virtual ~ExternalMediaListManager();
      virtual tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);

      void initializeInstances();
      void onRouterSourceAllocationUpdate(int iSourceId, int iSinkId, int ConnectionState);
      void onCamportUsbSourceAllocationUpdate(int iSourceId, int iSinkId, int connectionState);
      void onCamportUsbSourceAvailabilityUpdate(int iCamportVideoAvailability);
      void onRouterSourceAvailabilityUpdate(int usbAvailabilityInRouter);
      void setExternalSourceAndPlayableContentInterfaceHandlerCmp();
      void setExternalSourceAndPlayableContentInterfaceHandlerCmr();
      int getCurrentActiveSourceType();

      bool onCourierMessage(const ListChangedUpdMsg& oMsg);
      bool onCourierMessage(const ExternalMediaListItemPressUpdMsg& oMsg);
      bool onCourierMessage(const ExternalMediaTabBtnPressUpdMsg& oMsg);
      bool onCourierMessage(const ExternalMediaTabListPageUpReqMsg& oMsg);
      bool onCourierMessage(const ExternalMediaTabListPageDownReqMsg& oMsg);
      bool onCourierMessage(const ExternalMediaBackButtonPressUpdMsg& oMsg);
      bool onCourierMessage(const ExternalBrowseScreenExitUpdMsg& oMsg);
      bool onCourierMessage(const ExternalMediaAllButtonPressUpdMsg& oMsg);

      bool onCourierMessage(const CurrentMediaStateUpdMsg& msg);
      bool onCourierMessage(const MockCreateListandSliceListResMsg& msg);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MEDIA_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ListChangedUpdMsg)
      ON_COURIER_MESSAGE(ExternalMediaListItemPressUpdMsg)
      ON_COURIER_MESSAGE(ExternalMediaTabBtnPressUpdMsg)
      ON_COURIER_MESSAGE(ExternalMediaTabListPageUpReqMsg)
      ON_COURIER_MESSAGE(ExternalMediaTabListPageDownReqMsg)
      ON_COURIER_MESSAGE(ExternalMediaBackButtonPressUpdMsg)
      ON_COURIER_MESSAGE(ExternalBrowseScreenExitUpdMsg)
      ON_COURIER_MESSAGE(ExternalMediaAllButtonPressUpdMsg)
      ON_COURIER_MESSAGE(CurrentMediaStateUpdMsg)
      ON_COURIER_MESSAGE(MockCreateListandSliceListResMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS();

   private:

      ExternalMediaListManager& operator= (const ExternalMediaListManager& obj);
      ExternalMediaListManager(const ExternalMediaListManager& obj);

      HorizontalListManager* _horizontalListManagercmp;
      VerticalListManager* _verticalListManagercmp;
      ListGuiRequestHandler* _listGuiRequestHandlercmp;
      HorizontalListManager* _horizontalListManagercmr;
      VerticalListManager* _verticalListManagercmr;
      ListGuiRequestHandler* _listGuiRequestHandlercmr;
      ExternalMediaSourceHandler* _externalMediaSourceHandler;
      PlayableContentMap* _playableContentMap;
      EnumConst::entSourceType _currentSourceType;
};


} // namespace Core
} // namespace App


#endif  /* _ExternalMediaListManager_H_ */
