/**************************************************************************************
* @file         : <ExternalMediaDefines.h>
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : <AppHmi_media>
* @brief        :
* @copyright    : (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef EXTERNALMEDIADEFINES_H_
#define EXTERNALMEDIADEFINES_H_
#include "AvdeccPluginConstant.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"

#define WINDOW_SIZE 20
#define ROUTER_SHUFFLE_REPEAT_MODE 40
#define RESTORATION_TIMER_SECONDS 60

enum enListSession
{
   LIST_SESSION_IDLE = 0,
   LIST_SESSION_GUI_REQUEST_RECEIVED,
   LIST_SESSION_CREATE_REQUEST,
   LIST_SESSION_SLICE_REQUEST,
   LIST_SESSION_GUI_RESPONSE_SENT,
   LIST_SESSION_GUI_RESPONSE_ACK,
   LIST_SESSION_UNKNOWN
};


enum enCANMediaPlayStates
{
   CAN_PAUSE_VALUE = 1,
   CAN_PLAY_VALUE = 2
};


enum enCANSourceIdSignal
{
   CAN_SOURCE_ID_USB1 = 3,
   CAN_SOURCE_ID_USB2 = 4,
   CAN_SOURCE_ID_BLUETOOTH1 = 5,
   CAN_SOURCE_ID_IPOD = 19
};


enum enCabinCANSourceIdSignal
{
   CAN_CABIN_SOURCE_ID_USB1 = 3,
   CAN_CABIN_SOURCE_ID_USB2 = 4,
   CAN_CABIN_SOURCE_ID_BLUETOOTH = 5,
   CAN_CABIN_SOURCE_ID_IPOD = 19,
   CAN_CABIN_SOURCE_ID_ROUTER_USB = 30,
   CAN_CABIN_SOURCE_ID_CAMPORT_USB = 32,
   CAN_CABIN_SOURCE_ID_CAMPORT_HDMI_1 = 36,
   CAN_CABIN_SOURCE_ID_CAMPORT_HDMI_2 = 37,
   CAN_CABIN_SOURCE_ID_CAMPORT_HDMI_3 = 38
};


enum enCabinCANTrackIndexSignal
{
   CAN_CabinTrackCommand_Pause = 0,
   CAN_CabinTrackCommand_Play = 2,
   CAN_CabinTrackCommand_Next = 3,
   CAN_CabinTrackCommand_Previous = 4,
   CAN_CabinTrackCommand_FastForward = 5,
   CAN_CabinTrackCommand_FastBackward = 6,
   CAN_CabinTrackCommand_RepeatOff = 9,
   CAN_CabinTrackCommand_RepeatTrack = 10,
   CAN_CabinTrackCommand_RepeatAll = 11,
   CAN_CabinTrackCommand_RandomAll = 13,
   CAN_CabinTrackCommand_NotAvailable = 15
};


enum enCANShuffleStates
{
   CAN_SHUFFLE_OFF = 0,
   CAN_SHUFFLE_ON = 2
};


enum enCANRepeatShuffleStates
{
   CAN_REPEAT_OFF = 0,
   CAN_REPEAT_TRACK = 1,
   CAN_REPEAT_LIST = 3
};


enum enMediaLongDataInfo
{
   MEDIA_CURRENT_FILENAME = 2,
   MEDIA_CURRENT_TITLE = 3,
   MEDIA_CURRENT_FOLDER = 4,
   MEDIA_CURRENT_ARTIST = 5,
   MEDIA_CURRENT_ALBUM = 6
};


enum enListState
{
   EN_LIST_STATE_UNKNOWN = 0,
   EN_LIST_STATE_ACTIVE,
   EN_LIST_STATE_PROCESSING,
   EN_LIST_STATE_INACTIVE
};


enum enDBDownloadPopUpState
{
   EN_DBDOWNLOAD_POPUP_DEFAULT = 0,
   EN_DBDOWNLOAD_POPUP_VISIBLE,
   EN_DBDOWNLOAD_POPUP_CLOSED,
   EN_DBDOWNLOAD_POPUP_CANCELLED
};


enum enListResponseState
{
   EN_LIST_RESPONSE_STATE_CREATELIST = 0,
   EN_LIST_RESPONSE_STATE_SLICELIST
};


enum enDeviceContentInfo
{
   EN_AUDIO_FILE_CONTENT = 0,
   EN_VIDEO_FILE_CONTENT,
   EN_LANGUAGE_CONTENT,
   EN_DEFAULT_FILE_CONTENT
};


enum enGlassActiveStatusInfo
{
   EN_GLASS_DEACTIVE = 0,
   EN_GLASS_ACTIVE,
};


enum enListSliceRequestType
{
   EN_FULL_LIST_SLICE_REQ_TYPE = 0,
   EN_WINDOW_SLICE_REQ_TYPE
};


enum  enExternalMediaConnectionState
{
   EN_EXTERNAL_MEDIA_DISCONNECTED = 0,
   EN_EXTERNAL_MEDIA_CONNECTED,
   EN_EXTERNAL_MEDIA_UNSUPPORTED
};


enum  enUsbSourceAvailableStatus
{
   EN_USB_NOT_AVAIL = 0,
   EN_USB_AVAIL,
   EN_USB_AVAIL_ERROR,
   EN_USB_AVAIL_SNA
};


enum  enBluetoothSourceAvailableStatus
{
   EN_BLUETOOTH_NOT_AVAIL = 0,
   EN_BLUETOOTH_AVAIL,
   EN_BLUETOOTH_AVAIL_ERROR,
   EN_BLUETOOTH_AVAIL_SNA
};


enum enMediaControlActionErrorValues
{
   EN_SNA = 15,
   EN_NOT_AVAILABLE = 0xFFFF
};


enum  enUsbSourceConnectionStatus
{
   EN_USB_NOT_PRESENT = 0,
   EN_USB_PRESENT,
   EN_USB_PRESENT_ERROR,
   EN_USB_PRESENT_SNA
};


enum enExternalMediaCRCState
{
   EN_CRC_MISMATCH = 0,
   EN_CRC_MATCH
};


enum enExternalMediaTab
{
   EXT_TAB_VIDEO = 0,
   EXT_TAB_VIDEO_LANGUAGE,
   EXT_TAB_TITLE,
   EXT_TAB_ARTIST,
   EXT_TAB_ALBUM,
   EXT_TAB_GENRE,
   EXT_TAB_FOLDER,
   EXT_TAB_PLAYLIST,
   EXT_TAB_AUDIOBOOK,
   EXT_TAB_PODCAST
};


enum enExternalControlIndex
{
   EN_ROUTER_STREAM3_TRACK_NAME = 2,
   EN_ROUTER_STREAM3_ARTIST_NAME = 5,
   EN_CAMPORT_TRACK = 9,
   EN_ROUTER_STREAM1_VIDEO_NAME = 20,
   EN_ROUTER_STREAM1_VIDEO_EPISODE = 23,
   EN_CAMPORT_VIDNAME = 27,
   EN_CAMPORT_VIDEPISODE = 28,
};


enum enExternalMediaControlId
{
   SIGNAL_SOURCE_CHANGE = 40,
   MEDIA_SIGNAL_SOURCE_CHANGE
};


struct queueListInfo
{
   EnumConst::entListType listType;
   uint32 startIndex;
   uint32 windowSize;
};


struct stListInfo
{
   int startIndex;
   enListState listState;
   int totalListSize;
   std::vector<uint16> absoluteIndex;
};


struct stActiveSourceInfo
{
   int srcId;
   int connectionState;
};


struct HdmiSrcStatusInfo
{
   int status;
   uint8 systemCategory;
};


struct externalSourceTypeInfo
{
   EnumConst::entSourceType srcType;
   int deviceType;
   int srcId;
};


struct HdmiSourceInfo
{
   HdmiSourceInfo(): sourceAvailability(0), isSourceActive(false) {}
   HdmiSourceInfo(int Availability, int SourceActive):
      sourceAvailability(Availability), isSourceActive(SourceActive) {}
   int sourceAvailability;
   bool isSourceActive;
};


struct stPluginData
{
   stPluginData(): titleName(" "), artistName(" ") {}

   stPluginData(std::string title, std::string artist): titleName(title), artistName(artist) {}
   std::string titleName;
   std::string artistName;
};


struct stListConfiguration
{
   stListConfiguration(): isAllButtonAvailable(false), nextListType(EnumConst::entListType_Invalid), numTextInListItem(0), isPrevButtonAvailable(false),
      prevListType(EnumConst::entListType_Invalid), tabGroup(0), icon(0), allListType(EnumConst::entListType_Invalid), contentType(EN_DEFAULT_FILE_CONTENT), sliceRequestType(EN_WINDOW_SLICE_REQ_TYPE) {}

   stListConfiguration(bool bAllButton, EnumConst::entListType nxtListType, int textNumber, bool bPrevButton, EnumConst::entListType previousListType, int tab, uint32 iconType, EnumConst::entListType allButtonList, int requestedContentType, enListSliceRequestType listSize)
      : isAllButtonAvailable(bAllButton), nextListType(nxtListType), numTextInListItem(textNumber), isPrevButtonAvailable(bPrevButton),
        prevListType(previousListType), tabGroup(tab), icon(iconType), allListType(allButtonList), contentType(requestedContentType), sliceRequestType(listSize) {}
   bool isAllButtonAvailable;
   EnumConst::entListType nextListType;
   int numTextInListItem;
   bool isPrevButtonAvailable;
   EnumConst::entListType prevListType;
   int tabGroup;
   uint32 icon;
   EnumConst::entListType allListType;
   int contentType;
   enListSliceRequestType sliceRequestType;
};


struct ListStruct
{
   std::string Text1;
   std::string Text2;
   uint16 AbsoluteIndex;
};


struct VerticalListSize
{
   float ListheightWithoutButtons;
   float ListheightWithBackButton;
   float ListheightWithBackAndAllButton;
   float BackButtonSize;
   float DefaultBackButtonSize;
   float AllAlbumAndTitleButtonSize;
   float DefaultAllAlbumAndTitleButtonSize;
   float ListWidth;
   float ScrollBarWidth;
};


struct HorizontalListTabInfo
{
   const char* ListTemplate;
   EnumConst::entListType currentListType;
};


struct StreamType
{
   StreamType(): PlayAction(0), RepeatMode(0), SeekTo(0) {}
   StreamType(int Play, int Repeat, int  Seek):
      PlayAction(Play), RepeatMode(Repeat), SeekTo(Seek) {}
   int PlayAction;
   int RepeatMode;
   int  SeekTo;
};


struct DbDownloadState
{
   DbDownloadState(): DownloadState(0), DownloadRequested(false) {}
   DbDownloadState(int DbState, bool DbRequested):
      DownloadState(DbState), DownloadRequested(DbRequested) {}
   int DownloadState;
   bool DownloadRequested;
};


struct PlayableContentAvailability
{
   PlayableContentAvailability(): AudioAvailability(false), VideoAvailability(false), CRCControlStatus(0) {}
   PlayableContentAvailability(bool AudioContentAvailability, bool VideoContentAvailability, int ControlValue):
      AudioAvailability(AudioContentAvailability), VideoAvailability(VideoContentAvailability), CRCControlStatus(ControlValue) {}
   bool AudioAvailability;
   bool VideoAvailability;
   int CRCControlStatus;
};


#endif /* EXTERNALMEDIADEFINES_H_ */
