/**************************************************************************************
* @file         : ExternalMediaClientHandler.h
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
*04.09.18 Rev. 0.1 Ruchi/Suman (RBEI/ECH2)
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _ExternalMediaClientHandler_H_
#define _ExternalMediaClientHandler_H_

#include "mplay_MediaPlayer_FI.h"
#include "mplay_MediaPlayer_FIProxy.h"
#include "DataModel/HMIModelComponent.h"
#include "DataModel/HMIModelListImplementation.h"
#include "DataModel/HMIModelTabImplementation.h"
#include "AppHmi_MediaTypes.h"
#include "AppHmi_MediaStateMachine.h"
#include "AppHmi_MediaDatabinding.h"
#include "Core/Utils/clMetaData.h"
#include "Core/Utils/ListUtilityDatabase.h"
#include "Core/SourceSwitch/MediaSourceHandling.h"
#include "AppBase/ServiceAvailableIF.h"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeProxy.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesProxy.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include "bosch/cm/di/HmiEmpListInterfaceProxy.h"
#include "ProjectPluginMsgs.h"
#include "Core/MediaDefines.h"
#include "Core/ExternalMediaDefines.h"
#include <bits/stdc++.h>
#include "Core/ExternalMediaClientHandler/ExternalMediaClientInterfaceHandler.h"
#include "Core/ExternalMediaSourceHandler/ExternalMediaSourceHandler.h"
#include "Core/ListHandling/ExternalMediaListDBManager/ExternalMediaListDBManager.h"
#include "AvdeccPluginConstant.h"
#include"Core/ExternalMediaSourceActivation/IExternalMediaSourceActivationHandler.h"
#include "Core/ExternalMediaSourceActivation/ExternalMediaSourceActivationFactory.h"
#include "Core/ExternalMediaPlaybackHandler/ExternalMediaPlaybackHandler.h"
#include "Core/PluginClientHandlerAppl/CamportUSBPluginClientHandler.h"
#include "Core/PluginClientHandlerAppl/RouterPluginClientHandler.h"
#include "Core/PluginClientHandlerAppl/IPluginClientAppl.h"
#include "Core/PluginClientHandlerAppl/PluginClientFactory.h"
#include "Core/Utils/PlayableContentMap.h"
#include "Core/Utils/SystemInfoMap.h"
#include "Core/HmiStateHandler/HmiStateHandler.h"
#include "spm_core_fi_typesConst.h"

using namespace ::bosch::cm::di::HmiEmpListInterface;
using namespace ::spm_core_fi_types;

namespace App {
namespace Core {

/* class ExternalMediaClientHandler
 */

class ExternalMediaClientHandler
   : public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF
   , public ::bosch::cm::di::HmiEmpListInterface::Sig_AlbumArtStateCallbackIF
   , public IExternalMediaClientInterfaceHandlerComponent
   , public ::App::Core::IhdmiSourceAvailabilityObservor
   , public ::App::Core::ICamportUsbSourceAvailabilityObservor
   , public ::App::Core::ICamportUsbSourceAllocationObservor
   , public ::App::Core::IExternalDBDownloadUpdateObservor
   , public ::App::Core::IRouterSourceAllocationObservor
   , public IRouterSourceAvailabilityObservor
   , public IHdmiSourceAllocationObservor
   , public IHmiStateStatusObserver
   , public ::bosch::cm::di::HmiEmpListInterface::Sig_CurrentTrackInfoCallbackIF
   , public ::bosch::cm::di::HmiEmpListInterface::ReqDBDownloadCallbackIF
{
   public:

      ExternalMediaClientHandler();
      //<!--Databinding items-->
      // DataBindingItem<PlaybackActionDataBindingSource> m_MediaPlayBackData;
      virtual ~ExternalMediaClientHandler();
      //<!--Courier Messages-->
      virtual bool onCourierMessage(const SelectDeviceSourceMsg& oMsg);

      bool onCourierMessage(const DBDownloadStateUpdateMsg& oMsg);
      virtual bool onCourierMessage(const PluginUpdateRespMsg& oMsg);
      void initialiseHdmiSrcAvailabilityMap();
      void initialiseHdmiDeviceNumberMap();

      //<!--Property registration-->
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      virtual void onSig_AlbumArtStateError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_AlbumArtStateError >& error);
      virtual void onSig_AlbumArtStateSignal(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_AlbumArtStateSignal >& signal);

      virtual void onSig_CurrentTrackInfoError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_CurrentTrackInfoError >& error);
      virtual void onSig_CurrentTrackInfoSignal(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_CurrentTrackInfoSignal >& signal);

      virtual void onReqDBDownloadError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqDBDownloadError >& error);
      virtual void onReqDBDownloadResponse(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqDBDownloadResponse >& response);

      // ServiceAvailableIF implementation
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      void onHdmiSourceAvailabilityUpdate(int srcId, int hdmiavailable);
      void onCamportUsbSourceAvailabilityUpdate(int iCamportVideoAvailability);
      void onRouterSourceAllocationUpdate(int iSourceId, int iSinkId, int ConnectionState);
      void onHdmiSourceAllocationUpdate(int iSourceId, int iSinkId, int ConnectionState);
      bool getCurrentRouterActiveState();
      void vRequestExternalMediaSourcePlayBack(int32 iAudioConnStatus, int srcID);
      void vRequestStateTransitionForExternalSource(bool bActiveState);
      void setExternalMediaSourceHandlerInstance(ExternalMediaSourceHandler* _externalMediaSourceHandlerInstance);
      void setExternalMediaListDBManagerInstance(ExternalMediaListDBManager* _externalMediaListDBManagerInstance);
      void setPlayableContentMapInstance(PlayableContentMap* _playableContentMapInstance);
      void setPlayableContentInterfaceHandler(PlayableContentInterfaceHandler* _playableContentInterfaceHandler);
      void setHmiStateHandlerInstance(HmiStateHandler* _hmiStateHandlerInstance);

      void setSystemInfoMapInstance(SystemInfoMap* _systemInfoMapInstance);
      void onRouterSourceAvailabilityUpdate(int usbAvailabilityInRouter);

      void onExternalDBDownloadUpdate(uint8 downloadState, EnumConst::entSourceType sourceType);
      void clearInstance();
      void onCamportUsbSourceAllocationUpdate(int iSourceId, int iSinkId, int connectionState);

      void onSourceSelection(EnumConst::entSourceType sourceType);
      void handleSourceSelectionOnDownloadComplete(int deviceType, bool isSourceActive);
      bool onCourierBindingItemChange_USBCameraPortPlaybackActionItem(const Courier::Request& request);
      bool onCourierBindingItemChange_USBRouterPlaybackActionItem(const Courier::Request& request);
      int getHdmiSrcId(uint8 deviceType);
      int getHdmiSourceAvailability(int srcId);
      bool getHdmiSourceActiveState(int srcId);
      void setHdmiActiveState(int srcId, bool activeHdmiState);
      void resetMetadataForExternalUsbSources(int srcId);
      void onHmiStateUpdate(uint8 currentHmiState);
      void setHmiOffWithActiveMediaSrcState(bool state);
      uint8 getExternalSrcPlaybackState(int sourceId);
      void onHdmiSourceSelection(uint8 deviceType);
      void onCabinTrackCommandChangeRequest(uint8 cabinMediaTrackCommandValue);
      void onExternalSrcActivationWhenInCockpit(EnumConst::entSourceType srcType, int deviceType);
      void onExternalSrcActivationWhenInCockpit(int deviceType);
      bool onCourierMessage(const CurrentMediaStateUpdMsg& msg);
      std::string replaceInTranslationTextID(std::string, std::string, std::string); //Function to update the dynamic string in the text id
      //////////////////////////////////////////////
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MEDIA_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(SelectDeviceSourceMsg)
      ON_COURIER_MESSAGE(CurrentMediaStateUpdMsg)
      ON_COURIER_MESSAGE(Courier::UpdateModelMsg)
      ON_COURIER_MESSAGE(DBDownloadStateUpdateMsg)
      ON_COURIER_MESSAGE(PluginUpdateRespMsg)

      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_MAP_DELEGATE_END();

      COURIER_BINDING_MAP_BEGIN()
      COURIER_BINDING_ITEM_CHANGE(USBCameraPortPlaybackActionItem)
      COURIER_BINDING_ITEM_CHANGE(USBRouterPlaybackActionItem)
      COURIER_BINDING_MAP_END()

   private:

      ExternalMediaClientHandler& operator= (const ExternalMediaClientHandler& obj);
      ExternalMediaClientHandler(const ExternalMediaClientHandler& obj);

      DataBindingItem<USBCameraPortPlaybackActionDataBindingSource> m_USBCameraPortMediaPlayBackData;
      DataBindingItem<USBRouterPlaybackActionDataBindingSource> m_USBRouterMediaPlayBackData;

      ExternalMediaSourceHandler* _externalMediaSourceHandler;
      ExternalMediaListDBManager* _externalMediaListDBManager;
      PlayableContentInterfaceHandler* _playableContentInterfaceHandler;
      PlayableContentMap* _playableContentMap;
      IPluginClientAppl* _camportUSBPluginClientHandler;
      IPluginClientAppl* _routerPluginClientHandler;
      IExternalMediaSourceActivationHandler* _camportUSBSourceActivationHandler;
      IExternalMediaSourceActivationHandler* _camportRouterSourceActivationHandler;
      HmiStateHandler* _hmiStateHandler;
      SystemInfoMap* _systemInfoMap;
      int m_isRouterUsbConnected;
      bool m_isRouterSourceActive;
      int _currentMediaState;

      tU8 m_u8ActiveRegion;
      uint16 u16ControlVal;

      bool m_u8CabinAReg;
      bool m_u8CabinBReg;
      bool m_u8CabinARegHDMI;
      bool m_u8CabinBRegHDMI;
      std::string name;
      bool _isHmiOffWithActiveMediaSrc;

      bool m_bGlassAvailable;
      uint16 m_currentTrackIndex;
      bool m_isCamportUSBSourceActive;
      int m_iUsbCamportAvailable;
      bool _canSigFFReqOngoing;
      bool _canSigFRReqOngoing;
      std::map < int, HdmiSourceInfo> _hdmiSrcAvailability;
      std::map < uint8, int> _hdmiDevTypSrcMap;
      ::boost::shared_ptr<HmiEmpListInterfaceProxy> _hmiEmpListInterfaceProxy;
      DataBindingItem<ExternalDeviceConnectedDataBindingSource> m_DbDownloadSuccessfulData;
      DataBindingItem<DBInPreparationDataBindingSource> m_DbInPreparationData;
      DataBindingItem<DBDownloadErrorDataBindingSource> m_DbDownloadFailureData;

      void handleDBDownloadStateUpdate(EnumConst::entSourceType sourceType);

      DECLARE_CLASS_LOGGER();
};


} // namespace Core
} // namespace App


#endif
