/**************************************************************************************
* @file         : BTCLIENTHANDLER.cpp
* @author       : ECG - vta5kor
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "hall_std_if.h"
#include "BTClientHandler.h"
#include "Core/MediaSourceListHandler/MediaSourceListHandler.h"

#define UTFUTIL_S_IMPORT_INTERFACE_GENERIC
#include "utf_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS         TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL             TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX          "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX               App::Core::BTClientHandler::

#include "trcGenProj/Header/BTClientHandler.cpp.trc.h"
#endif

using namespace ::App::Core;

namespace App {
namespace Core {

BTClientHandler* BTClientHandler::_btClientHandler = NULL;

/**
 * @Destructor
 */
BTClientHandler::~BTClientHandler()
{
   ETG_TRACE_USR1(("BTClientHandler::BTClientHandler destructor"));
   _btClientHandler = NULL;
   _btSettingProxy.reset();
   ETG_I_UNREGISTER_FILE();
}


/**
* @Constructor
*/
BTClientHandler::BTClientHandler()
   : _btSettingProxy(::MOST_BTSet_FI::MOST_BTSet_FIProxy::createProxy("mediaBTSetFiPort", *this))

{
   StartupSync::getInstance().registerPropertyRegistrationIF(this, _btSettingProxy->getPortName());
   _btClientHandler = this;
   m_isBluetoothOn = true;
   ETG_I_REGISTER_FILE();
}


/**
 * deregisterProperties - Trigger property deregistration to BT properties,  called from MediaHall class
 * @param[in] proxy
 * @parm[in] stateChange - state change service for corrosponding  proxy
 * @return void
 */
void BTClientHandler::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("BTClientHandler::deregisterProperties"));
}


void BTClientHandler::onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("BTClientHandler::onUnavailable"));

   if (_btSettingProxy && _btSettingProxy == proxy)
   {
      _btSettingProxy->sendDeviceListExtendedRelUpRegAll();
      _btSettingProxy->sendBluetoothOnOffRelUpRegAll();
   }
}


/**
 * registerProperties - Trigger property registration to BT properties,  called from MediaHall class
 * @param[in] proxy
 * @parm[in] stateChange - state change service for corrosponding  proxy
 * @return void
 */
void BTClientHandler::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("BTClientHandler::registerProperties"));
}


void BTClientHandler::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("BTClientHandler::onAvailable entered"));

   if (_btSettingProxy && _btSettingProxy == proxy)
   {
      _btSettingProxy->sendDeviceListExtendedUpReg(*this);
      _btSettingProxy->sendBluetoothOnOffUpReg(*this);
   }
}


/**
* onBluetoothOnOffStatus -
*
* @param[in] proxy
* @parm[in] status
* @return void
*/
void BTClientHandler::onBluetoothOnOffStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& /*proxy*/,
      const ::boost::shared_ptr< ::MOST_BTSet_FI::BluetoothOnOffStatus >& status)
{
   m_isBluetoothOn = status->getBBTOnOff();
   MediaSourceListHandler::getInstance().updateMediaSourceList(LIST_ID_MEDIA_SOURCE_LIST);
   ETG_TRACE_USR4(("BTClientHandler::onBluetoothOnOffStatus bluetooth on/off state: %d", m_isBluetoothOn));
}


bool BTClientHandler::isBluetoothSettingsOn()
{
   return m_isBluetoothOn;
}


/**
* onBluetoothOnOffError -
*
* @param[in] proxy
* @parm[in] status
* @return void
*/
void BTClientHandler::onBluetoothOnOffError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& /*proxy*/,
      const ::boost::shared_ptr< ::MOST_BTSet_FI::BluetoothOnOffError >& /*error*/)
{
   ETG_TRACE_COMP(("BTClientHandler::onBluetoothOnOffError called"));
}


/**
 * onDeviceListExtendedError - called if Device list  property is updated with error from BT
 *
 * @param[in] proxy
 * @parm[in] error
 * @return void
 */
void BTClientHandler::onDeviceListExtendedError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& /*proxy*/
      , const ::boost::shared_ptr< ::MOST_BTSet_FI::DeviceListExtendedError>& /*error*/)
{
   ETG_TRACE_COMP(("BTClientHandler::onDeviceListExtendedError"));
}


/**
 * onDeviceListExtendedStatus - received status update for Device list property
 *
 * @param[in] proxy
 * @parm[in] status
 * @return void
 */
void BTClientHandler::onDeviceListExtendedStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& /*proxy*/
      , const ::boost::shared_ptr< ::MOST_BTSet_FI::DeviceListExtendedStatus >& status)
{
   ETG_TRACE_COMP(("BTClientHandler::onDeviceListExtendedStatus called"));
   if (status->getU8NumPairedDevices() != 0)
   {
      ::most_BTSet_fi_types_Extended::T_BTSetDeviceListExtendedResult deviceList = status->getODeviceListExtendedResult();
      onDeviceListExtendedStatusResult(deviceList);
   }
   else
   {
      ETG_TRACE_USR1(("BTClientHandler::onDeviceListExtendedStatus No BT device is paired"));
   }
}


/**
 * onDeviceListExtendedStatusResult - called when devicelistextendedstatus  update for Device list property received.
 *
 * @param[in] deviceList
 * @return void
 */
void BTClientHandler::onDeviceListExtendedStatusResult(::most_BTSet_fi_types_Extended::T_BTSetDeviceListExtendedResult& deviceList)
{
   ETG_TRACE_COMP(("BTClientHandler::onDeviceListExtendedStatusResult"));
   ::most_BTSet_fi_types_Extended::T_BTSetDeviceListExtendedResult::iterator itr = deviceList.begin();
   btDeviceList = deviceList;

   for (; itr != deviceList.end(); ++itr)
   {
      ETG_TRACE_USR4(("BTClientHandler::onDeviceListExtendedStatusResult Connected BT Device name %s ", itr->getSDeviceName().c_str()));
      ETG_TRACE_USR4(("BTClientHandler::onDeviceListExtendedStatusResult Connected BT device Handle %d ", itr->getU8DeviceHandle()));
      ETG_TRACE_USR4(("BTClientHandler::onDeviceListExtendedStatusResult Connected Status = %d ",  itr->getBDeviceConnectedStatus()));
      ETG_TRACE_USR2(("BTClientHandler::onDeviceListExtendedStatusResult Connected BT device connected %d", itr->getODeviceProfileStatus().getBAVP()));

      /*if (itr->getBDeviceConnectedStatus() == true && itr->getODeviceProfileStatus().getBAVP() == true)
      {
      }
      else
      {
      }*/
   }
}


bool BTClientHandler::getConnectedDeviceAVPStatus(std::string deviceName)
{
   ETG_TRACE_USR4(("BTClientHandler::getConnectedDeviceAVPStatus devicename %s", deviceName.c_str()));

   btDeviceName = deviceName;

   ::most_BTSet_fi_types_Extended::T_BTSetDeviceListExtendedResult::iterator itr = btDeviceList.begin();
   for (; itr != btDeviceList.end(); itr++)
   {
      ETG_TRACE_USR4(("BTClientHandler::getConnectedDeviceAVPStatus BT Device Handle %d", itr->getU8DeviceHandle()));
      ETG_TRACE_USR4(("BTClientHandler::getConnectedDeviceAVPStatus BT Device Name %s", itr->getSDeviceName().c_str()));
      if (itr->getSDeviceName() == deviceName)
      {
         ETG_TRACE_USR2(("BTClientHandler::getConnectedDeviceAVPStatu BT Device Profile Status %d", itr->getODeviceProfileStatus().getBAVP()));
         return itr->getODeviceProfileStatus().getBAVP();
      }
   }
   //To fix coverity issue
   return false;
}


bool BTClientHandler::isAVPProfileActiveInConnectedBTDevice()
{
   bool isAVPProfileConnected = false;
   ::most_BTSet_fi_types_Extended::T_BTSetDeviceListExtendedResult::iterator itr = btDeviceList.begin();
   for (; itr != btDeviceList.end(); itr++)
   {
      ETG_TRACE_USR4(("BTClientHandler::getConnectedDeviceAVPStatus BT Device Handle %d", itr->getU8DeviceHandle()));
      ETG_TRACE_USR4(("BTClientHandler::getConnectedDeviceAVPStatus BT Device Name %s", itr->getSDeviceName().c_str()));
      ETG_TRACE_USR4(("BTClientHandler::getConnectedDeviceAVPStatu BT Device Profile Status %d", itr->getODeviceProfileStatus().getBAVP()));

      if (itr->getODeviceProfileStatus().getBAVP() == true && itr->getBDeviceConnectedStatus() == true)
      {
         isAVPProfileConnected = itr->getODeviceProfileStatus().getBAVP();
         break;
      }
   }
   //To fix coverity issue
   return isAVPProfileConnected;
}


bool BTClientHandler::getConnectedDeviceStatus(std::string deviceName)
{
   //sendDeviceListExtendedStatusRequest();
   ETG_TRACE_USR4(("BTClientHandler::getConnectedDeviceStatus device name %s", deviceName.c_str()));
   ::most_BTSet_fi_types_Extended::T_BTSetDeviceListExtendedResult::iterator itr = btDeviceList.begin();
   for (; itr != btDeviceList.end(); itr++)
   {
      ETG_TRACE_USR4(("BTClientHandler::getConnectedDeviceStatus BT Device Handle %d", itr->getU8DeviceHandle()));
      if (itr->getSDeviceName() == deviceName)
      {
         ETG_TRACE_USR2(("BTClientHandler::getConnectedDeviceStatus Connection Status %d", itr->getBDeviceConnectedStatus()));
         return itr->getBDeviceConnectedStatus();
      }
   }
   //To fix coverity issue
   return false;
}


bool BTClientHandler::isAnyBTDeviceConnected()
{
   //sendDeviceListExtendedStatusRequest();
   ::most_BTSet_fi_types_Extended::T_BTSetDeviceListExtendedResult::iterator itr = btDeviceList.begin();
   bool isDeviceConnected = false;
   for (; itr != btDeviceList.end(); itr++)
   {
      ETG_TRACE_USR4(("BTClientHandler::getConnectedDeviceStatus  Connection Status %d", itr->getBDeviceConnectedStatus()));
      if (itr->getBDeviceConnectedStatus() == true)
      {
         isDeviceConnected = itr->getBDeviceConnectedStatus();
         break;
      }
   }
   //To fix coverity issue
   return isDeviceConnected;
}


}//App
}//Core
