/**************************************************************************************
* @file         : MediaSourceHandling.h
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef ApplicationSwitchClient_h
#define ApplicationSwitchClient_h

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "AppHmi_MediaStateMachine.h"
#include "AppHmi_MediaMessages.h"
#include "AppBase/ServiceAvailableIF.h"
#include "AppHmi_MediaDatabinding.h"
#include "ApplicationSwitch.h"
#include "ApplicationSwitchProxy.h"
#include "Core/MediaDefines.h"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoServiceProxy.h"
#include "Core/ExternalMediaSourceHandler/ExternalMediaSourceHandler.h"
#include "AvdeccPluginConstant.h"

using namespace ::asf::core;
using namespace ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch;
using namespace ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService;
#else
#include "asf/core/Types.h"
#endif

namespace App {
namespace Core {


class ExternalMediaSourceHandler;
class ExternalMediaClientHandler;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
class ApplicationSwitchClientHandler :
   public ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public ActiveRegionIdCallbackIF
   , public Sig_ActivateContextCallbackIF
   , public RequestContextSwitchCallbackIF
   , public SendContextCallbackIF
   , public ToggleGadgetAudioSourceCallbackIF
   , public ToggleGadgetAudioSourceRequestCallbackIF
   , public ::App::Core::ICamportUsbSourceAvailabilityObservor


#else
class ApplicationSwitchClientHandler
#endif
{
   public:
      ApplicationSwitchClientHandler();
      virtual ~ApplicationSwitchClientHandler();
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST

      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(LayerSoundSettingsMsg)
      ON_COURIER_MESSAGE(MediaSceneMsg)
      ON_COURIER_MESSAGE(HomescreenToggle)
      ON_COURIER_MESSAGE(ButtonMainSrcActivate)
      ON_COURIER_MESSAGE(ActiveRenderedView)
      ON_COURIER_MESSAGE(ApplicationStateUpdMsg)

      COURIER_MSG_MAP_END()

      virtual bool onCourierMessage(const Courier::StartupMsg& oMsg);
      bool onCourierMessage(const ApplicationStateUpdMsg& msg);

      bool onCourierMessage(const ButtonMainSrcActivate& oMsg);
      bool onCourierMessage(const LayerSoundSettingsMsg& oMsg);
      bool onCourierMessage(const HomescreenToggle& msg);
      bool onCourierMessage(const MediaSceneMsg& oMsg);
      bool onCourierMessage(const ActiveRenderedView& msg);
      void reqContextSwitchSrcSelection();
      void reqContextSwitchSrcSelectionHome(uint8 activityID, uint8 appId);
      void sendStoreContextRequest(uint16 activityID);

      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);

      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      virtual void onActiveRegionIdError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy,
                                         const ::boost::shared_ptr< ActiveRegionIdError >& error);

      virtual void onActiveRegionIdUpdate(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy,
                                          const ::boost::shared_ptr< ActiveRegionIdUpdate >& update);

      virtual void onSig_ActivateContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextError >& error);
      virtual void onSig_ActivateContextSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextSignal >& signal);

      virtual void onRequestContextSwitchError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestContextSwitchError >& error);
      virtual void onRequestContextSwitchResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestContextSwitchResponse >& response);

      virtual void onSendContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< SendContextError >& error);
      virtual void onSendContextResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< SendContextResponse >& response);

      virtual void onToggleGadgetAudioSourceError(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/, const ::boost::shared_ptr< ToggleGadgetAudioSourceError >& /* error*/);
      virtual void onToggleGadgetAudioSourceResponse(const ::boost::shared_ptr< HmiInfoServiceProxy >& /* proxy*/, const ::boost::shared_ptr< ToggleGadgetAudioSourceResponse >& /*response*/);

      virtual void onToggleGadgetAudioSourceRequestError(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/, const ::boost::shared_ptr< ToggleGadgetAudioSourceRequestError >& /* error*/);
      virtual void onToggleGadgetAudioSourceRequestSignal(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< ToggleGadgetAudioSourceRequestSignal >& signal);

      uint8 getactivityID();
      uint8 SignalId;
      void activeMediaAudioAllocationRequest();
      void reqHomeScreenToggle();
      void MediacontextSignal(uint32 regionid, uint32 currentAppid, uint32 currentactivityid, uint32 targetappid, uint32 targetactivityid);

      uint16 getMediaActivityID(std::string viewid);
      void clearInstance();
      void onCamportUsbSourceAvailabilityUpdate(int iAvailability);
      void setExternalMediaSourceHandlerInstance(ExternalMediaSourceHandler* _externalMediaSourceHandlerInstance);
      void setExternalMediaClientHandlerInstance(ExternalMediaClientHandler* _externalMediaClientHandlerInst);
      void initialiseHdmiActivityIdToDevTypeMap();
#endif
      static ApplicationSwitchClientHandler* poGetInstance();
      bool IsMediaSourceRangeActivity(uint32 activityid);
      uint16 getActivityIdFromDeviceType(uint16 deviceType);
      const uint8 getActiveRegion();
      void setActiveRegion(int activeRegion);

   private:
      static ApplicationSwitchClientHandler* m_poSelfAppSwitchClient;
      uint8 m_u8activeRegion;
      int m_iUsbCamportAvailable;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      EnumConst::entSourceType _sourceType;

      ::boost::shared_ptr<ApplicationSwitchProxy> m_poApplicationSwitchProxy;
      ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::HmiInfoServiceProxy> _hmiInfoServiceProxyClient;
      ApplicationSwitchClientHandler& operator= (const ApplicationSwitchClientHandler& obj);
      ApplicationSwitchClientHandler(const ApplicationSwitchClientHandler& obj);
      ExternalMediaClientHandler* _externalMediaClientHandler;
      ExternalMediaSourceHandler* _externalMediaSourceHandler;
      std::string m_sCurrentViewName;
      std::map < uint32, int> _hdmiActivityIdToDevTypMap;
#endif
};


}
}


#endif
