/* ***************************************************************************************
* FILE:          CGIAppController.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppController.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef CGIAPPCONTROLLER_H
#define CGIAPPCONTROLLER_H

#include "Common/CGIAppController/CGIAppControllerProject.h"
#include "HMIAppCtrl/Stub/AppTaskArray.h"

#include "CgiExtensions/DataBindingItem.hpp"

#include "DataModel/DataModelSound.h"

#include "ApplicationSwitchConst.h"

#define APPLICATIONSWITCH_TYPES    ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch

using namespace ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch;
using namespace App::datamodel;

class CGIAppController : public CGIAppControllerProject
{
   courier_messages:
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MASTER_COURIER_PAYLOAD_CTRL_COMP)
      ON_COURIER_MESSAGE(HKStatusChangedUpdMsg)
      ON_COURIER_MESSAGE(ActivateApplicationReqMsg)
      ON_COURIER_MESSAGE(ActivateMasterApplicationReqMsg)
      ON_COURIER_MESSAGE(EvalSubSurfaceReqMsg)
      ON_COURIER_MESSAGE(ApplicationRenderedUpdMsg)
      ON_COURIER_MESSAGE(SubSurfaceVisibleMsg)
      ON_COURIER_MESSAGE(SurfaceStateChangedUpdMsg)

      COURIER_MSG_MAP_END_DELEGATE(CGIAppControllerProject)

   public:
      // use the 'using' statement to indicate that also the overloaded virtual methods from the base class should be taken under account
      using CGIAppControllerProject::onCourierMessage;

      CGIAppController(hmibase::services::hmiappctrl::ProxyHandler& proxyHandler) : CGIAppControllerProject(proxyHandler)
      {
         _lastAppId  = 0;
      }
      virtual ~CGIAppController()
      {
         _lastAppId  = 0;
      }

      virtual bool onCourierMessage(const HKStatusChangedUpdMsg& msg);
      virtual bool onCourierMessage(const ActivateApplicationReqMsg& msg);
      virtual bool onCourierMessage(const ActivateMasterApplicationReqMsg& msg);
      virtual bool onCourierMessage(const EvalSubSurfaceReqMsg& msg);
      virtual bool onCourierMessage(const ApplicationRenderedUpdMsg& msg);
      virtual bool onCourierMessage(const SubSurfaceVisibleMsg& msg);
      virtual bool onCourierMessage(const SurfaceStateChangedUpdMsg& msg);

      int getCurrentSinkId();

   private:
      bool isAppRunning(const AppTask* app);
      bool activateApp(const AppTask* app);
      void nextApp(hmibase::appid_t appId = 0);
      void hk_MapOutHandling();
      bool isValidKey(uint32 hkcode);
      hmibase::appid_t _lastAppId;
      Util::Timer _SWCLongPresstimer;
};


#endif // CGIAPPCONTROLLER_H
