/* ***************************************************************************************
* FILE:          CGIApp.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIApp.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef _CGIAPP_H
#define _CGIAPP_H

#include "HMI/CGIComponents/CGIAppViewFactory.h"
#include "AppHmi_MasterStateMachine.h"
#include "HMI/CGIComponents/CGIAppController.h"
#include "AppBase/CgiApplication.hpp"
#include "Common/Focus/DefaultFocus.h"

class CGIApp : public CgiApplication<AppHmi_MasterStateMachineImpl>
{
   public:
      CGIApp(const char* assetFile, hmibase::services::hmiappctrl::ProxyHandler&);
      virtual ~CGIApp();

   private:
      virtual Focus::FManagerConfigurator* createFocusManagerConfigurator()
      {
         return DefaultFocus::createConfigurator(mViewHandler);
      }
};


#endif /* _CGIAPP_H */
