/**
 * @file         : CabinActivityInfoDPIF.h
 * @author       : INF4CV -  AppHmi_Master Team
 * @brief        : CabinActivityInfoDPIF is provides datapool interface for
 *                 cabin activity
 * @copyright    : (C) 2021 Robert Bosch GmbH
 *                 (C) 2021 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


//////////////////////////////////////////////////////////////////////////////////////////
//
// NOTE:
//  - This file is only for CabinsActivity info datapool helper class implementations
//  - Don't use this for any defines/typedef/structures/enum/constants
//  - Refer README.txt for CabinsActivity info datapool configuration instructions.
//
//////////////////////////////////////////////////////////////////////////////////////////


#ifndef CABIN_ACTIVITY_INFO_DP_IF_H
#define CABIN_ACTIVITY_INFO_DP_IF_H


#include "asf/core/Types.h"


class CabinActivityInfoDPHolder
{
   public:
      /**
       *  Member Functions Declaration
       */
      CabinActivityInfoDPHolder()
      {
         clear();
      }

      virtual ~CabinActivityInfoDPHolder()
      {
         clear();
      }

      CabinActivityInfoDPHolder(const CabinActivityInfoDPHolder& obj)
      {
         clear();
         *this = obj;
      }

      CabinActivityInfoDPHolder& operator = (const CabinActivityInfoDPHolder& obj)
      {
         if (this != &obj)
         {
            clear();
            _sinkId          = obj.getSinkId();
            _sourceId        = obj.getSourceId();
            _subSourceId     = obj.getSubSourceId();
            _lastSourceId    = obj.getLastSourceId();
            _lastSubSourceId = obj.getLastSubSourceId();
            _state           = obj.getState();
            _lastState       = obj.getLastState();
            _activityType    = obj.getActivityType();
            _cabinId         = obj.getCabinId();
         }
         return *this;
      }

      void clear()
      {
         _sinkId          = 255/* SINK_INVALID */;
         _sourceId        = 500/* SRC_INVALID */;
         _subSourceId     = 500/* SRC_INVALID */;
         _lastSourceId    = 500/* SRC_INVALID */;
         _lastSubSourceId = 500/* SRC_INVALID */;
         _state           = 0/* STATE_UNKNOWN */;
         _lastState       = 0/* STATE_UNKNOWN */;
         _activityType    = 0/* CABIN_ACTIVITY_NONE */;
         _cabinId         = 3/* REGION_INVALID */;
      }

      void setSinkId(const int16 sinkId)
      {
         _sinkId = sinkId;
      }

      int16 getSinkId() const
      {
         return _sinkId;
      }

      void setSourceId(const int16 sourceId)
      {
         _sourceId = sourceId;
      }

      int16 getSourceId() const
      {
         return _sourceId;
      }

      void setLastSourceId(const int16 lastSourceId)
      {
         _lastSourceId = lastSourceId;
      }

      int16 getLastSourceId() const
      {
         return _lastSourceId;
      }

      void setState(const uint8 state)
      {
         _state = state;
      }

      uint8 getState() const
      {
         return _state;
      }

      void setLastState(const uint8 lastState)
      {
         _lastState = lastState;
      }

      uint8 getLastState() const
      {
         return _lastState;
      }

      void setActivityType(const uint8 activityType)
      {
         _activityType = activityType;
      }

      uint8 getActivityType() const
      {
         return _activityType;
      }

      void setCabinId(const uint32 cabinId)
      {
         _cabinId = cabinId;
      }

      uint32 getCabinId() const
      {
         return _cabinId;
      }

      void setSubSourceId(const uint32 subSourceId)
      {
         _subSourceId = subSourceId;
      }

      uint32 getSubSourceId() const
      {
         return _subSourceId;
      }

      void setLastSubSourceId(const uint32 lastSubSourceId)
      {
         _lastSubSourceId = lastSubSourceId;
      }

      uint32 getLastSubSourceId() const
      {
         return _lastSubSourceId;
      }

   private:
      /**
       *  Member Variables Declaration
       */
      int16 _sinkId;
      int16 _sourceId;
      int16 _lastSourceId;
      uint8 _state;
      uint8 _lastState;
      uint8 _activityType;
      uint32 _cabinId;
      uint32 _subSourceId;
      uint32 _lastSubSourceId;
};


#endif  /* CABIN_ACTIVITY_INFO_DP_IF_H */
