/**
 * @file         : DataModelSourceDefines.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : DataModelSourceDefines is to handle the DataModelSource
 *                 defines implementation
 * @copyright    : (c) 2020-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */

#ifndef DATA_MODEL_SOURCE_DEFINES_H
#define DATA_MODEL_SOURCE_DEFINES_H


/**
 *   Defines Declaration
 */

#define BEGIN_CONFIGURE_SOURCES_INFO()                                                        \
   SourcesInfo tSourcesInfo;

#define BEGIN_SOURCE_INFO(_key_, _cond_)                                                      \
   if (_cond_)																			                         \
   {																									                \
        SourceInfo tSourceInfo;                                                               \
        tSourceInfo.setSourceKey(_key_);

#define ADD_CONTEXT_ID(_id_)                                                                  \
        tSourceInfo.setContextId(_id_);

#define ADD_SOURCE_NAME(_name_)                                                               \
        tSourceInfo.setSourceName(_name_);

#define ADD_SOURCE_INDEX(_index_)                                                             \
        tSourceInfo.setSourceIndex(_index_);

#define ADD_SOURCE_DEVICE_ID_STATUS(_status_)                                                 \
        tSourceInfo.setSourceDeviceIdStatus(_status_);

#define ADD_SOURCE_ICON_NORMAL_BITMAP(_name_)                                                 \
        tSourceInfo.setSourceIconNormalBitmap(_name_);

#define ADD_SOURCE_ICON_ACTIVE_BITMAP(_name_)                                                 \
        tSourceInfo.setSourceIconActiveBitmap(_name_);

#define ADD_SOURCE_ICON_PRESSED_BITMAP(_name_)                                                \
        tSourceInfo.setSourceIconPressedBitmap(_name_);

#define ADD_SOURCE_ICON_DISABLED_BITMAP(_name_)                                               \
        tSourceInfo.setSourceIconDisabledBitmap(_name_);

#define END_SOURCE_INFO()                                                                     \
        tSourcesInfo.push_back(tSourceInfo);                                                  \
   }

#define END_CONFIGURE_SOURCES_INFO()                                                          \
   return tSourcesInfo;

#define BEGIN_CONFIGURE_REGIONS_SOURCE_INFO()                                                 \
   RegionsSourceInfo tRegionsSourceInfo;

#define BEGIN_REGION(_regionId_, _cond_)                                                      \
   if (_cond_)                                                                                \
   {                                                                                          \
      RegionSourcesInfo tRegionSourcesInfo;                                                   \
      tRegionSourcesInfo.setRegionId(_regionId_);

#define ADD_HK_CODE(_code_)                                                                   \
      tRegionSourcesInfo.setHKCode(_code_);

#define ADD_LIST_ID(_id_)                                                                     \
      tRegionSourcesInfo.setListId(_id_);

#define ADD_SCENE_ID(_id_)                                                                    \
      tRegionSourcesInfo.setSceneId(_id_);

#define ADD_SOURCE_KEY(_key_)                                                                 \
      tRegionSourcesInfo.getMutableSourceKeysInfo().push_back(_key_);

#define END_REGION()                                                                          \
      tRegionsSourceInfo.push_back(tRegionSourcesInfo);                                       \
   }

#define END_CONFIGURE_REGIONS_SOURCE_INFO()                                                   \
   return tRegionsSourceInfo;


#endif /* DATA_MODEL_SOURCE_DEFINES_H */
